/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations.recipes;

import com.dataiku.dip.aigenerations.AIRecipeGenerationService;
import com.dataiku.dip.aigenerations.recipes.AIRecipe;
import com.dataiku.dip.aigenerations.recipes.FilterOperatorValidator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.sampling.SamplingRecipeMeta;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AISampling
extends AIRecipe {
    public static final String type = "sampling";
    public Params params;
    private static final DKULogger logger = DKULogger.getLogger(AISampling.class);

    @Override
    public List<AIRecipeGenerationService.CreationMessage> validate(List<Dataset> datasets, String contextProjectKey, String lang) {
        ArrayList<AIRecipeGenerationService.CreationMessage> creationMessages = new ArrayList<AIRecipeGenerationService.CreationMessage>();
        this.params.checkSingleInputDataset(datasets, type, contextProjectKey);
        this.params.checkSingleOutputDataset(type);
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        if (this.params.sampling_method != null && this.params.sampling_method.equals((Object)AISamplingMethod.RANDOM_FIXED_NUMBER) && this.params.max_records == null) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SAMPLING.UNABLE_TO_DETERMINE_RECORDS_NUM", "We were unable to determine the number of records to keep in the sample, default value will be all records", new Object[0])));
        }
        if (this.params.sampling_method != null && this.params.sampling_method.equals((Object)AISamplingMethod.RANDOM_FIXED_RATIO) && (this.params.target_ratio == null || (double)this.params.target_ratio.floatValue() <= 0.0 || this.params.target_ratio.floatValue() > 1.0f)) {
            creationMessages.add(new AIRecipeGenerationService.CreationMessage(AIRecipeGenerationService.CreationMessage.Level.WARNING, ts.translate(lang, "RIGHT_PANEL.TABS.GENERATE_RECIPE.SAMPLING.UNABLE_TO_DETERMINE_RECORDS_PERCENTAGE", "We were unable to determine a valid percentage of records to keep, default value will be 2%", new Object[0])));
        }
        FilterOperatorValidator.validateFilterConditions(datasets, contextProjectKey, creationMessages, this.params.input_dataset, this.params.conditions, lang);
        return creationMessages;
    }

    @Override
    public AIRecipeGenerationService.AIMetaCreation generateRecipeMetaPayload(AIRecipeGenerationService.RecipeGenerationContext recipeGenerationContext) {
        AIRecipeGenerationService.AIMetaCreation metaCreation = new AIRecipeGenerationService.AIMetaCreation();
        metaCreation.messages = this.validate(recipeGenerationContext.datasets, recipeGenerationContext.contextProjectKey, recipeGenerationContext.lang);
        FilterDesc filterDesc = new FilterDesc();
        filterDesc.distinct = false;
        filterDesc.uiData = new FilterDesc.FilterUiData();
        filterDesc.uiData.mode = this.getSamplingRecipeMode();
        filterDesc.uiData.conditions = FilterOperatorValidator.getConditionsOperators(recipeGenerationContext.datasets, this.params.input_dataset, this.params.conditions, recipeGenerationContext.contextProjectKey, logger);
        filterDesc.enabled = !filterDesc.uiData.conditions.isEmpty();
        metaCreation.datasetInputNames = List.of(this.params.input_dataset);
        metaCreation.datasetOutputNames = List.of(this.params.output_dataset);
        metaCreation.payload = new Gson().toJson((Object)filterDesc);
        return metaCreation;
    }

    public String getSamplingRecipeMode() {
        if (this.params.matching_condition != null && this.params.matching_condition.equals((Object)MatchingCondition.OR)) {
            return "||";
        }
        return "&&";
    }

    public SamplingParam.SamplingMethod getSamplingMethod() {
        if (this.params.sampling_method.equals((Object)AISamplingMethod.RANDOM_FIXED_RATIO)) {
            return SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO;
        }
        if (this.params.sampling_method.equals((Object)AISamplingMethod.RANDOM_FIXED_NUMBER)) {
            return SamplingParam.SamplingMethod.RANDOM_FIXED_NB;
        }
        return SamplingParam.SamplingMethod.FULL;
    }

    public long getMaxRecordsSampling() {
        return this.params.max_records != null ? this.params.max_records : -1L;
    }

    public float getTargetRatioSampling() {
        return this.params.target_ratio != null ? Math.max(Math.min(this.params.target_ratio.floatValue(), 1.0f), 0.0f) : 0.02f;
    }

    public void enrichSerializedRecipeWithSampleSettings(SerializedRecipe sr) {
        SamplingRecipeMeta.SamplingRecipeParams params = (SamplingRecipeMeta.SamplingRecipeParams)sr.params;
        params.selection.samplingMethod = this.getSamplingMethod();
        params.selection.maxRecords = this.getMaxRecordsSampling();
        params.selection.targetRatio = this.getTargetRatioSampling();
        sr.params = params;
    }

    public static class Params
    extends AIRecipe.AIRecipeParams {
        public AISamplingMethod sampling_method;
        @Nullable
        public Long max_records;
        public Float target_ratio;
        @Nullable
        public MatchingCondition matching_condition;
        public List<AIRecipe.FilterCondition> conditions;
    }

    public static enum AISamplingMethod {
        FULL,
        RANDOM_FIXED_NUMBER,
        RANDOM_FIXED_RATIO;

    }

    public static enum MatchingCondition {
        AND,
        OR;

    }
}

