/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.validator.ModelValidator;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class GlobalExplanationsStatusExtractor
implements ModelExtractor<String>,
ModelValidator {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        return GlobalExplanationsStatusExtractor.isCompatible(model) ? "Yes" : "No";
    }

    @Override
    public void validate(ModelDetailsBase model) throws IOException {
        if (!GlobalExplanationsStatusExtractor.isCompatible(model)) {
            throw new IOException("The model is not compatible with Shapley feature importance");
        }
    }

    private static boolean isCompatible(ModelDetailsBase model) throws IOException {
        if (model instanceof ClassicalPredictionModelDetails) {
            ClassicalPredictionModelDetails predictionModel = (ClassicalPredictionModelDetails)model;
            if (predictionModel.coreParams != null && predictionModel.coreParams.partitionedModel != null && predictionModel.coreParams.partitionedModel.enabled) {
                return false;
            }
            return model.fullModelId != null && FullModelId.parse(model.fullModelId).getGlobalExplanationsObservations().isPresent();
        }
        return false;
    }
}

