/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction.flow;

import com.dataiku.dip.analysis.ml.prediction.flow.CausalPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.ClassicalPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.DeepHubPredictionTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.TimeseriesForecastingTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.SplitParams;
import com.dataiku.dip.analysis.model.core.PreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionPreprocessingParams;
import com.dataiku.dip.analysis.model.prediction.assertions.MLAssertionsParams;
import com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.recipes.ParamsWithFixedCodeEnv;
import com.dataiku.dip.recipes.RecipePayloadParams;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPredictionTrainingRecipePayloadParams
extends RecipePayloadParams
implements ParamsWithFixedCodeEnv {
    public SplitParams splitParams;
    public MLTask.BackendType backendType;
    public boolean needsInputDataFolder = false;
    public String envName;
    public CodeEnvSelection envSelection = new CodeEnvSelection();
    public SerializedShakerScript script;
    public Schema expectedPreparationOutputSchema;
    public String generatingModelId;
    public String modelVersionNamePrefix = "";
    public OperationMode operationMode;

    @Override
    public String getCodeEnvName() {
        return this.envName;
    }

    @Override
    public void setCodeEnvName(String envName) {
        this.envName = envName;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
        ArrayList usages = Lists.newArrayList();
        if (this.backendType.isPythonBased()) {
            usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envName, CodeEnvModel.EnvUsage.RECIPE, object.getProjectKey(), object.getId()));
        }
        return usages;
    }

    public abstract ResolvedPredictionCoreParams getCoreParams();

    public abstract PreTrainModelingParams getPreTrainModelingParams();

    public abstract ResolvedPredictionPreprocessingParams getPreprocessing();

    @Nullable
    public abstract MLAssertionsParams getAssertionsParams();

    @Nullable
    public abstract MLOverridesParams getOverridesParams();

    static {
        JSON.registerAdapter(AbstractPredictionTrainingRecipePayloadParams.class, (Object)new JSON.Adapter<AbstractPredictionTrainingRecipePayloadParams>(){

            public AbstractPredictionTrainingRecipePayloadParams deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                JsonObject jsonObj = jsonElement.getAsJsonObject();
                if (jsonObj.has("backendType") && MLTask.BackendType.DEEP_HUB.name().equals(jsonObj.get("backendType").getAsString())) {
                    return (AbstractPredictionTrainingRecipePayloadParams)jsonDeserializationContext.deserialize(jsonElement, DeepHubPredictionTrainingRecipePayloadParams.class);
                }
                JsonObject coreParams = jsonObj.getAsJsonObject("core");
                if (coreParams.has("prediction_type") && PredictionMLTask.PredictionType.TIMESERIES_FORECAST.name().equals(coreParams.get("prediction_type").getAsString())) {
                    return (AbstractPredictionTrainingRecipePayloadParams)jsonDeserializationContext.deserialize(jsonElement, TimeseriesForecastingTrainingRecipePayloadParams.class);
                }
                if (coreParams.has("prediction_type") && (PredictionMLTask.PredictionType.CAUSAL_BINARY_CLASSIFICATION.name().equals(coreParams.get("prediction_type").getAsString()) || PredictionMLTask.PredictionType.CAUSAL_REGRESSION.name().equals(coreParams.get("prediction_type").getAsString()))) {
                    return (AbstractPredictionTrainingRecipePayloadParams)jsonDeserializationContext.deserialize(jsonElement, CausalPredictionTrainingRecipePayloadParams.class);
                }
                return (AbstractPredictionTrainingRecipePayloadParams)jsonDeserializationContext.deserialize(jsonElement, ClassicalPredictionTrainingRecipePayloadParams.class);
            }

            public JsonElement serialize(AbstractPredictionTrainingRecipePayloadParams payload, Type type, JsonSerializationContext ctx) {
                return ctx.serialize((Object)payload);
            }
        });
    }

    public static final class OperationMode
    extends Enum<OperationMode> {
        public static final /* enum */ OperationMode TRAIN_SPLITTED_ONLY = new OperationMode();
        public static final /* enum */ OperationMode TRAIN_SPLITTED_AND_FULL = new OperationMode();
        public static final /* enum */ OperationMode TRAIN_FULL_ONLY = new OperationMode();
        public static final /* enum */ OperationMode TRAIN_KFOLD = new OperationMode();
        private static final /* synthetic */ OperationMode[] $VALUES;

        public static OperationMode[] values() {
            return (OperationMode[])$VALUES.clone();
        }

        public static OperationMode valueOf(String name) {
            return Enum.valueOf(OperationMode.class, name);
        }

        public static OperationMode fromSplitDesc(SplitDesc splitDesc) {
            assert (splitDesc != null);
            if (StringUtils.isNotBlank((String)splitDesc.trainPath) && StringUtils.isNotBlank((String)splitDesc.testPath) && StringUtils.isNotBlank((String)splitDesc.fullPath)) {
                return TRAIN_SPLITTED_AND_FULL;
            }
            if (StringUtils.isNotBlank((String)splitDesc.fullPath)) {
                return TRAIN_KFOLD;
            }
            if (StringUtils.isNotBlank((String)splitDesc.trainPath) && StringUtils.isNotBlank((String)splitDesc.testPath)) {
                return TRAIN_SPLITTED_ONLY;
            }
            throw new IllegalStateException("Split desc has the wrong format, cannot get training operation mode");
        }

        private static /* synthetic */ OperationMode[] $values() {
            return new OperationMode[]{TRAIN_SPLITTED_ONLY, TRAIN_SPLITTED_AND_FULL, TRAIN_FULL_ONLY, TRAIN_KFOLD};
        }

        static {
            $VALUES = OperationMode.$values();
        }
    }
}

