/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.clustering.algorithms.python;

import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringParameterChecks;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.algorithms.python.ScikitAlgorithmMeta;
import com.dataiku.dip.analysis.model.core.WorkSet;
import java.util.ArrayList;
import java.util.List;

public class MiniBatchKmeansMeta
extends ScikitAlgorithmMeta {
    @Override
    public String generateName(PreTrainClusteringModelingParams rpmp) {
        return "Mini-batch KMeans (k=" + rpmp.k + ")";
    }

    @Override
    public String generateDescription(PreTrainClusteringModelingParams rpmp) {
        return "k=" + rpmp.k;
    }

    @Override
    public void validateParameters(ClusteringModelingParams pmp, ClusteringMLTask task, ClusteringParameterChecks checks) {
        ClusteringModelingParams.MiniBatchKMeansParams mbkm = task.modeling.mini_batch_kmeans_clustering;
        if (mbkm.enabled) {
            checks.checkAllPositive(mbkm.kValues(), "Mini-Batch KMeans requires a (positive) number of clusters");
            checks.check(mbkm.n_init > 0, "Mini-Batch KMeans requires a non-zero number of initial centroids");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(ClusteringModelingParams pmp, ClusteringMLTask task) {
        ArrayList<WorkSet.ModelingSet> ret = new ArrayList<WorkSet.ModelingSet>();
        ClusteringModelingParams.MiniBatchKMeansParams mbkm = task.modeling.mini_batch_kmeans_clustering;
        if (mbkm.enabled) {
            for (int k : mbkm.kValues()) {
                PreTrainClusteringModelingParams rcmp = new PreTrainClusteringModelingParams(PreTrainClusteringModelingParams.Algorithm.MiniBatchKMeans);
                rcmp.k = k;
                rcmp.allow_sparse_matrices = mbkm.allow_sparse_matrices;
                rcmp.n_init = mbkm.n_init;
                if (mbkm.seed != 0) {
                    rcmp.seed = mbkm.seed;
                }
                ret.add(new WorkSet.ModelingSet(rcmp));
            }
        }
        return ret;
    }
}

