/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.CategoricalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import java.util.Collections;
import java.util.List;

public class GluonTSNPTSForecasterMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "NPTS";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        PredictionModelingParams.GluonTSNPTSForecasterSpace space = rpmp.gluonts_npts_timeseries_grid;
        ModelTrainInfo.PreSearchDescription description = new ModelTrainInfo.PreSearchDescription(rpmp).withGridLength(this.getSearchSize(rpmp.grid_search_params, space)).withMVParam("Kernel type", space.kernel_type).withMVParam("Exponential kernel weights", space.exp_kernel_weights).withMVParam("Feature scale", space.feature_scale);
        if (!space.full_context) {
            description = description.withMVParam("Context length", space.context_length);
        }
        return description;
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        PredictionModelingParams.GluonTSNPTSForecasterSpace space = before.gluonts_npts_timeseries_grid;
        PostTrainPredictionModelingParams.GluonTSNPTSForecasterParams params = after.gluonts_npts_timeseries_params;
        ModelTrainInfo.PostSearchDescription description = new ModelTrainInfo.PostSearchDescription().withSVParam("Kernel type", params.kernel_type).withSVParam("Exponential kernel weights", params.exp_kernel_weights).withSVParam("Seasonal model", params.use_seasonal_model).withSVParam("Use default time features", params.use_default_time_features).withSVParam("Feature scale", params.feature_scale);
        if (!space.full_context) {
            description = description.withSVParam("Context length", params.context_length);
        }
        return description;
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.GluonTSNPTSForecasterSpace space = pmp.gluonts_npts_timeseries;
        if (space == null || !space.enabled) {
            return;
        }
        checks.checkPositive(space.kernel_type.getLength(), "At least one kernel type must be selected (NPTS)");
        if (!space.full_context) {
            checks.checkNumericalDimension(space.context_length, "Context length (NPTS)");
        }
        checks.checkNumericalDimension(space.exp_kernel_weights, "Decay rate of the exponential distribution (NPTS)");
        checks.checkNumericalDimension(space.feature_scale, "Scale for external and/or seasonal time features (NPTS)");
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.GluonTSNPTSForecasterSpace space = pmp.gluonts_npts_timeseries;
        if (space == null || !space.enabled) {
            return Collections.emptyList();
        }
        PreTrainPredictionModelingParams preTrainParams = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.GLUONTS_NPTS_FORECASTER, pmp);
        preTrainParams.gluonts_npts_timeseries_grid = space;
        preTrainParams.gridLength = this.getSearchSize(preTrainParams.grid_search_params, space);
        WorkSet.ModelingSet modelingSet = new WorkSet.ModelingSet(preTrainParams);
        if (preTrainParams.gridLength > 1) {
            modelingSet.estimatedTrains = preTrainParams.gridLength * gsFolds + 1;
        }
        return Collections.singletonList(modelingSet);
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PostTrainPredictionModelingParams.GluonTSNPTSForecasterParams optimizedParameters = optimized.gluonts_npts_timeseries_params;
        PreTrainPredictionModelingParams preTrainParams = this.getCopyWithGridStrategy(usedToTrain);
        PredictionModelingParams.GluonTSNPTSForecasterSpace space = preTrainParams.gluonts_npts_timeseries_grid;
        if (!preTrainParams.gluonts_npts_timeseries_grid.full_context) {
            space.context_length.setToSingleValueGrid(optimizedParameters.context_length);
        }
        space.exp_kernel_weights.setToSingleValueGrid(optimizedParameters.exp_kernel_weights);
        space.kernel_type = CategoricalHyperparameterDimension.create(optimizedParameters.kernel_type, "exponential", "uniform");
        space.feature_scale.setToSingleValueGrid(optimizedParameters.feature_scale);
        return preTrainParams;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrainParams = this.regridifyToPreTrain(optimized, usedToTrain);
        target.gluonts_npts_timeseries = preTrainParams.gluonts_npts_timeseries_grid;
        target.gluonts_npts_timeseries.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.gluonts_npts_timeseries = usedToTrain.gluonts_npts_timeseries_grid;
        target.gluonts_npts_timeseries.enabled = true;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return true;
    }

    @Override
    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        PredictionModelingParams.GluonTSNPTSForecasterSpace nptsSpace = (PredictionModelingParams.GluonTSNPTSForecasterSpace)space;
        int gridLength = nptsSpace.kernel_type.getLength() * nptsSpace.exp_kernel_weights.getLength() * nptsSpace.feature_scale.getLength();
        if (!nptsSpace.full_context) {
            gridLength *= nptsSpace.context_length.getLength();
        }
        return gridLength;
    }
}

