/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.preprocessing;

import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.utils.ErrorContext;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImageFeaturePreprocessingParams
extends FeaturePreprocessingParams {
    public PretrainedModelsParams pretrainedModelsParams;
    public ImageHandlingMethod image_handling;
    public MissingHandlingMethod missing_handling;
    public boolean impute_invalid_paths = false;
    public String managed_folder_id;
    private static final Logger logger = Logger.getLogger((String)"dku.analysis.preprocessing");

    public ImageFeaturePreprocessingParams() {
        this.type = FeaturePreprocessingParams.FeatureType.IMAGE;
    }

    @Override
    public void check(String featureName, MLTask task) throws Exception {
        if (this.role != FeaturePreprocessingParams.Role.INPUT) {
            return;
        }
        if (this.missing_handling == null) {
            throw ErrorContext.iaef((String)"Feature %s has no missing handling method", (Object)featureName, (Object[])new Object[0]);
        }
        if (this.image_handling == null) {
            throw ErrorContext.iaef((String)"Feature %s has no image handling method", (Object)featureName, (Object[])new Object[0]);
        }
        switch (this.image_handling) {
            case CUSTOM: {
                ErrorContext.checkNotEmpty((String)this.customHandlingCode, (String)("Feature '" + featureName + "' has no custom handling code"));
                if (this.managed_folder_id != null) break;
                throw ErrorContext.iaef((String)"Feature '%s' has no image location, you must provide the managed folder where the images are stored", (Object)featureName, (Object[])new Object[0]);
            }
            case EMBEDDING_EXTRACTION: {
                if (this.pretrainedModelsParams == null) {
                    throw ErrorContext.iaef((String)"Feature '%s' has no selected model, you must select a model to be used to preprocess your images", (Object)featureName, (Object[])new Object[0]);
                }
                ErrorContext.checkNotEmpty((String)this.pretrainedModelsParams.structureRefId, (String)(" image embedding model id. (Please select a model for Feature '" + featureName + "' preprocessing )"));
                if (!(task instanceof PredictionMLTask.ClassicalPredictionMLTask) || !StringUtils.isBlank((String)((PredictionMLTask.ClassicalPredictionMLTask)task).managedFolderSmartId)) break;
                throw ErrorContext.iaef((String)"Feature '%s' has no image location, you must provide the managed folder where the images are stored", (Object)featureName, (Object[])new Object[0]);
            }
            default: {
                throw new Error(String.format("Unsupported image handling '%s'", new Object[]{this.image_handling}));
            }
        }
    }

    @Override
    public boolean usesCustomHandling() {
        if (!this.role.isInput()) {
            return false;
        }
        return !StringUtils.isBlank((String)this.customHandlingCode) && this.image_handling == ImageHandlingMethod.CUSTOM;
    }

    @Override
    public Optional<String> getUsedConnection() {
        if (this.image_handling == ImageHandlingMethod.EMBEDDING_EXTRACTION && this.pretrainedModelsParams != null && this.pretrainedModelsParams.structureRefId != null) {
            return Optional.of(LLMStructuredRef.decodeId((String)this.pretrainedModelsParams.structureRefId).connection);
        }
        return Optional.empty();
    }

    @Override
    public boolean replaceConnections(Map<String, String> connectionsReplacements) {
        if (this.image_handling == ImageHandlingMethod.EMBEDDING_EXTRACTION && this.pretrainedModelsParams != null && this.pretrainedModelsParams.structureRefId != null) {
            LLMStructuredRef oldRef = LLMStructuredRef.decodeId(this.pretrainedModelsParams.structureRefId);
            if (connectionsReplacements.containsKey(oldRef.connection)) {
                String newConnection = connectionsReplacements.get(oldRef.connection);
                this.pretrainedModelsParams.structureRefId = oldRef.withOtherConnection(newConnection).encodeToId();
                return true;
            }
        }
        return false;
    }

    public static enum MissingHandlingMethod {
        NONE,
        DROP_ROW,
        IMPUTE;

    }

    public static enum ImageHandlingMethod {
        CUSTOM,
        EMBEDDING_EXTRACTION;


        public String getDisplayLabel() {
            switch (this) {
                case CUSTOM: {
                    return "Custom";
                }
                case EMBEDDING_EXTRACTION: {
                    return "Image embedding";
                }
            }
            logger.warn((Object)("Unsupported image_handling type: " + String.valueOf((Object)this)));
            return "";
        }
    }

    public static class PretrainedModelsParams {
        public String structureRefId;
    }
}

