/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.apideployer.infra.ApiNodeK8SInfraManager;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.cluster.ClusterSelection;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.exposition.ClusterIPExposition;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.exposition.LoadBalancerExposition;
import com.dataiku.dip.exposition.NginxIngressExposition;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

public class K8SAPIDeploymentInfra
extends AbstractAPIDockerDeploymentInfra {
    public ClusterSelection cluster = new ClusterSelection();
    public String k8sContext;
    private String k8sNamespace;
    public String k8sConfigPath;
    public List<SimpleKeyValue> k8sProperties = new ArrayList<SimpleKeyValue>();
    public List<SimpleKeyValue> additionalEnvVars = new ArrayList<SimpleKeyValue>();
    public boolean useSecretToDefineEnvVars;
    public boolean allowAdditionalEnvVarsInDeployments;
    public List<SimpleKeyValue> additionalLabels = new ArrayList<SimpleKeyValue>();
    public boolean allowAdditionalLabelsInDeployments;
    public List<SimpleKeyValue> additionalAnnotations = new ArrayList<SimpleKeyValue>();
    public boolean allowAdditionalAnnotationsInDeployments;
    public String serviceAccountName;
    public boolean allowOverridingServiceAccountNameInDeployments;
    public Exposition defaultServiceExposition = K8SAPIDeploymentInfra.makeDefaultExposition();
    public K8SContainerLimits defaultContainerLimits = new K8SContainerLimits();
    public K8SAPINodeServerSizing defaultApiNodeServerSizing = new K8SAPINodeServerSizing();
    public K8SDeploymentScaling defaultDeploymentScaling = new K8SDeploymentScaling();
    public K8SDeploymentPodDisruptionBudget defaultDeploymentPodDisruptionBudget = new K8SDeploymentPodDisruptionBudget();
    public String defaultDeploymentTopologySpreadConstraints;
    public K8SYamlModifier defaultDeploymentModifier = new K8SYamlModifier();
    public boolean enableOpenshiftCompatibility = true;

    private K8SAPIDeploymentInfra() {
    }

    public K8SAPIDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
        NodesDirectory nd = ((NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class)).getNodesDirectoryUnsafe_AutoTXN();
        this.activityMonitoringSettings = nd.enabled ? new ActivityMonitoringSettings.PushAuto() : new ActivityMonitoringSettings.Disabled();
    }

    @Nonnull
    public static K8SAPIDeploymentInfra buildDefault_NT(String infraId, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        K8SAPIDeploymentInfra k8sInfra = new K8SAPIDeploymentInfra(infraId, stage, userIdentifier, governCheckPolicy);
        k8sInfra.buildIntermediateImageWithCodeEnvs = true;
        k8sInfra.enableOpenshiftCompatibility = false;
        k8sInfra.useSecretToDefineEnvVars = true;
        return k8sInfra;
    }

    @Nonnull
    public static K8SAPIDeploymentInfra buildDefaultForCloud_NT(String infraId, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy, @Nonnull GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings cloudSettings) {
        K8SAPIDeploymentInfra k8sInfra = K8SAPIDeploymentInfra.buildDefault_NT(infraId, stage, userIdentifier, governCheckPolicy);
        k8sInfra.imagesNamePrefix = "";
        k8sInfra.cluster.clusterMode = cloudSettings.clusterMode;
        k8sInfra.setRegistryHost(cloudSettings.k8sRegistryHost);
        k8sInfra.setK8sNamespace(cloudSettings.k8sNamespace);
        k8sInfra.imagesNamePrefix = cloudSettings.imagesNamePrefix;
        k8sInfra.baseImageTag = cloudSettings.baseImageTag;
        ArrayList<SimpleKeyValue> k8sProperties = new ArrayList<SimpleKeyValue>(ListUtils.emptyIfNull(cloudSettings.k8sProperties));
        k8sProperties.add(new SimpleKeyValue("kubernetes.version", cloudSettings.k8sVersion));
        k8sInfra.k8sProperties = k8sProperties;
        k8sInfra.defaultApiNodeServerSizing = cloudSettings.serverSizing;
        k8sInfra.defaultDeploymentScaling = cloudSettings.deploymentScaling;
        k8sInfra.defaultContainerLimits = cloudSettings.containerLimits;
        k8sInfra.defaultServiceExposition = K8SAPIDeploymentInfra.makeDefaultCloudExposition(cloudSettings.expositionSettings);
        k8sInfra.activityMonitoringSettings = K8SAPIDeploymentInfra.makeDefaultCloudActivityMonitoringSettings(cloudSettings.activityMonitoringSettings);
        return k8sInfra;
    }

    @Override
    public AbstractDeploymentInfra.InfraType getInfraType() {
        return AbstractDeploymentInfra.InfraType.K8S;
    }

    @Override
    public ApiNodeInfraManager getInfraManager(DKULogger logger) {
        return new ApiNodeK8SInfraManager(this);
    }

    public String getK8sNamespace() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.k8sNamespace, (CharSequence)"default");
    }

    public void setK8sNamespace(String value) {
        this.k8sNamespace = value;
    }

    public static Exposition makeDefaultExposition() {
        return new Exposition().withType(LoadBalancerExposition.META.getType()).withParams(K8SAPIDeploymentInfra.instantiateParams(LoadBalancerExposition.META.getParamsClass()));
    }

    public static Exposition makeDefaultCloudExposition(GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings.CloudExpositionSettings cloudSettings) {
        if (cloudSettings == null) {
            throw new IllegalArgumentException("cloudSettings must not be null");
        }
        if (cloudSettings.isPublic) {
            NginxIngressExposition.NginxIngressExpositionParams params = (NginxIngressExposition.NginxIngressExpositionParams)K8SAPIDeploymentInfra.instantiateParams(NginxIngressExposition.META.getParamsClass());
            params.scheme = cloudSettings.httpScheme;
            params.rewriteToRoot = cloudSettings.rewriteToRoot;
            params.extraHosts = new ArrayList(ListUtils.emptyIfNull(cloudSettings.additionalHosts));
            return new Exposition().withType(NginxIngressExposition.META.getType()).withParams(params);
        }
        return new Exposition().withType(ClusterIPExposition.META.getType()).withParams(K8SAPIDeploymentInfra.instantiateParams(ClusterIPExposition.META.getParamsClass()));
    }

    public static ActivityMonitoringSettings makeDefaultCloudActivityMonitoringSettings(GeneralSettingsDAO.DataikuCloudK8SApiDeploymentSettings.CloudActivityMonitoringSettings cloudSettings) {
        if (cloudSettings == null) {
            throw new IllegalArgumentException("cloudSettings must not be null");
        }
        ActivityMonitoringSettings.PushExplicit settings = new ActivityMonitoringSettings.PushExplicit();
        settings.activityServerAPIURL = cloudSettings.endpoint;
        settings.apiKey = cloudSettings.apiKey;
        settings.trustAllSSLCertificates = cloudSettings.trustAllCertificates;
        return settings;
    }

    private static ExpositionParams instantiateParams(Class<? extends ExpositionParams> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate params class: " + clazz.getName(), e);
        }
    }

    public static class K8SContainerLimits
    implements IK8SContainerLimits {
        public int memRequestMB = -1;
        public int memLimitMB = -1;
        public double cpuRequest = -1.0;
        public double cpuLimit = -1.0;
        public String nodeSelector;
        public String tolerations;
        public String affinity;
        public ClusterPropertyList customLimits = new ClusterPropertyList();
        public ClusterPropertyList customRequests = new ClusterPropertyList();

        public K8SContainerLimits() {
        }

        public K8SContainerLimits(K8SContainerLimits k8SContainerLimits) {
            this.memRequestMB = k8SContainerLimits.memRequestMB;
            this.memLimitMB = k8SContainerLimits.memLimitMB;
            this.cpuRequest = k8SContainerLimits.cpuRequest;
            this.cpuLimit = k8SContainerLimits.cpuLimit;
            this.nodeSelector = k8SContainerLimits.nodeSelector;
            this.tolerations = k8SContainerLimits.tolerations;
            this.affinity = k8SContainerLimits.affinity;
            this.customLimits = k8SContainerLimits.customLimits.deepCopy();
            this.customRequests = k8SContainerLimits.customRequests.deepCopy();
        }

        public static K8SContainerLimits forCloud() {
            K8SContainerLimits config = new K8SContainerLimits();
            config.memRequestMB = 500;
            config.memLimitMB = 500;
            config.cpuRequest = 1.0;
            config.cpuLimit = -1.0;
            return config;
        }

        public K8SContainerLimits deepCopy() {
            return new K8SContainerLimits(this);
        }

        public boolean hasRequests() {
            return this.cpuRequest > 0.0 || this.memRequestMB > 0 || !this.customRequests.isEmpty();
        }

        public boolean hasLimits() {
            return this.cpuLimit > 0.0 || this.memLimitMB > 0 || !this.customLimits.isEmpty();
        }

        public int getMemRequestMB() {
            return this.memRequestMB;
        }

        public int getMemLimitMB() {
            return this.memLimitMB;
        }

        public double getCpuRequest() {
            return this.cpuRequest;
        }

        public double getCpuLimit() {
            return this.cpuLimit;
        }
    }

    public static class K8SAPINodeServerSizing {
        public String apimainXmx = "1g";
        public String apimainGC = "g1";
        public String apimainAdditionalOpts;

        public static K8SAPINodeServerSizing forCloud() {
            K8SAPINodeServerSizing config = new K8SAPINodeServerSizing();
            config.apimainXmx = "1g";
            config.apimainGC = "g1";
            return config;
        }
    }

    public static class K8SDeploymentScaling {
        public int initialReplicas = 3;
        public int progressDeadlineSeconds = 600;
        public boolean hpa;
        public int hpaTargetCPUPercent;
        public int hpaTargetMemoryPercent;
        public List<K8SAutoscalerMetric> hpaMetrics = new ArrayList<K8SAutoscalerMetric>();
        public String hpaExtraMetrics;
        public int hpaMinPods;
        public int hpaMaxPods;
        public List<SimpleKeyValue> hpaAnnotations = new ArrayList<SimpleKeyValue>();

        public static K8SDeploymentScaling forCloud() {
            K8SDeploymentScaling config = new K8SDeploymentScaling();
            config.initialReplicas = 2;
            config.progressDeadlineSeconds = 600;
            return config;
        }
    }

    public static class K8SDeploymentPodDisruptionBudget {
        public boolean enable;
        public boolean isMaxUnavailable;
        public String minAvailable;
        public String maxUnavailable;
    }

    public static class K8SYamlModifier {
        public String runnableType;
        public JsonObject config = new JsonObject();

        public JsonObject getSensitiveSettings() {
            JsonObject ret = new JsonObject();
            ret.addProperty("runnableType", this.runnableType);
            ret.add("config", (JsonElement)this.config);
            return ret;
        }
    }

    public static class K8SAutoscalerMetric {
        public String type;
        public String name;
        public boolean utilization;
        public String value;
    }
}

