/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.code.AvailablePythonInterpretersService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DSSCodeEnvSettingsProvider;
import com.dataiku.dip.code.DesignNodeCodeEnvsAccessService;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.dataflow.cde.NoopCDEImageBuilderService;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.NoopFutureKernelsManager;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.FakePermissionsService;
import com.dataiku.dip.security.impersonation.NoopImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.NoopJupyterService;
import com.dataiku.dip.server.services.NoopPubSubService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class BuildCDEPluginCodeEnv
extends CLICommand {
    public static final String ERROR_CDE_REBUILD_CODE_ENV = "Failed to rebuild code-env";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.internalcmd.codeenv");

    @Override
    public String usageString() {
        return "__build_cde_plugin_code_env -names <name1>,<name2>,<name3>";
    }

    @Override
    public String description() {
        return "Build a code-env. Specific for CDE image build, no other usage expected";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        options.addOption(Option.builder((String)"names").longOpt("names").hasArg().required().type(String.class).build());
        options.addOption(Option.builder((String)"threads").longOpt("threads").hasArg().type(String.class).build());
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        int tCount;
        CommandLine cmdLine = this.parseAndMiniSetup(args, "__build_cde_plugin_code_env", true);
        String names = (String)cmdLine.getParsedOptionValue("names");
        String threadCount = (String)cmdLine.getParsedOptionValue("threads");
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        DesignNodeCodeEnvsService service = this.getDesignNodeCodeEnvsService();
        CodeEnvModel.CodeEnvUpdateSettings updateSettings = new CodeEnvModel.CodeEnvUpdateSettings();
        updateSettings.forceRebuildEnv = true;
        DSSAuthCtx authCtx = DSSAuthCtx.newNone();
        CodeEnvModel.EnvLang envLang = CodeEnvModel.EnvLang.PYTHON;
        if (StringUtils.isNotBlank((String)threadCount)) {
            tCount = Integer.parseInt(threadCount);
            logger.info((Object)("Thread count is overridden: " + tCount));
        } else {
            tCount = Runtime.getRuntime().availableProcessors() - 1;
            logger.info((Object)("Thread count is computed: " + tCount));
        }
        ExecutorService es = Executors.newFixedThreadPool(tCount);
        for (String name : names.split(",")) {
            logger.info((Object)("Updating packages of " + name + " of type " + String.valueOf((Object)envLang)));
            es.submit(() -> {
                String error = "Failed to rebuild code-env " + name;
                try {
                    CodeEnvModel.EnvUpdateResult ret = service.updateEnvAccordingToSpec(authCtx, envLang, name, updateSettings, null, new DKUtils.SmartLogTailBuilder(), true, true);
                    if (ret.messages.error) {
                        logger.error((Object)(error + "\n" + ret.messages.report()));
                        Runtime.getRuntime().halt(1);
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)error, t);
                    Runtime.getRuntime().halt(1);
                }
            });
        }
        es.shutdown();
        if (!es.awaitTermination(3L, TimeUnit.HOURS)) {
            throw new RuntimeException("Code env executor has terminated in a timeout!!");
        }
        return 0;
    }

    @VisibleForTesting
    DesignNodeCodeEnvsService getDesignNodeCodeEnvsService() throws IOException {
        AnnotationConfigApplicationContext appContext = CLISetup.doSpringUtilsAndCoreServicesSetup();
        appContext.register(new Class[]{NoopImpersonationResolverService.class});
        appContext.register(new Class[]{DSSCodeEnvSettingsProvider.class});
        appContext.register(new Class[]{NoopCDEImageBuilderService.class});
        appContext.register(new Class[]{NoopPubSubService.class});
        appContext.register(new Class[]{FakePermissionsService.class});
        appContext.register(new Class[]{RegularPluginsRegistryService.class});
        appContext.register(new Class[]{NoopJupyterService.class});
        appContext.register(new Class[]{ScenarioRunContext.class});
        appContext.register(new Class[]{FutureService.class});
        appContext.register(new Class[]{NoopFutureKernelsManager.class});
        appContext.register(new Class[]{DesignNodeCodeEnvsAccessService.class});
        appContext.register(new Class[]{AvailablePythonInterpretersService.class});
        appContext.register(new Class[]{DesignNodeCodeEnvsService.class});
        return (DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class);
    }
}

