/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.spark.SparkExecutionConfig;
import org.apache.commons.lang.StringUtils;

public class ClusterSettings {
    public static final String NO_IMPLICIT_AND_NO_EXPLICIT_CLUSTER = "No default Kubernetes cluster selected and option `use builtin Kubernetes cluster` is disabled";
    private final String clusterId;
    private final HadoopSettings hadoopSettings;
    private final HiveSettings hiveSettings;
    private final ImpalaSettings impalaSettings;
    private final SparkSettings sparkSettings;
    private final ContainerSettings containerSettings;
    public transient String overridenFromK8SClusterId;
    private boolean noImplicitK8sClusterAndNoDefaultClusterId = false;

    public ClusterSettings() {
        this.clusterId = null;
        this.hadoopSettings = new HadoopSettings();
        this.hiveSettings = new HiveSettings();
        this.impalaSettings = new ImpalaSettings();
        this.sparkSettings = new SparkSettings();
        this.containerSettings = new ContainerSettings();
    }

    ClusterSettings(String clusterId, GeneralSettingsDAO.GeneralSettings generalSettings) {
        this.clusterId = clusterId;
        this.hadoopSettings = generalSettings.hadoopSettings;
        this.hiveSettings = generalSettings.hiveSettings;
        this.impalaSettings = generalSettings.impalaSettings;
        this.sparkSettings = generalSettings.sparkSettings;
        this.containerSettings = generalSettings.containerSettings;
        this.noImplicitK8sClusterAndNoDefaultClusterId = !generalSettings.useImplicitK8sCluster && StringUtils.isBlank((String)generalSettings.defaultK8sClusterId);
    }

    ClusterSettings(String clusterId, HadoopSettings hadoopSettings, HiveSettings hiveSettings, ImpalaSettings impalaSettings, SparkSettings sparkSettings, ContainerSettings containerSettings, boolean noImplicitK8sClusterAndNoDefaultClusterId) {
        this.clusterId = clusterId;
        this.hadoopSettings = hadoopSettings;
        this.hiveSettings = hiveSettings;
        this.impalaSettings = impalaSettings;
        this.sparkSettings = sparkSettings;
        this.containerSettings = containerSettings;
        this.noImplicitK8sClusterAndNoDefaultClusterId = noImplicitK8sClusterAndNoDefaultClusterId;
    }

    public ClusterSettings(ClusterSettings clusterSettings) {
        this.clusterId = clusterSettings.clusterId;
        this.hadoopSettings = clusterSettings.hadoopSettings != null ? clusterSettings.hadoopSettings.deepCopy() : null;
        this.hiveSettings = clusterSettings.hiveSettings != null ? clusterSettings.hiveSettings.deepCopy() : null;
        this.impalaSettings = clusterSettings.impalaSettings != null ? clusterSettings.impalaSettings.deepCopy() : null;
        this.sparkSettings = clusterSettings.sparkSettings != null ? clusterSettings.sparkSettings.deepCopy() : null;
        this.containerSettings = clusterSettings.containerSettings != null ? clusterSettings.containerSettings.deepCopy() : null;
        this.overridenFromK8SClusterId = clusterSettings.overridenFromK8SClusterId;
        this.noImplicitK8sClusterAndNoDefaultClusterId = clusterSettings.noImplicitK8sClusterAndNoDefaultClusterId;
    }

    public ClusterSettings deepCopy() {
        return new ClusterSettings(this);
    }

    public static ClusterSettings makeFromHadoopSettings(HadoopSettings hadoopSettings) {
        if (hadoopSettings == null) {
            hadoopSettings = new HadoopSettings();
        }
        return new ClusterSettings("__NOOP__", hadoopSettings, new HiveSettings(), new ImpalaSettings(), new SparkSettings(), new ContainerSettings(), true);
    }

    public HadoopSettings getHadoopSettings() {
        return this.hadoopSettings;
    }

    public HiveSettings getHiveSettings() {
        return this.hiveSettings;
    }

    public ImpalaSettings getImpalaSettings() {
        return this.impalaSettings;
    }

    public SparkSettings getSparkSettings() {
        if (this.sparkSettings != null) {
            for (SparkExecutionConfig conf : this.sparkSettings.executionConfigs) {
                conf.kubernetesSettings.noImplicitK8sClusterAndNoDefaultClusterId = this.noImplicitK8sClusterAndNoDefaultClusterId;
            }
        }
        return this.sparkSettings;
    }

    public ContainerSettings getContainerSettings() {
        if (this.containerSettings != null) {
            for (ContainerExecRuntimeConfig conf : this.containerSettings.executionConfigs) {
                conf.noImplicitK8sClusterAndNoDefaultClusterId = this.noImplicitK8sClusterAndNoDefaultClusterId;
            }
        }
        return this.containerSettings;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void k8sClusterDefined() {
        this.noImplicitK8sClusterAndNoDefaultClusterId = false;
    }

    public boolean isNoImplicitK8sClusterAndNoDefaultClusterId() {
        return this.noImplicitK8sClusterAndNoDefaultClusterId;
    }

    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.hadoopSettings.decryptFields(cryptoService);
        this.hiveSettings.decryptFields(cryptoService);
        this.impalaSettings.decryptFields(cryptoService);
        this.sparkSettings.decryptFields(cryptoService);
        this.containerSettings.decryptFields(cryptoService);
    }
}

