/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.security.PasswordEncryptionService;

public class HadoopSettings {
    public boolean kerberosLoginEnabled;
    public String dssPrincipal;
    public String dssKeytabPath;
    public ClusterPropertyList extraConf = new ClusterPropertyList();
    public ClusterPropertyList validationKernelsExtraEnv = new ClusterPropertyList();

    public HadoopSettings() {
    }

    public HadoopSettings(HadoopSettings hadoopSettings) {
        this.kerberosLoginEnabled = hadoopSettings.kerberosLoginEnabled;
        this.dssPrincipal = hadoopSettings.dssPrincipal;
        this.dssKeytabPath = hadoopSettings.dssKeytabPath;
        this.extraConf = hadoopSettings.extraConf.deepCopy();
        this.validationKernelsExtraEnv = hadoopSettings.validationKernelsExtraEnv.deepCopy();
    }

    public HadoopSettings deepCopy() {
        return new HadoopSettings(this);
    }

    public void encryptFields(PasswordEncryptionService cryptoService) {
        for (ClusterProperty property : this.extraConf) {
            if (!property.secret) continue;
            property.value = cryptoService.encryptIfNotEncryptedOrEmpty(property.value);
        }
    }

    public void decryptFields(PasswordEncryptionService cryptoService) {
        for (ClusterProperty property : this.extraConf) {
            if (!property.secret) continue;
            property.value = cryptoService.decryptIfEncrypted(property.value);
        }
    }
}

