/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.hive.HiveExecutionConfig;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class HiveOverrideMask {
    public boolean enabled;
    public boolean jdbc;
    public boolean properties;
    public boolean canChart;
    public boolean engineCreationSettings;
    public boolean overrideDatabaseInLocalMetastore;
    public boolean additionalUserToGrantAccessToWhenImpersonating;
    public boolean addWriteACLOnDataUsabilityACL;
    public boolean preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes;
    public boolean preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes;
    public boolean queryAlterations;
    public boolean configForHiveRuntime;

    public static HiveOverrideMask fromJsonObject(JsonObject settings) {
        HiveOverrideMask mask = new HiveOverrideMask();
        if (settings == null) {
            return mask;
        }
        mask.enabled = true;
        if (settings.has("useURL") && !settings.get("useURL").isJsonNull()) {
            mask.jdbc = true;
        }
        if (settings.has("hiveServer2Host") && !settings.get("hiveServer2Host").isJsonNull()) {
            mask.jdbc = true;
        }
        if (settings.has("executionConfigs") && !settings.get("executionConfigs").isJsonNull()) {
            mask.properties = true;
        }
        if (settings.has("executionConfigsGenericOverrides") && !settings.get("executionConfigsGenericOverrides").isJsonNull()) {
            mask.properties = true;
        }
        if (settings.has("canChart") && !settings.get("canChart").isJsonNull()) {
            mask.canChart = true;
        }
        if (settings.has("engineCreationSettings") && !settings.get("engineCreationSettings").isJsonNull()) {
            mask.engineCreationSettings = true;
        }
        if (settings.has("overrideDatabaseInLocalMetastore") && !settings.get("overrideDatabaseInLocalMetastore").isJsonNull()) {
            mask.overrideDatabaseInLocalMetastore = true;
        }
        if (settings.has("additionalUserToGrantAccessToWhenImpersonating") && !settings.get("additionalUserToGrantAccessToWhenImpersonating").isJsonNull()) {
            mask.additionalUserToGrantAccessToWhenImpersonating = true;
        }
        if (settings.has("addWriteACLOnDataUsabilityACL") && !settings.get("addWriteACLOnDataUsabilityACL").isJsonNull()) {
            mask.addWriteACLOnDataUsabilityACL = true;
        }
        if (settings.has("preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes") && !settings.get("preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes").isJsonNull()) {
            mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes = true;
        }
        if (settings.has("preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes") && !settings.get("preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes").isJsonNull()) {
            mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes = true;
        }
        if (settings.has("addCompressionCommands") && !settings.get("addCompressionCommands").isJsonNull()) {
            mask.queryAlterations = true;
        }
        if (settings.has("configForHiveRuntime") && !settings.get("configForHiveRuntime").isJsonNull()) {
            mask.configForHiveRuntime = true;
        }
        return mask;
    }

    public HiveSettings apply(HiveSettings base, HiveSettings overrides) {
        HiveSettings overriden = (HiveSettings)JSON.deepCopy((Object)base);
        if (!this.enabled) {
            return overriden;
        }
        overriden.enabled = overrides.enabled;
        if (this.jdbc) {
            overriden.connectionProperties = overrides.connectionProperties;
            overriden.hiveServer2Host = overrides.hiveServer2Host;
            overriden.hiveServer2Port = overrides.hiveServer2Port;
            overriden.hiveServer2Principal = overrides.hiveServer2Principal;
            overriden.useURL = overrides.useURL;
            overriden.extraUrl = overrides.extraUrl;
            overriden.displayedUrl = overrides.displayedUrl;
            overriden.url = overrides.url;
            overriden.driver = overrides.driver;
        }
        if (this.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes) {
            overriden.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes = overrides.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes;
        }
        if (this.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes) {
            overriden.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes = overrides.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes;
        }
        if (this.additionalUserToGrantAccessToWhenImpersonating) {
            overriden.additionalUserToGrantAccessToWhenImpersonating = overrides.additionalUserToGrantAccessToWhenImpersonating;
        }
        if (this.engineCreationSettings) {
            overriden.engineCreationSettings = overrides.engineCreationSettings;
        }
        if (this.canChart) {
            overriden.canChart = overrides.canChart;
        }
        if (this.overrideDatabaseInLocalMetastore) {
            overriden.overrideDatabaseInLocalMetastore = overrides.overrideDatabaseInLocalMetastore;
        }
        if (this.addWriteACLOnDataUsabilityACL) {
            overriden.addWriteACLOnDataUsabilityACL = overrides.addWriteACLOnDataUsabilityACL;
        }
        if (this.queryAlterations) {
            overriden.auxJarsAndUdfs = overrides.auxJarsAndUdfs;
            overriden.initQueryPreStatements = overrides.initQueryPreStatements;
            overriden.initQueryPostStatements = overrides.initQueryPostStatements;
            overriden.addCompressionCommands = overrides.addCompressionCommands;
            overriden.hiveAdditionalJars = overrides.hiveAdditionalJars;
        }
        if (this.configForHiveRuntime) {
            overriden.configForHiveRuntime = overrides.configForHiveRuntime;
        }
        if (this.properties) {
            HashMap baseConfigs = Maps.newHashMap();
            for (HiveExecutionConfig hiveExecutionConfig : base.executionConfigs) {
                baseConfigs.put(hiveExecutionConfig.name, hiveExecutionConfig);
            }
            HashMap overridesConfigs = Maps.newHashMap();
            for (HiveExecutionConfig config : overrides.executionConfigs) {
                overridesConfigs.put(config.name, config);
            }
            HashSet hashSet = Sets.newHashSet();
            hashSet.addAll(baseConfigs.keySet());
            hashSet.addAll(overridesConfigs.keySet());
            ArrayList configs = Lists.newArrayList();
            for (String name : hashSet) {
                HiveExecutionConfig baseConfig = (HiveExecutionConfig)baseConfigs.get(name);
                HiveExecutionConfig overridesConfig = (HiveExecutionConfig)overridesConfigs.get(name);
                if (baseConfig != null && overridesConfig != null) {
                    overridesConfig.conf = baseConfig.conf.getOverriden(overridesConfig.conf);
                    configs.add(overridesConfig);
                    continue;
                }
                if (baseConfig != null) {
                    configs.add(baseConfig);
                    continue;
                }
                configs.add(overridesConfig);
            }
            ArrayList configsWithGenericOverrides = Lists.newArrayList();
            for (HiveExecutionConfig config : configs) {
                HiveExecutionConfig configWithGenericOverrides = new HiveExecutionConfig();
                configWithGenericOverrides.name = config.name;
                configWithGenericOverrides.conf = config.conf.getOverriden(overrides.executionConfigsGenericOverrides);
                configsWithGenericOverrides.add(configWithGenericOverrides);
            }
            overriden.executionConfigs = configsWithGenericOverrides;
        }
        return overriden;
    }
}

