/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.hive.HiveExecutionConfig;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.security.PasswordEncryptionService;
import java.util.ArrayList;
import java.util.List;

public class HiveSettings {
    public boolean enabled = true;
    public String hiveAdditionalJars;
    public String hiveSparkHome;
    public GlobalHiveEngineCreationSettings engineCreationSettings = new GlobalHiveEngineCreationSettings();
    public boolean overrideDatabaseInLocalMetastore = false;
    public String hiveServer2Host = "127.0.0.1";
    public int hiveServer2Port = 10000;
    public String hiveServer2Principal;
    public String extraUrl;
    public ClusterPropertyList connectionProperties = new ClusterPropertyList();
    public String additionalUserToGrantAccessToWhenImpersonating = "hive";
    public boolean addWriteACLOnDataUsabilityACL = false;
    public boolean preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes = true;
    public boolean preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes = false;
    public String auxJarsAndUdfs;
    public String initQueryPreStatements;
    public String initQueryPostStatements;
    public boolean addCompressionCommands = false;
    public ClusterPropertyList executionConfigsGenericOverrides = new ClusterPropertyList();
    public List<HiveExecutionConfig> executionConfigs = new ArrayList<HiveExecutionConfig>();
    public boolean useURL;
    public String driver;
    public String url;
    public String displayedUrl;
    public boolean canChart;
    public String configForHiveRuntime = "default";

    public static boolean urlContainsSecret() {
        return ApplicationConfigurator.getParams().getBoolParam("dku.hadoop.hive.hiveServer2URLContainsSecret", false);
    }

    public HiveSettings() {
    }

    public HiveSettings(HiveSettings hiveSettings) {
        this.enabled = hiveSettings.enabled;
        this.hiveAdditionalJars = hiveSettings.hiveAdditionalJars;
        this.hiveSparkHome = hiveSettings.hiveSparkHome;
        this.engineCreationSettings = hiveSettings.engineCreationSettings.deepCopy();
        this.overrideDatabaseInLocalMetastore = hiveSettings.overrideDatabaseInLocalMetastore;
        this.hiveServer2Host = hiveSettings.hiveServer2Host;
        this.hiveServer2Port = hiveSettings.hiveServer2Port;
        this.hiveServer2Principal = hiveSettings.hiveServer2Principal;
        this.extraUrl = hiveSettings.extraUrl;
        this.connectionProperties = hiveSettings.connectionProperties.deepCopy();
        this.additionalUserToGrantAccessToWhenImpersonating = hiveSettings.additionalUserToGrantAccessToWhenImpersonating;
        this.addWriteACLOnDataUsabilityACL = hiveSettings.addWriteACLOnDataUsabilityACL;
        this.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes = hiveSettings.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes;
        this.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes = hiveSettings.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes;
        this.auxJarsAndUdfs = hiveSettings.auxJarsAndUdfs;
        this.initQueryPreStatements = hiveSettings.initQueryPreStatements;
        this.initQueryPostStatements = hiveSettings.initQueryPostStatements;
        this.addCompressionCommands = hiveSettings.addCompressionCommands;
        this.executionConfigsGenericOverrides = hiveSettings.executionConfigsGenericOverrides.deepCopy();
        hiveSettings.executionConfigs.forEach(cfg -> this.executionConfigs.add(cfg.deepCopy()));
        this.useURL = hiveSettings.useURL;
        this.driver = hiveSettings.driver;
        this.url = hiveSettings.url;
        this.displayedUrl = hiveSettings.displayedUrl;
        this.canChart = hiveSettings.canChart;
        this.configForHiveRuntime = hiveSettings.configForHiveRuntime;
    }

    public HiveSettings deepCopy() {
        return new HiveSettings(this);
    }

    public void encryptFields(PasswordEncryptionService cryptoService) {
        for (ClusterProperty property : this.connectionProperties) {
            if (!property.secret) continue;
            property.value = cryptoService.encryptIfNotEncryptedOrEmpty(property.value);
        }
        for (HiveExecutionConfig executionConfig : this.executionConfigs) {
            for (ClusterProperty property : executionConfig.conf) {
                if (!property.secret) continue;
                property.value = cryptoService.encryptIfNotEncryptedOrEmpty(property.value);
            }
        }
        if (HiveSettings.urlContainsSecret()) {
            this.url = cryptoService.encryptIfNotEncryptedOrEmpty(this.url);
        }
    }

    public void decryptFields(PasswordEncryptionService cryptoService) {
        for (ClusterProperty property : this.connectionProperties) {
            if (!property.secret) continue;
            property.value = cryptoService.decryptIfEncrypted(property.value);
        }
        for (HiveExecutionConfig executionConfig : this.executionConfigs) {
            for (ClusterProperty property : executionConfig.conf) {
                if (!property.secret) continue;
                property.value = cryptoService.decryptIfEncrypted(property.value);
            }
        }
    }

    public static class GlobalHiveEngineCreationSettings {
        public HiveRecipeMeta.HiveExecutionEngine executionEngine = HiveRecipeMeta.HiveExecutionEngine.HIVESERVER2;
        public String executionConfig;

        GlobalHiveEngineCreationSettings() {
        }

        GlobalHiveEngineCreationSettings(GlobalHiveEngineCreationSettings settings) {
            this.executionEngine = settings.executionEngine;
            this.executionConfig = settings.executionConfig;
        }

        GlobalHiveEngineCreationSettings deepCopy() {
            return new GlobalHiveEngineCreationSettings(this);
        }
    }
}

