/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.sql.NetezzaSQLDialect;

public class NetezzaConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public static final String connectionType = "Netezza";
    protected Params params = new Params();
    private static NetezzaSQLDialect dialect;

    @Override
    public AbstractSQLConnection.AbstractSQLParams getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public NetezzaSQLDialect getDialect() {
        if (dialect == null) {
            dialect = new NetezzaSQLDialect();
        }
        return dialect;
    }

    @Override
    String getDriver() {
        return "org.netezza.Driver";
    }

    @Override
    String getJdbcUrl() {
        return "jdbc:netezza://" + this.params.host + ":" + this.params.port + "/" + this.params.db;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port = 5480;
    }
}

