/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SQLBaseConnectionService;
import com.dataiku.dip.connections.SQLConnectionService;
import com.dataiku.dip.connections.SQLPooledConnectionService;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SQLConnectionServiceDispatcher {
    public static final List<MainLoggingConfigurator.ProcessType> ALLOWED_PROCESS_TYPES = ImmutableList.of((Object)MainLoggingConfigurator.ProcessType.BACKEND, (Object)MainLoggingConfigurator.ProcessType.JEK, (Object)MainLoggingConfigurator.ProcessType.FEK);
    private static SQLBaseConnectionService baseConnectionService;
    private static SQLPooledConnectionService pooledConnectionService;
    private static final DKULogger logger;

    public static SQLConnectionService getSQLConnectionService(AbstractSQLConnection.ConnectionPoolSettings connectionPoolSettings, String debugId) {
        if (!ALLOWED_PROCESS_TYPES.contains(DKUApp.getProcessType())) {
            logger.debugV("Not using SQL connection pool, %s not in allowed process types", new Object[]{DKUApp.getProcessType()});
            return SQLConnectionServiceDispatcher.getBaseConnectionServiceInstance();
        }
        if (debugId != null && debugId.startsWith("dssdb-ext-")) {
            logger.debug((Object)"External runtime DB connection, not using main SQL connection pool");
            return SQLConnectionServiceDispatcher.getBaseConnectionServiceInstance();
        }
        if (!FeatureFlags.isEnabled((String)"sqlConnectionPool") || connectionPoolSettings == null || !connectionPoolSettings.enabled) {
            logger.debug((Object)"SQL connection pool disabled (globally or for the connection)");
            return SQLConnectionServiceDispatcher.getBaseConnectionServiceInstance();
        }
        logger.debug((Object)"Using SQL connection pool");
        return SQLConnectionServiceDispatcher.getPooledConnectionServiceInstance();
    }

    private static synchronized SQLBaseConnectionService getBaseConnectionServiceInstance() {
        if (baseConnectionService == null) {
            baseConnectionService = (SQLBaseConnectionService)SpringUtils.getBean(SQLBaseConnectionService.class);
        }
        return baseConnectionService;
    }

    private static synchronized SQLPooledConnectionService getPooledConnectionServiceInstance() {
        if (pooledConnectionService == null) {
            pooledConnectionService = (SQLPooledConnectionService)SpringUtils.getBean(SQLPooledConnectionService.class);
        }
        return pooledConnectionService;
    }

    static {
        logger = DKULogger.getLogger((String)"dku.sql.connection.service.factory");
    }
}

