/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.connections.treasuredata.TreasureDataClientConfig;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.ConfValidators;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.TreasureDataSQLDialect;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class TreasureDataConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public static final String DEFAULT_CATALOG = "td-presto";
    public static final String connectionType = "TreasureData";
    private static TrinoSQLDialect dialect;
    protected Params params = new Params();

    @Override
    public AbstractSQLConnection.AbstractSQLParams getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public void checkConfiguration() throws CodedException, DKUSecurityException {
        if (this.params.useURL) {
            ConfValidators.checkNotBlank(this.params.url, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Presto URL");
        } else {
            ConfValidators.checkNotNull((Object)this.params.region, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Region");
            if (this.params.region == TreasureDataRegion.CUSTOM) {
                ConfValidators.checkNotBlank(this.params.host, ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Host");
            }
        }
    }

    @Override
    public TrinoSQLDialect getDialect() {
        if (dialect == null) {
            dialect = new TreasureDataSQLDialect();
        }
        return dialect;
    }

    @Override
    String getDriver() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.driver;
        }
        return "io.trino.jdbc.TrinoDriver";
    }

    @Override
    String getJdbcUrl() {
        String useSSL = this.getCustomProperty("useSSL").orElse("true");
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Trino connection JDBC URL is not set");
            }
            return this.params.url;
        }
        if (this.params.region == null || this.params.region == TreasureDataRegion.CUSTOM) {
            String jdbcHost = this.getCustomProperty("trinoBaseURL").orElse("api-presto." + this.params.host);
            return "jdbc:trino://" + jdbcHost + ":" + this.params.port + "/" + this.params.db + "?SSL=" + useSSL;
        }
        return "jdbc:trino://api-presto." + this.params.region.host + "/td-presto?SSL=" + useSSL;
    }

    @Override
    String getJarsDirectory() {
        if (StringUtils.isNotBlank((String)this.params.driver)) {
            return this.params.jarsDirectory;
        }
        switch (this.params.driverMode) {
            case MANAGED: {
                return DKUApp.getInstallFile((String[])new String[]{"lib", "ivy", "jdbc-trino"}).getAbsolutePath();
            }
            case CUSTOM: {
                return this.params.jarsDirectory;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        return new InfoMessage.InfoMessages();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableTreasureDataCredentials.class));
        ICredentialsService.Credential decryptedCreds = ConnectionCredentialUtils.getDecryptedCredential_autoTXN(this, ctx.authCtx);
        SerializableTreasureDataCredentials creds = new SerializableTreasureDataCredentials();
        if (decryptedCreds instanceof ICredentialsService.BasicCredential) {
            ICredentialsService.BasicCredential basicCreds = (ICredentialsService.BasicCredential)decryptedCreds;
            creds.apiKey = StringUtils.isNotBlank((String)basicCreds.password) ? basicCreds.password : basicCreds.user;
        } else if (decryptedCreds instanceof ICredentialsService.SingleFieldCredential) {
            creds.apiKey = ((ICredentialsService.SingleFieldCredential)decryptedCreds).value;
        } else {
            throw new IllegalStateException("Unhandled credentials:" + decryptedCreds.getClass().getName());
        }
        return clazz.cast(creds);
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SerializableTreasureDataCredentials creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SerializableTreasureDataCredentials.class);
        SQLConnectionProvider.GenericSQLConnectionData cd = new SQLConnectionProvider.GenericSQLConnectionData(this.getType(), (SQLDialect)this.getDialect(), (AbstractSQLConnection)this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory());
        this.fillConnectionData(cd);
        cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.apiKey, true));
        return cd;
    }

    public TreasureDataClientConfig getClientConfig(AuthCtx authCtx, String projectKey) throws DKUSecurityException, IOException, SQLException {
        SerializableTreasureDataCredentials creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SerializableTreasureDataCredentials.class);
        if (this.params.useURL || this.params.region == null || this.params.region == TreasureDataRegion.CUSTOM) {
            Optional<String> apiBaseURL = this.getCustomProperty("apiBaseURL");
            if (apiBaseURL.isEmpty()) {
                throw new IllegalArgumentException("apiBaseURL property not set. It must be set when using a custom URL");
            }
            return new TreasureDataClientConfig(apiBaseURL.get(), this.getProxySettings(), creds.apiKey);
        }
        String host = "api." + this.params.region.host;
        return new TreasureDataClientConfig(host, null, null, this.getProxySettings(), creds.apiKey);
    }

    private Optional<String> getCustomProperty(String propertyName) {
        if (StringUtils.isBlank((String)propertyName)) {
            return Optional.empty();
        }
        return this.params.properties.stream().filter(p -> propertyName.equals(p.name)).map(p -> p.value).findFirst();
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public int port = 443;
        public TreasureDataRegion region = TreasureDataRegion.US;
        public TreasureDataDriverMode driverMode = TreasureDataDriverMode.MANAGED;
        public String driver;
    }

    public static enum TreasureDataRegion {
        US("treasuredata.com"),
        EUROPE("eu01.treasuredata.com"),
        JAPAN("treasuredata.co.jp"),
        KOREA("ap02.treasuredata.com"),
        CUSTOM(null);

        public final String host;

        private TreasureDataRegion(String host) {
            this.host = host;
        }
    }

    public static enum TreasureDataDriverMode {
        MANAGED,
        CUSTOM;

    }

    private static class SerializableTreasureDataCredentials
    implements ICredentialsService.BasicCredentialConvertible {
        public String apiKey;

        private SerializableTreasureDataCredentials() {
        }

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential(this.apiKey, null);
        }
    }
}

