/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections.treasuredata;

import com.dataiku.dip.ProxySettings;
import com.treasuredata.client.ProxyConfig;
import com.treasuredata.client.TDClient;
import com.treasuredata.client.TDClientBuilder;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class TreasureDataClientConfig {
    private final String host;
    private final Integer port;
    private final Boolean useSSL;
    private final ProxySettings proxySettings;
    private final String apiKey;

    public TreasureDataClientConfig(String endpoint, ProxySettings proxySettings, String apiKey) {
        URI uri = URI.create(endpoint);
        String host = uri.getHost();
        Integer port = uri.getPort() == -1 ? null : Integer.valueOf(uri.getPort());
        boolean useSSL = switch (uri.getScheme()) {
            case "http" -> false;
            case "https" -> true;
            default -> throw new IllegalArgumentException("Invalid endpoint scheme found in apiBaseURL: " + uri.getScheme());
        };
        this.host = host;
        this.port = port;
        this.useSSL = useSSL;
        this.proxySettings = proxySettings;
        this.apiKey = apiKey;
    }

    public TreasureDataClientConfig(String host, Integer port, Boolean useSSL, ProxySettings proxySettings, String apiKey) {
        this.host = host;
        this.port = port;
        this.useSSL = useSSL;
        this.proxySettings = proxySettings;
        this.apiKey = apiKey;
    }

    public TDClient buildClient() {
        TDClientBuilder builder = new TDClientBuilder(false);
        builder.setApiKey(this.apiKey);
        builder.setEndpoint(this.host);
        if (this.port != null) {
            builder.setPort(this.port.intValue());
        }
        if (this.useSSL != null) {
            builder.setUseSSL(this.useSSL.booleanValue());
        }
        if (this.proxySettings != null && this.proxySettings.hasProxy()) {
            Optional user = StringUtils.isNotEmpty((String)this.proxySettings.username) ? Optional.of(this.proxySettings.username) : Optional.empty();
            Optional password = StringUtils.isNotEmpty((String)this.proxySettings.password) ? Optional.of(this.proxySettings.password) : Optional.empty();
            ProxyConfig proxyConfig = new ProxyConfig(this.proxySettings.host, this.proxySettings.port, this.proxySettings.port == 443, user, password);
            builder.setProxy(proxyConfig);
        }
        return builder.build();
    }
}

