/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.ClustersService;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.kubernetes.CpuQuantity;
import com.dataiku.dip.containers.exec.kubernetes.MemoryQuantity;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.JsonUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.FastSafePatternMatcher;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KubernetesClusterService {
    private static final String NODE = "node";
    private static final String POD = "pod";
    private static final String JOB = "job";
    private static final String SERVICE = "service";
    private static final String DEPLOYMENT = "deployment";
    private static final String[] CHECK_METRICS_SERVER_INSTALLED_COMMAND_ARG = new String[]{"get", "service", "metrics-server", "-n", "kube-system"};
    private static final String[] GET_NODES_METRICS = new String[]{"top", "nodes", "--no-headers"};
    private static final String[] GET_NODE_NAMES = new String[]{"get", "nodes", "-o=name"};
    private static final String[] GET_PODS_METRICS = new String[]{"top", "pods", "--no-headers"};
    private static final List<String> DELETE_SUCCEEDED_AND_FAILED_PODS = ImmutableList.of((Object)"delete", (Object)"pods", (Object)"--field-selector=status.phase!=Pending,status.phase!=Running,status.phase!=Unknown");
    private static final List<String> DELETE_ALL_PODS = ImmutableList.of((Object)"delete", (Object)"--all", (Object)"pods");
    private static final List<String> DELETE_PODS_WITH_LABEL_SELECTOR = ImmutableList.of((Object)"delete", (Object)"pods");
    private static final long UNSCHEDULABLE_POD_SECONDS = 30L;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.k8s.actions");
    private static final String METADATA = "metadata";
    private static final String STATUS = "status";
    private static final List<String> DESCRIBABLE_OBJECTS = ImmutableList.of((Object)"node", (Object)"pod", (Object)"job", (Object)"service", (Object)"deployment");
    private static final List<String> DELETABLE_OBJECTS = ImmutableList.of((Object)"pod", (Object)"job", (Object)"service", (Object)"deployment");
    private static final FastSafePatternMatcher K8S_NAME_MATCHER = new FastSafePatternMatcher("^[a-z0-9\\-.]+$");
    private static final long COMMAND_EXEC_WAIT_TIMEOUT = 200L;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ClustersService clustersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FutureService futureService;
    private static final Function<DKUtils.ExecutionResults, List<ClusterResourceWithMetrics>> parseNodesMetrics = results -> {
        ArrayList<ClusterResourceWithMetrics> metricsByNodes = new ArrayList<ClusterResourceWithMetrics>();
        if (results.rv == 0) {
            String out = results.out;
            String[] lines = out.split(System.lineSeparator());
            Pattern pattern = Pattern.compile("^([-a-z0-9\\.]{1,253})\\s+\\w+\\s+(\\d+)%\\s+\\w+\\s+(\\d+)%\\s*$");
            for (String line : lines) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.matches()) continue;
                ClusterResourceWithMetrics node = new ClusterResourceWithMetrics(matcher.group(1));
                node.setCpuUsage(Integer.parseInt(matcher.group(2)));
                node.setMemoryUsage(Integer.parseInt(matcher.group(3)));
                metricsByNodes.add(node);
            }
        } else {
            throw ErrorContext.ice((String)results.err);
        }
        return metricsByNodes;
    };

    public void checkClusterUpdatePrivilegeAndArchitecture_NT(AuthCtx authCtx, String clusterId) throws Exception {
        Cluster cluster;
        try (Transaction ignored = this.transactionService.beginRead();){
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.UPDATE);
            cluster = this.clustersService.getMandatoryUnsafe(clusterId);
        }
        if (cluster.architecture != Cluster.ClusterArchitecture.KUBERNETES) {
            throw ErrorContext.iae((String)(clusterId + " is not a Kubernetes cluster"));
        }
    }

    public static List<ClusterPodTopMetrics> parsePodsMetrics(String results, boolean withNamespace) {
        Function<String, ClusterPodTopMetrics> lineParser = withNamespace ? KubernetesClusterService::parseSinglePodMetricsLineWithNamespace : KubernetesClusterService::parseSinglePodMetricsLineWithoutNamespace;
        ArrayList<ClusterPodTopMetrics> podMetrics = new ArrayList<ClusterPodTopMetrics>();
        for (String line : results.split(System.lineSeparator())) {
            Optional.ofNullable(lineParser.apply(line)).ifPresent(podMetrics::add);
        }
        return podMetrics;
    }

    static List<ClusterPodTopMetrics> parsePodsMetrics(DKUtils.ExecutionResults results, boolean withNamespace) {
        if (results.rv != 0) {
            throw ErrorContext.ice((String)results.err);
        }
        return KubernetesClusterService.parsePodsMetrics(results.out, withNamespace);
    }

    @VisibleForTesting
    static ClusterPodTopMetrics parseSinglePodMetricsLineWithoutNamespace(String line) {
        Pattern pattern = Pattern.compile("^([-a-z0-9.]{1,63})\\s+(\\w+)\\s+(\\w+)\\s*$");
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        try {
            return new ClusterPodTopMetrics(matcher.group(1), null, new CpuQuantity(matcher.group(2)).getAsMilli(), new MemoryQuantity(matcher.group(3)).getAsMb());
        }
        catch (Exception e) {
            return null;
        }
    }

    @VisibleForTesting
    static ClusterPodTopMetrics parseSinglePodMetricsLineWithNamespace(String line) {
        Pattern pattern = Pattern.compile("^([-a-z0-9.]{1,253})\\s+([-a-z0-9.]{1,63})\\s+(\\w+)\\s+(\\w+)\\s*$");
        Matcher matcher = pattern.matcher(line);
        if (!matcher.matches()) {
            logger.traceV("Failed to parse line: " + line, new Object[0]);
            return null;
        }
        try {
            return new ClusterPodTopMetrics(matcher.group(2), matcher.group(1), new CpuQuantity(matcher.group(3)).getAsMilli(), new MemoryQuantity(matcher.group(4)).getAsMb());
        }
        catch (Exception e) {
            return null;
        }
    }

    public FutureResponse<DKUtils.ExecutionResults> futureRunKubectlCommand(AuthCtx authCtx, String clusterId, String ... args) throws Exception {
        if (Arrays.stream(args).anyMatch(arg -> StringUtils.trimToEmpty((String)arg).startsWith("--kubeconfig"))) {
            throw ErrorContext.iae((String)"Using the '--kubeconfig' option is not permitted");
        }
        return this.futureRunKubectlCommandAndParseResults(authCtx, clusterId, executionResults -> executionResults, args);
    }

    public FutureResponse<NodesAndPodCount> countNodesAndPods(final AuthCtx authCtx, final String clusterId) throws Exception {
        SimpleFutureThread<NodesAndPodCount> simpleFutureThread = new SimpleFutureThread<NodesAndPodCount>(authCtx){

            @Override
            protected NodesAndPodCount compute() throws IOException, InterruptedException, DKUSecurityException {
                NodesAndPodCount counts = new NodesAndPodCount();
                counts.nodes = KubernetesClusterService.this.getNumberOfNodes(authCtx, clusterId);
                KubernetesClusterService.this.countPodsAndUnschedulablePods(authCtx, clusterId, counts);
                return counts;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"k8s_count_nodes_and_pods", (String)("Counting cluster " + clusterId + " nodes and pods"));
            }
        };
        return this.futureService.runFuture(simpleFutureThread, 200L, new TypeToken<FutureResponse<NodesAndPodCount>>(){});
    }

    public FutureResponse<DKUtils.ExecutionResults> deleteFinishedJobs(final AuthCtx authCtx, final String clusterId, final boolean dryRun, final boolean deleteFailed, final @Nullable String namespace, final @Nullable String labelFilter) throws Exception {
        SimpleFutureThread<DKUtils.ExecutionResults> simpleFutureThread = new SimpleFutureThread<DKUtils.ExecutionResults>(authCtx){
            private final String[] deleteCommand;
            private final String[] getJobsCommand;
            private static final String COMPLETE_JOBS_FILTER = "(eq .type \"Complete\")";
            private static final String COMPLETE_AND_FAILED_JOBS_FILTER = "or (eq .type \"Failed\") (eq .type \"Complete\")";
            private static final String JOB_ITEM_SEPARATOR = " ";
            {
                super(owner);
                this.deleteCommand = new String[]{"delete", "jobs"};
                this.getJobsCommand = new String[]{"get", "jobs", "-o"};
            }

            @Override
            protected DKUtils.ExecutionResults compute() throws IOException, InterruptedException, DKUSecurityException {
                DKUtils.ExecutionResults jobListResult = KubernetesClusterService.this.runKubectlCommand(authCtx, clusterId, this.buildGetJobsCommand());
                if (jobListResult.rv == 0) {
                    String jobNames = jobListResult.out;
                    if (StringUtils.isBlank((String)jobNames)) {
                        DKUtils.ExecutionResults results = new DKUtils.ExecutionResults();
                        results.rv = 0;
                        results.err = "";
                        results.out = "No resources found.";
                        return results;
                    }
                    return KubernetesClusterService.this.runKubectlCommand(authCtx, clusterId, this.buildDeleteJobsCommand(jobNames));
                }
                return jobListResult;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"k8s-cluster-delete-finished-jobs", (String)("Deleting jobs in cluster " + clusterId));
            }

            private String[] buildGetJobsCommand() {
                ArrayList args = Lists.newArrayList((Object[])this.getJobsCommand);
                String jobFilter = "go-template={{range $i, $p := .items}}{{range .status.conditions}}{{if JOBS_FILTER_ARG}}{{$p.metadata.name}}{{\" \"}}{{end}}{{end}}{{end}}";
                String filter = jobFilter.replace("JOBS_FILTER_ARG", deleteFailed ? COMPLETE_AND_FAILED_JOBS_FILTER : COMPLETE_JOBS_FILTER);
                args.add(filter);
                KubernetesClusterService.this.addNamespaceFilter(args, namespace);
                KubernetesClusterService.this.addLabelFilter(args, labelFilter);
                return args.toArray(new String[0]);
            }

            private String[] buildDeleteJobsCommand(String jobNames) {
                ArrayList args = Lists.newArrayList((Object[])this.deleteCommand);
                List jobs = Arrays.stream(jobNames.split(JOB_ITEM_SEPARATOR)).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                args.addAll(jobs);
                KubernetesClusterService.this.addNamespaceFilter(args, namespace);
                KubernetesClusterService.this.addDryRun(args, dryRun);
                return args.toArray(new String[0]);
            }
        };
        return this.futureService.runFuture(simpleFutureThread, 200L, new TypeToken<FutureResponse<DKUtils.ExecutionResults>>(){});
    }

    public FutureResponse<DKUtils.ExecutionResults> deleteFinishedPods(AuthCtx authCtx, String clusterId, boolean dryRun, @Nullable String namespace, @Nullable String labelFilter) throws Exception {
        return this.futureRunKubectlCommand(authCtx, clusterId, this.buildPredefinedActionCommand(DELETE_SUCCEEDED_AND_FAILED_PODS, dryRun, namespace, labelFilter));
    }

    public FutureResponse<DKUtils.ExecutionResults> deleteAllPods(AuthCtx authCtx, String clusterId, boolean dryRun, @Nullable String namespace, @Nullable String labelFilter) throws Exception {
        return this.futureRunKubectlCommand(authCtx, clusterId, this.buildPredefinedActionCommand(StringUtils.isNotBlank((String)labelFilter) ? DELETE_PODS_WITH_LABEL_SELECTOR : DELETE_ALL_PODS, dryRun, namespace, labelFilter));
    }

    public FutureResponse<Boolean> checkMetricsServerInstalled(AuthCtx authCtx, String clusterId) throws Exception {
        return this.futureRunKubectlCommandAndParseResults(authCtx, clusterId, results -> {
            if (results.rv == 0) {
                return true;
            }
            if (results.err.contains("NotFound")) {
                return false;
            }
            throw ErrorContext.ice((String)results.err);
        }, CHECK_METRICS_SERVER_INSTALLED_COMMAND_ARG);
    }

    public FutureResponse<List<ClusterPodTopMetrics>> getPodMetrics(AuthCtx authCtx, @Nonnull String clusterId, @Nonnull String namespace) throws Exception {
        ArrayList<String> commandArgs = new ArrayList<String>(Arrays.asList(GET_PODS_METRICS));
        this.addNamespaceFilter(commandArgs, namespace);
        return this.futureRunKubectlCommandAndParseResults(authCtx, clusterId, results -> KubernetesClusterService.parsePodsMetrics(results, false), commandArgs.toArray(new String[0]));
    }

    public FutureResponse<List<ClusterResourceWithMetrics>> getNodesMetrics(AuthCtx authCtx, String clusterId) throws Exception {
        return this.futureRunKubectlCommandAndParseResults(authCtx, clusterId, parseNodesMetrics, GET_NODES_METRICS);
    }

    public void getPodLog(AuthCtx authCtx, String clusterId, String podName, String namespace, OutputStream outputStream) throws IOException, InterruptedException, DKUSecurityException {
        ContainerExecUtils.KubernetesAwareContainerConfig k8sConfig = this.getKubernetesAwareContainerConfig(authCtx, clusterId);
        try (AutoDelete podLogFile = DSSTempUtils.getTempFile((String)"k8s-cluster", (String)podName, (String)"log");){
            logger.info((Object)String.format("Writing pod %s log to temp file: %s", podName, podLogFile.getAbsolutePath()));
            KubectlHelper.logKubectl(k8sConfig, false, (File)podLogFile, "logs", podName, "-n", namespace, "--all-containers=true");
            try (GZIPOutputStream zos = new GZIPOutputStream(outputStream);
                 FileInputStream is = new FileInputStream((File)podLogFile);){
                IOUtils.copy((InputStream)is, (OutputStream)zos);
            }
        }
    }

    public SmartLogTail tailPodLog(AuthCtx authCtx, String clusterId, String podName, String namespace) throws IOException, InterruptedException, DKUSecurityException {
        ContainerExecUtils.KubernetesAwareContainerConfig k8sConfig = this.getKubernetesAwareContainerConfig(authCtx, clusterId);
        try (AutoDelete podLogFile = DSSTempUtils.getTempFile((String)"k8s-cluster", (String)podName, (String)"log");){
            KubectlHelper.logKubectl(k8sConfig, false, (File)podLogFile, "logs", podName, "-n", namespace, "--all-containers=true", "--tail=200");
            SmartLogTail ret = new SmartLogTail();
            for (SmartLogTail line : DKUFileUtils.readFileToStringUTF8((File)podLogFile).split("\n")) {
                ret.appendLine((String)line);
            }
            SmartLogTail smartLogTail = ret;
            return smartLogTail;
        }
    }

    public FutureResponse<List<String>> listNamespaces(final AuthCtx authCtx, final String clusterId) throws Exception {
        SimpleFutureThread<List<String>> simpleFutureThread = new SimpleFutureThread<List<String>>(authCtx){

            @Override
            protected List<String> compute() throws IOException, InterruptedException, DKUSecurityException {
                ArrayList<String> namespaces = new ArrayList<String>();
                for (JsonElement nodeElement : KubernetesClusterService.this.getItemsArrayFromKubectl(authCtx, clusterId, "namespaces", NamespaceFilterType.NONE, "")) {
                    String name = JsonUtils.getOrNullStr(nodeElement.getAsJsonObject(), KubernetesClusterService.METADATA, "name");
                    if (name == null) continue;
                    namespaces.add(name);
                }
                return namespaces;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"k8s_list_namespaces", (String)("Listing cluster " + clusterId + " namespaces"));
            }
        };
        return this.futureService.runFuture(simpleFutureThread, 200L, new TypeToken<FutureResponse<List<String>>>(){});
    }

    public FutureResponse<List<ClusterNode>> listNodes(AuthCtx authCtx, String clusterId, boolean detailedNodeData) throws Exception {
        return this.listResource(ClusterNode::new, authCtx, clusterId, NamespaceFilterType.NONE, "nodes", "", detailedNodeData);
    }

    public FutureResponse<List<ClusterPod>> listPods(AuthCtx authCtx, String clusterId, NamespaceFilterType namespaceFilterType, String namespace, boolean detailedPodData) throws Exception {
        return this.listResource(ClusterPod::new, authCtx, clusterId, namespaceFilterType, "pods", namespace, detailedPodData);
    }

    public FutureResponse<List<ClusterResource>> listJobs(AuthCtx authCtx, String clusterId, NamespaceFilterType namespaceFilterType, String namespace) throws Exception {
        return this.listResource(ClusterResource::new, authCtx, clusterId, namespaceFilterType, "jobs", namespace, false);
    }

    public FutureResponse<List<ClusterResource>> listDeployments(AuthCtx authCtx, String clusterId, NamespaceFilterType namespaceFilterType, String namespace) throws Exception {
        return this.listResource(ClusterResource::new, authCtx, clusterId, namespaceFilterType, "deployments", namespace, false);
    }

    public FutureResponse<List<ClusterService>> listServices(AuthCtx authCtx, String clusterId, NamespaceFilterType namespaceFilterType, String namespace) throws Exception {
        return this.listResource(ClusterService::new, authCtx, clusterId, namespaceFilterType, "services", namespace, false);
    }

    public FutureResponse<DKUtils.ExecutionResults> describeObject(AuthCtx authCtx, String clusterId, String objectType, String objectName, @Nullable String namespace) throws Exception {
        if (!DESCRIBABLE_OBJECTS.contains(objectType)) {
            throw ErrorContext.iae((String)("Unable to describe object type: " + objectType));
        }
        return this.runCommandOnSingleObject(authCtx, clusterId, "describe", objectType, objectName, namespace);
    }

    public FutureResponse<DKUtils.ExecutionResults> deleteObject(AuthCtx authCtx, String clusterId, String objectType, String objectName, String namespace) throws Exception {
        if (!DELETABLE_OBJECTS.contains(objectType)) {
            throw ErrorContext.iae((String)("Unable to delete object type: " + objectType));
        }
        return this.runCommandOnSingleObject(authCtx, clusterId, "delete", objectType, objectName, namespace);
    }

    public KubectlVersionsResponse getVersions(Cluster cluster) throws Exception {
        DKUtils.ExecutionResults execResult = this.runKubectlCommand(cluster, "version", "--output=json");
        if (execResult.rv == 0) {
            return (KubectlVersionsResponse)JSON.parse((String)execResult.out, KubectlVersionsResponse.class);
        }
        throw ErrorContext.ice((String)execResult.err);
    }

    private FutureResponse<DKUtils.ExecutionResults> runCommandOnSingleObject(AuthCtx authCtx, String clusterId, String command, String objectType, String objectName, @Nullable String namespace) throws Exception {
        this.checkK8sObjectName(objectName);
        ArrayList<String> args = new ArrayList<String>();
        args.add(command);
        args.add(objectType);
        args.add(objectName);
        this.addNamespaceFilter(args, namespace);
        return this.futureRunKubectlCommand(authCtx, clusterId, args.toArray(new String[0]));
    }

    private void checkK8sObjectName(String objectName) {
        if (!K8S_NAME_MATCHER.matches(objectName)) {
            throw ErrorContext.iae((String)(objectName + " does not look like a kubernetes object name"));
        }
    }

    private String[] buildPredefinedActionCommand(List<String> baseCommand, boolean dryRun, @Nullable String namespace, @Nullable String labelFilter) {
        ArrayList<String> commandArgs = new ArrayList<String>(baseCommand);
        this.addNamespaceFilter(commandArgs, namespace);
        this.addLabelFilter(commandArgs, labelFilter);
        this.addDryRun(commandArgs, dryRun);
        return commandArgs.toArray(new String[0]);
    }

    private void addDryRun(List<String> commandArgs, boolean dryRun) {
        if (dryRun) {
            commandArgs.add("--dry-run=client");
        }
    }

    private void addNamespaceFilter(List<String> commandArgs, @Nullable String namespace) {
        if (StringUtils.isNotBlank((String)namespace)) {
            this.checkK8sObjectName(namespace);
            commandArgs.add("-n");
            commandArgs.add(namespace);
        }
    }

    private void addLabelFilter(List<String> commandArgs, @Nullable String labelFilter) {
        if (StringUtils.isNotBlank((String)labelFilter)) {
            commandArgs.add("-l");
            commandArgs.add(labelFilter);
        }
    }

    private <K extends ClusterResource> FutureResponse<List<K>> listResource(final Function<JsonElement, K> createClusterResource, final AuthCtx authCtx, final String clusterId, final NamespaceFilterType namespaceFilterType, final String type, final String namespace, final boolean detailedData) throws Exception {
        SimpleFutureThread simpleFutureThread = new SimpleFutureThread<List<K>>(authCtx){

            private String makePodKey(String namespace2, String name) {
                return namespace2 + "$$$" + name;
            }

            @Override
            protected List<K> compute() throws IOException, InterruptedException, DKUSecurityException {
                ArrayList<ClusterPod> resources = new ArrayList<ClusterPod>();
                for (JsonElement serviceElement : KubernetesClusterService.this.getItemsArrayFromKubectl(authCtx, clusterId, type, namespaceFilterType, namespace)) {
                    resources.add((ClusterPod)((ClusterResource)createClusterResource.apply(serviceElement)));
                }
                if (!detailedData) {
                    return resources;
                }
                try {
                    if (type.equals("pods")) {
                        this.enrichWithPodsData(resources);
                    } else if (type.equals("nodes")) {
                        this.enrichWithNodesData(resources);
                    } else {
                        logger.warn((Object)("Unsupported resource type for K8S top: " + type));
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to enrich pods or nodes with top", (Throwable)e);
                }
                return resources;
            }

            private void enrichWithPodsData(List<ClusterPod> resources) throws IOException, DKUSecurityException, InterruptedException {
                DKUtils.ExecutionResults execResult = KubernetesClusterService.this.runKubectlCommand(authCtx, clusterId, "top", "pods", "--all-namespaces", "--no-headers");
                List<ClusterPodTopMetrics> podMetricsList = KubernetesClusterService.parsePodsMetrics(execResult, true);
                HashMap podsMap = new HashMap();
                resources.forEach(clusterPod -> podsMap.put(this.makePodKey(clusterPod.namespace, clusterPod.name), clusterPod));
                podMetricsList.forEach(podMetrics -> {
                    ClusterPod clusterPod = (ClusterPod)podsMap.get(this.makePodKey(podMetrics.getNamespace(), podMetrics.getName()));
                    if (clusterPod == null) {
                        logger.trace((Object)("Pod not found in list - probably belongs to excluded namespace:  " + this.makePodKey(podMetrics.getNamespace(), podMetrics.getName())));
                    } else {
                        clusterPod.cpuCurrentMillis = podMetrics.getCpuMillis();
                        clusterPod.memoryCurrentMB = podMetrics.getMemoryMB();
                        logger.trace((Object)("Enriched pod info pod " + JSON.json((Object)clusterPod)));
                    }
                });
            }

            private void enrichWithNodesData(List<ClusterNode> resources) throws IOException, DKUSecurityException, InterruptedException {
                DKUtils.ExecutionResults execResult = KubernetesClusterService.this.runKubectlCommand(authCtx, clusterId, "top", "nodes", "--no-headers");
                if (execResult.rv != 0) {
                    logger.warn((Object)("Failed to get nodes metrics: " + execResult.err));
                    return;
                }
                HashMap nodesMap = new HashMap();
                resources.forEach(clusterNode -> nodesMap.put(clusterNode.name, clusterNode));
                Pattern pattern = Pattern.compile("([^\\s]*)\\s+([^\\s]*)\\s+([^\\s]*)\\s+([^\\s]*)\\s+([^\\s]*)");
                for (String line : StringUtils.split((String)execResult.out, (String)"\n")) {
                    Matcher m = pattern.matcher(line);
                    if (!m.find()) {
                        logger.trace((Object)("K8S Top line does not match regex: " + line));
                        continue;
                    }
                    ClusterNode clusterNode2 = (ClusterNode)nodesMap.get(m.group(1));
                    if (clusterNode2 == null) {
                        logger.trace((Object)"Node not found in list");
                        continue;
                    }
                    clusterNode2.cpuCurrentMillis = new CpuQuantity(m.group(2)).getAsMilli();
                    clusterNode2.memoryCurrentMB = new MemoryQuantity(m.group(4)).getAsMb();
                    logger.trace((Object)("Enriched node info node " + JSON.json((Object)clusterNode2)));
                }
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"k8s_list_services", (String)("Listing cluster " + clusterId + " " + type));
            }
        };
        return this.futureService.runFuture(simpleFutureThread, 200L, new TypeToken<FutureResponse<List<K>>>(){});
    }

    private <K> FutureResponse<K> futureRunKubectlCommandAndParseResults(final AuthCtx authCtx, final String clusterId, final Function<DKUtils.ExecutionResults, K> parseResults, final String ... args) throws Exception {
        SimpleFutureThread simpleFutureThread = new SimpleFutureThread<K>(authCtx){

            @Override
            protected K compute() throws IOException, InterruptedException, DKUSecurityException {
                return parseResults.apply(KubernetesClusterService.this.runKubectlCommand(authCtx, clusterId, args));
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"run_kubectl_command", (String)("Running kubectl command on cluster " + clusterId));
            }
        };
        return this.futureService.runFuture(simpleFutureThread, 200L, new TypeToken<FutureResponse<K>>(){});
    }

    private DKUtils.ExecutionResults runKubectlCommand(Cluster cluster, String ... args) throws IOException, InterruptedException, DKUSecurityException {
        ContainerExecUtils.KubernetesAwareContainerConfig k8sConfig = this.getKubernetesAwareContainerConfig(cluster);
        return KubectlHelper.executeKubectlToExecResults(k8sConfig, false, args);
    }

    private DKUtils.ExecutionResults runKubectlCommand(AuthCtx authCtx, String clusterId, String ... args) throws IOException, InterruptedException, DKUSecurityException {
        ContainerExecUtils.KubernetesAwareContainerConfig k8sConfig = this.getKubernetesAwareContainerConfig(authCtx, clusterId);
        return KubectlHelper.executeKubectlToExecResults(k8sConfig, false, args);
    }

    private ContainerExecUtils.KubernetesAwareContainerConfig getKubernetesAwareContainerConfig(Cluster cluster) {
        ContainerExecRuntimeConfig inlineConfig = new ContainerExecRuntimeConfig();
        inlineConfig.type = ContainerExecRuntimeConfig.Container.KUBERNETES;
        inlineConfig.noImplicitK8sClusterAndNoDefaultClusterId = false;
        ContainerExecRuntimeConfig configOverrides = cluster.containerSettings.executionConfigsGenericOverrides;
        return ContainerOverrideMask.getOverriden(inlineConfig, configOverrides);
    }

    private ContainerExecUtils.KubernetesAwareContainerConfig getKubernetesAwareContainerConfig(AuthCtx authCtx, String clusterId) throws IOException, DKUSecurityException {
        ClusterSettings clusterSettings = new ClusterSelector().selectForCluster(authCtx, "__builtin__", clusterId);
        ContainerExecRuntimeConfig inlineConfig = new ContainerExecRuntimeConfig();
        inlineConfig.type = ContainerExecRuntimeConfig.Container.KUBERNETES;
        inlineConfig.noImplicitK8sClusterAndNoDefaultClusterId = false;
        ContainerExecRuntimeConfig configOverrides = clusterSettings.getContainerSettings().executionConfigsGenericOverrides;
        return ContainerOverrideMask.getOverriden(inlineConfig, configOverrides);
    }

    private int getNumberOfNodes(AuthCtx authCtx, String clusterId) throws IOException, DKUSecurityException, InterruptedException {
        DKUtils.ExecutionResults execResult = this.runKubectlCommand(authCtx, clusterId, GET_NODE_NAMES);
        if (execResult.rv == 0) {
            return execResult.out.split(System.lineSeparator()).length;
        }
        throw ErrorContext.ice((String)execResult.err);
    }

    private void countPodsAndUnschedulablePods(AuthCtx authCtx, String clusterId, NodesAndPodCount counts) throws IOException, DKUSecurityException, InterruptedException {
        counts.pods = 0;
        counts.unschedulablePods = 0;
        for (JsonElement jsonElement : this.getItemsArrayFromKubectl(authCtx, clusterId, "pods", NamespaceFilterType.ALL_BUT_SYSTEM, "")) {
            ++counts.pods;
            if (!this.isPodUnschedulable(jsonElement.getAsJsonObject())) continue;
            ++counts.unschedulablePods;
        }
    }

    private boolean isPodUnschedulable(JsonObject podObject) {
        JsonObject statusObject = JsonUtils.getOrEmptyObj(podObject, STATUS);
        if ("Pending".equals(JsonUtils.getOrNullStr(statusObject, "phase"))) {
            for (JsonElement conditionElement : JsonUtils.getOrEmptyArr(statusObject, "conditions")) {
                JsonObject condition = conditionElement.getAsJsonObject();
                String type = JsonUtils.getOrNullStr(condition, "type");
                if (!"PodScheduled".equals(type)) continue;
                String status = JsonUtils.getOrNullStr(condition, STATUS);
                if ("False".equals(status)) {
                    return true;
                }
                String lastTransitionTime = JsonUtils.getOrNullStr(condition, "lastTransitionTime");
                if (lastTransitionTime == null) continue;
                try {
                    ZonedDateTime startTimeParsed = ZonedDateTime.parse(lastTransitionTime);
                    if (ChronoUnit.SECONDS.between(startTimeParsed, ZonedDateTime.now()) <= 30L) continue;
                    return true;
                }
                catch (DateTimeParseException ex) {
                    logger.warnV((Throwable)ex, "Unable to parse lastTransitionTime %s, ignoring unschedulable pod check", new Object[]{lastTransitionTime});
                }
            }
        }
        return false;
    }

    private JsonArray getItemsArrayFromKubectl(AuthCtx authCtx, String clusterId, String itemsToGet, NamespaceFilterType namespaceFilterType, String namespace) throws IOException, InterruptedException, DKUSecurityException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("get");
        args.add(itemsToGet);
        args.add("-o");
        args.add("json");
        args.addAll(namespaceFilterType.getNamespaceArgs(namespace));
        DKUtils.ExecutionResults execResult = this.runKubectlCommand(authCtx, clusterId, args.toArray(new String[0]));
        if (execResult.rv == 0) {
            JsonObject resultJson = (JsonObject)JSON.parse((String)execResult.out, JsonObject.class);
            return resultJson.has("items") ? resultJson.getAsJsonArray("items") : new JsonArray();
        }
        throw ErrorContext.ice((String)execResult.err);
    }

    public static ClusterCapacities extractCpuAndMemoryCapacity(List<ClusterNode> nodes) {
        int clusterCpuCapacityMillis = 0;
        long clusterMemoryCapacityMB = 0L;
        for (ClusterNode node : nodes) {
            if (node.getCpuCapacityMillis() == null) {
                logger.errorV("Failed to get CPU capacity for node %s", new Object[]{node.getName()});
                return null;
            }
            if (node.getMemoryCapacityMB() == null) {
                logger.errorV("Failed to get memory capacity for node %s", new Object[]{node.getName()});
                return null;
            }
            clusterCpuCapacityMillis += node.getCpuCapacityMillis().intValue();
            clusterMemoryCapacityMB += node.getMemoryCapacityMB().longValue();
        }
        return new ClusterCapacities(clusterCpuCapacityMillis, clusterMemoryCapacityMB);
    }

    public static class ClusterPodTopMetrics
    extends ImmutableValueObject {
        @Nonnull
        private final String name;
        @Nullable
        private final String namespace;
        @Nonnull
        private final Integer cpuMillis;
        @Nonnull
        private final Long memoryMB;

        public ClusterPodTopMetrics(@Nonnull String name, @Nullable String namespace, @Nonnull Integer cpuMillis, @Nonnull Long memoryMB) {
            this.name = name;
            this.namespace = namespace;
            this.cpuMillis = cpuMillis;
            this.memoryMB = memoryMB;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getNamespace() {
            return this.namespace;
        }

        @Nonnull
        public Integer getCpuMillis() {
            return this.cpuMillis;
        }

        @Nonnull
        public Long getMemoryMB() {
            return this.memoryMB;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ClusterPodTopMetrics that = (ClusterPodTopMetrics)((Object)o);
            return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getNamespace(), that.getNamespace()) && Objects.equals(this.getCpuMillis(), that.getCpuMillis()) && Objects.equals(this.getMemoryMB(), that.getMemoryMB());
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Objects.hashCode(this.getName());
            result = 31 * result + Objects.hashCode(this.getNamespace());
            result = 31 * result + Objects.hashCode(this.getCpuMillis());
            result = 31 * result + Objects.hashCode(this.getMemoryMB());
            return result;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NamespaceFilterType {
        ALL{

            @Override
            public List<String> getNamespaceArgs(String namespace) {
                return ImmutableList.of((Object)"--all-namespaces");
            }
        }
        ,
        ALL_BUT_SYSTEM{

            @Override
            public List<String> getNamespaceArgs(String namespace) {
                return ImmutableList.of((Object)"--all-namespaces", (Object)"--field-selector=metadata.namespace!=kube-system");
            }
        }
        ,
        EXPLICIT{

            @Override
            public List<String> getNamespaceArgs(String namespace) {
                return ImmutableList.of((Object)("--namespace=" + namespace));
            }
        }
        ,
        NONE{

            @Override
            public List<String> getNamespaceArgs(String namespace) {
                return ImmutableList.of();
            }
        };


        public abstract List<String> getNamespaceArgs(String var1);
    }

    public static class KubectlVersionsResponse {
        public KubectlVersionResponse clientVersion;
        public KubectlVersionResponse serverVersion;
    }

    private static class NodesAndPodCount {
        public int nodes;
        public int pods;
        public int unschedulablePods;

        private NodesAndPodCount() {
        }
    }

    public static class ClusterNode
    extends ClusterResourceWithStatus {
        private Integer cpuCapacityMillis;
        private Integer cpuCurrentMillis;
        private Long memoryCapacityMB;
        private Long memoryCurrentMB;

        public ClusterNode(JsonElement nodeElement) {
            super(nodeElement);
            this.fillNodeData();
        }

        @VisibleForTesting
        public ClusterNode(String name) {
            super(name);
        }

        public Integer getCpuCapacityMillis() {
            return this.cpuCapacityMillis;
        }

        public Long getMemoryCapacityMB() {
            return this.memoryCapacityMB;
        }

        public ClusterNode withCpuCapacityMillis(Integer cpuCapacityMillis) {
            this.cpuCapacityMillis = cpuCapacityMillis;
            return this;
        }

        public ClusterNode withMemoryCapacityMB(Long memoryCapacityMB) {
            this.memoryCapacityMB = memoryCapacityMB;
            return this;
        }

        private void fillNodeData() {
            String memoryCapacity;
            logger.trace((Object)("FillNodeData, itemJson=" + JSON.json((Object)this.itemJson)));
            String cpuCapacity = JsonUtils.getOrNullStr(this.itemJson, KubernetesClusterService.STATUS, "capacity", "cpu");
            if (cpuCapacity != null) {
                this.cpuCapacityMillis = new CpuQuantity(cpuCapacity).getAsMilli();
            }
            if ((memoryCapacity = JsonUtils.getOrNullStr(this.itemJson, KubernetesClusterService.STATUS, "capacity", "memory")) != null) {
                this.memoryCapacityMB = new MemoryQuantity(memoryCapacity).getAsMb();
            }
        }
    }

    public static class ClusterCapacities {
        @Nonnull
        Integer cpuCapacityMillis;
        @Nonnull
        Long memoryCapacityMB;

        public ClusterCapacities(@Nonnull Integer cpuCapacityMillis, @Nonnull Long memoryCapacityMB) {
            this.cpuCapacityMillis = cpuCapacityMillis;
            this.memoryCapacityMB = memoryCapacityMB;
        }

        @Nonnull
        public Integer getCpuCapacityMillis() {
            return this.cpuCapacityMillis;
        }

        @Nonnull
        public Long getMemoryCapacityMB() {
            return this.memoryCapacityMB;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterCapacities that = (ClusterCapacities)o;
            return this.getCpuCapacityMillis().equals(that.getCpuCapacityMillis()) && this.getMemoryCapacityMB().equals(that.getMemoryCapacityMB());
        }

        public int hashCode() {
            int result = this.getCpuCapacityMillis().hashCode();
            result = 31 * result + this.getMemoryCapacityMB().hashCode();
            return result;
        }
    }

    public static class ClusterResourceWithMetrics
    extends ClusterResource {
        private int cpuUsage;
        private int memoryUsage;

        public ClusterResourceWithMetrics(String name) {
            super(name);
        }

        public ClusterResourceWithMetrics(String name, int cpuUsage, int memoryUsage) {
            super(name);
            this.cpuUsage = cpuUsage;
            this.memoryUsage = memoryUsage;
        }

        public int getCpuUsage() {
            return this.cpuUsage;
        }

        public void setCpuUsage(int cpuUsage) {
            this.cpuUsage = cpuUsage;
        }

        public int getMemoryUsage() {
            return this.memoryUsage;
        }

        public void setMemoryUsage(int memoryUsage) {
            this.memoryUsage = memoryUsage;
        }
    }

    private static class ClusterService
    extends ClusterResource {
        private String type;

        public ClusterService(JsonElement nodeElement) {
            super(nodeElement);
        }

        @Override
        protected void fillResourceWithMetadata() {
            super.fillResourceWithMetadata();
            this.type = JsonUtils.getOrNullStr(this.itemJson, "spec", "type");
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class KubectlVersionResponse {
        public String major;
        public String minor;
        public String gitVersion;
        public String gitCommit;
        public String gitTreeState;
        public String buildDate;
        public String goVersion;
        public String compiler;
        public String platform;
    }

    public static class ClusterPod
    extends ClusterResourceWithStatus {
        private int containerCount = 0;
        private int readyContainerCount = 0;
        private Integer cpuRequestMillis;
        private Integer cpuLimitMillis;
        private Integer cpuCurrentMillis;
        private Long memoryRequestMB;
        private Long memoryLimitMB;
        private Long memoryCurrentMB;

        public ClusterPod(JsonElement nodeElement) {
            super(nodeElement);
            this.fillPodData();
        }

        @VisibleForTesting
        public ClusterPod(String name) {
            super(name);
        }

        public Integer getCpuCurrentMillis() {
            return this.cpuCurrentMillis;
        }

        public Long getMemoryCurrentMB() {
            return this.memoryCurrentMB;
        }

        public ClusterPod withCpuCurrentMillis(Integer cpuCurrentMillis) {
            this.cpuCurrentMillis = cpuCurrentMillis;
            return this;
        }

        public ClusterPod withMemoryCurrentMB(Long memoryCurrentMB) {
            this.memoryCurrentMB = memoryCurrentMB;
            return this;
        }

        @Override
        protected void fillResourceStatus() {
            this.status = StringUtils.isNotBlank((String)JsonUtils.getOrNullStr(this.itemJson, KubernetesClusterService.METADATA, "deletionTimestamp")) ? "Terminating" : JsonUtils.getOrNullStr(this.itemJson, KubernetesClusterService.STATUS, "phase");
        }

        private void fillPodData() {
            String memoryLimit;
            String memoryReq;
            String cpuLimit;
            int totalContainers = 0;
            int readyContainers = 0;
            logger.trace((Object)("FillPodData, itemJson=" + JSON.json((Object)this.itemJson)));
            JsonObject statusJson = JsonUtils.getOrEmptyObj(this.itemJson, KubernetesClusterService.STATUS);
            for (JsonElement containerStatus : JsonUtils.getOrEmptyArr(statusJson, "containerStatuses")) {
                ++totalContainers;
                JsonElement ready = JsonUtils.getOrNull((JsonElement)containerStatus.getAsJsonObject(), "ready");
                if (ready == null || !ready.getAsBoolean()) continue;
                ++readyContainers;
            }
            String cpuReq = JsonUtils.getOrNullStr(this.itemJson, "spec", "containers", 0, "resources", "requests", "cpu");
            if (cpuReq != null) {
                this.cpuRequestMillis = new CpuQuantity(cpuReq).getAsMilli();
            }
            if ((cpuLimit = JsonUtils.getOrNullStr(this.itemJson, "spec", "containers", 0, "resources", "limits", "cpu")) != null) {
                this.cpuLimitMillis = new CpuQuantity(cpuLimit).getAsMilli();
            }
            if ((memoryReq = JsonUtils.getOrNullStr(this.itemJson, "spec", "containers", 0, "resources", "requests", "memory")) != null) {
                this.memoryRequestMB = new MemoryQuantity(memoryReq).getAsMb();
            }
            if ((memoryLimit = JsonUtils.getOrNullStr(this.itemJson, "spec", "containers", 0, "resources", "limits", "memory")) != null) {
                this.memoryLimitMB = new MemoryQuantity(memoryLimit).getAsMb();
            }
            this.containerCount = totalContainers;
            this.readyContainerCount = readyContainers;
        }
    }

    private static class ClusterResourceWithStatus
    extends ClusterResource {
        protected String status = "Unknown";

        protected ClusterResourceWithStatus(String name) {
            super(name);
        }

        public ClusterResourceWithStatus(JsonElement nodeElement) {
            super(nodeElement);
            this.fillResourceStatus();
        }

        protected void fillResourceStatus() {
            String displayStatus = "Unknown";
            for (JsonElement conditionElement : JsonUtils.getOrEmptyArr(this.itemJson, KubernetesClusterService.STATUS, "conditions")) {
                JsonObject conditionJson = conditionElement.getAsJsonObject();
                String type = JsonUtils.getOrNullStr(conditionJson, "type");
                JsonElement statusElement = JsonUtils.getOrNull((JsonElement)conditionJson, KubernetesClusterService.STATUS);
                if (!"Ready".equals(type) || statusElement == null) continue;
                displayStatus = statusElement.getAsBoolean() ? "Ready" : "Not ready";
            }
            this.status = displayStatus;
        }
    }

    private static class ClusterResource {
        protected String name;
        protected String namespace;
        private String dssSubmitter;
        private String dssExecutionType;
        private String dssProjectKey;
        private boolean onLocalDssNode;
        private String analysisId;
        private String webappId;
        private String notebookId;
        private String datasetName;
        private String jobId;
        private String activityId;
        private String deploymentId;
        private String codeStudioId;
        protected transient JsonObject itemJson;

        protected ClusterResource(String name) {
            this.name = name;
        }

        public ClusterResource(JsonElement nodeElement) {
            this.itemJson = nodeElement.getAsJsonObject();
            this.fillResourceWithMetadata();
        }

        protected void fillResourceWithMetadata() {
            this.name = JsonUtils.getOrNullStr(this.itemJson, KubernetesClusterService.METADATA, "name");
            this.namespace = JsonUtils.getOrNullStr(this.itemJson, KubernetesClusterService.METADATA, "namespace");
            JsonObject annotations = JsonUtils.getOrEmptyObj(this.itemJson, KubernetesClusterService.METADATA, "annotations");
            String localInstallId = ApplicationConfigurator.getInstallId();
            String installId = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-install-id");
            if (StringUtils.isNotBlank((String)installId)) {
                this.dssExecutionType = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-execution-type");
                this.dssSubmitter = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-exec-submitter");
                this.dssProjectKey = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-project-key");
                this.onLocalDssNode = localInstallId.equals(installId);
                this.analysisId = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-analysis-id");
                this.webappId = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-webapp-id");
                this.notebookId = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-notebook-id");
                this.datasetName = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-dataset-name");
                this.jobId = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-job-id");
                this.activityId = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-activity-id");
                this.deploymentId = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-apideployer-deployment-id");
                this.codeStudioId = JsonUtils.getOrNullStr(annotations, "dataiku.com/dku-codestudio-id");
            }
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }
    }
}

