/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.coremodel.ProjectVersionTags;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.IStandardDAO;
import com.dataiku.dip.dao.ProjectVersionTagsDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractStandardDAO<T extends TaggableObjectsService.TaggableObject>
implements IStandardDAO<T> {
    @Autowired
    private ProjectVersionTagsDAO versionTagsDAO;
    protected Logger logger = Logger.getLogger((String)"dku.dao");

    protected abstract T getOrNull_noTag(String var1, String var2, boolean var3) throws IOException;

    protected abstract List<T> list_noTag(String var1, boolean var2) throws IOException;

    protected abstract RelFile getDAOFile(String var1, String var2) throws IOException;

    protected abstract String getHumanReadableType();

    protected T getOrNull(String projectKey, String id, boolean unsafe) throws IOException {
        VersionTag recordedTag;
        T object = this.getOrNull_noTag(projectKey, id, unsafe);
        if (object != null && (recordedTag = this.versionTagsDAO.getSingleTag(projectKey, (TaggableObjectsService.TaggableObject)object, unsafe)) != null) {
            ((TaggableObjectsService.TaggableObject)object).versionTag = recordedTag;
        }
        return object;
    }

    protected List<T> list(String projectKey, boolean unsafe) throws IOException {
        List<T> list = this.list_noTag(projectKey, unsafe);
        if (list != null) {
            for (TaggableObjectsService.TaggableObject object : list) {
                VersionTag recordedTag = this.versionTagsDAO.getSingleTag(projectKey, object, unsafe);
                if (recordedTag == null) continue;
                object.versionTag = recordedTag;
            }
        }
        return list;
    }

    protected void write(RWTransactionRef t, T object) throws IOException {
        RelFile objectFile = this.getDAOFile(((TaggableObjectsService.TaggableObject)object).getProjectKey(), ((TaggableObjectsService.TaggableObject)object).getId());
        t.writeObject(objectFile, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(T object) throws IOException {
        Preconditions.checkNotNull(object, (Object)"Object is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)((TaggableObjectsService.TaggableObject)object).getProjectKey()), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)((TaggableObjectsService.TaggableObject)object).getId()), (Object)"Object id is not specified");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        VersionTag tag = ((TaggableObjectsService.TaggableObject)object).versionTag;
        try {
            ((TaggableObjectsService.TaggableObject)object).versionTag = null;
            this.write(t, object);
            if (tag != null) {
                ProjectVersionTags versionTags = this.versionTagsDAO.get(((TaggableObjectsService.TaggableObject)object).getProjectKey(), false);
                versionTags.setTag((TaggableObjectsService.TaggableObject)object, tag);
                this.versionTagsDAO.save(versionTags);
            }
        }
        finally {
            ((TaggableObjectsService.TaggableObject)object).versionTag = tag;
        }
    }

    @Override
    public List<T> list(String projectKey) throws IOException {
        return this.list(projectKey, false);
    }

    @Override
    public List<T> listUnsafe(String projectKey) throws IOException {
        return this.list(projectKey, true);
    }

    @Override
    public T getOrNull(String projectKey, String id) throws IOException {
        return this.getOrNull(projectKey, id, false);
    }

    @Override
    public T getOrNullUnsafe(String projectKey, String id) throws IOException {
        return this.getOrNull(projectKey, id, true);
    }

    @Override
    public T getMandatory(String projectKey, String id) throws IOException {
        return this.getMandatory(projectKey, id, false);
    }

    @Override
    public T getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return this.getMandatory(projectKey, id, true);
    }

    protected T getMandatory(String projectKey, String id, boolean unsafe) throws IOException {
        T obj = this.getOrNull(projectKey, id, unsafe);
        if (obj == null) {
            throw new NotFoundException(this.getHumanReadableType() + " does not exist: " + projectKey + "." + id);
        }
        return obj;
    }

    @Override
    public T getOrNull(AnyLoc loc) throws IOException {
        return (T)this.getOrNull(loc.getProjectKey(), loc.getId());
    }

    @Override
    public T getMandatory(AnyLoc loc) throws IOException {
        return (T)this.getMandatory(loc.getProjectKey(), loc.getId());
    }

    @Override
    public T getOrNullUnsafe(AnyLoc loc) throws IOException {
        return (T)this.getOrNullUnsafe(loc.getProjectKey(), loc.getId());
    }

    @Override
    public T getMandatoryUnsafe(AnyLoc loc) throws IOException {
        return (T)this.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
    }

    @Override
    public String generateUniqueId(String projectKey) throws IOException {
        for (int i = 0; i < 10; ++i) {
            String id = SecretKeyGenerator.generateSmall();
            if (this.getOrNullUnsafe(projectKey, id) != null) continue;
            return id;
        }
        throw new RuntimeException("Failed to generate a unique id");
    }

    @Override
    public boolean exists(String projectKey, String id) throws IOException {
        TransactionRef tr = TransactionContext.retrieveRead();
        RelFile rf = this.getDAOFile(projectKey, id);
        return tr.isFile(rf);
    }

    @VisibleForTesting
    public AbstractStandardDAO<T> withInjectedDAOs(ProjectVersionTagsDAO versionTagsDAO) {
        this.versionTagsDAO = versionTagsDAO;
        return this;
    }
}

