/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.badges.ProjectBadges;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class ProjectBadgesDAO {
    public ProjectBadges read(String projectKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey), (Object)"Project key is not specified");
        TransactionRef t = TransactionContext.retrieveRead();
        return (ProjectBadges)t.readObjectDefault(this.getBadgesFile(projectKey), ProjectBadges.class);
    }

    public ProjectBadges getUnsafe(String projectKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey), (Object)"Project key is not specified");
        TransactionRef t = TransactionContext.retrieveRead();
        return (ProjectBadges)t.readObjectDefaultUnsafe(this.getBadgesFile(projectKey), ProjectBadges.class);
    }

    public void save(String projectKey, ProjectBadges badges) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey), (Object)"Project key is not specified");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(this.getBadgesFile(projectKey), (Object)badges);
    }

    public boolean exists(String projectKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)projectKey), (Object)"Project key is not specified");
        TransactionRef t = TransactionContext.retrieveRead();
        return t.exists(this.getBadgesFile(projectKey));
    }

    private RelFile getBadgesFile(String projectKey) {
        return new RelFile(new String[]{"projects", projectKey, "badges.json"});
    }
}

