/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datacollections;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.datacollections.DataCollection;
import com.dataiku.dip.datacollections.DataCollectionColumnsCustomization;
import com.dataiku.dip.dataquality.DataQualityDailyStatus;
import com.dataiku.dip.security.BasePermissions;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface UIDataCollection {

    @UIModel
    public static class RecentDatasetInfo {
        public final String name;
        public final String datasetType;
        public final String sourceProjectKey;
        public String sourceProjectName;
        public long lastAddedOnDataCollection = -1L;
        public boolean hasAnyProjectAccess;
        public boolean canRequestAccess;
        public final List<RecentDataCollectionDatasetInfo> recentDataCollectionDatasetInfos;
        public ExposedObjectsService.ObjectAuthorizations objectAuthorizations;

        public RecentDatasetInfo(SerializedDataset dataset, String projectKey) {
            this.name = dataset.name;
            this.datasetType = dataset.type;
            this.recentDataCollectionDatasetInfos = new ArrayList<RecentDataCollectionDatasetInfo>();
            this.sourceProjectKey = projectKey;
        }

        public void setProjectName(String projectName) {
            this.sourceProjectName = projectName;
        }

        public void addDatasetDataCollection(DataCollection collection, long lastAddedOnDataCollection) {
            this.lastAddedOnDataCollection = Math.max(this.lastAddedOnDataCollection, lastAddedOnDataCollection);
            this.recentDataCollectionDatasetInfos.add(new RecentDataCollectionDatasetInfo(collection, lastAddedOnDataCollection));
        }
    }

    public static class RecentDataCollectionDatasetInfo {
        public String id;
        public String displayName;
        public long datasetLastAddedOn;

        public RecentDataCollectionDatasetInfo(DataCollection collection, long datasetLastAddedOn) {
            this.id = collection.id;
            this.displayName = collection.displayName;
            this.datasetLastAddedOn = datasetLastAddedOn;
        }
    }

    @UIModel
    public static class ListItemWithDetails {
        public final String id;
        public final String displayName;
        public final String color;
        public final String description;
        public final List<String> tags;
        public final int itemCount;
        public final long lastModifiedOn;

        public ListItemWithDetails(DataCollection collection) {
            this.id = collection.id;
            this.displayName = collection.displayName;
            this.color = collection.color;
            this.description = collection.description;
            this.tags = collection.tags;
            this.itemCount = collection.items.size();
            this.lastModifiedOn = collection.versionTag == null ? -1L : collection.versionTag.getLastModifiedOn();
        }
    }

    @UIModel
    public static class ListItem {
        public final String id;
        public final MetadataInfo metadata;
        public final MetadataCompletenessChecks metadataCompletenessChecks;

        public ListItem(DataCollection collection) {
            this.id = collection.id;
            this.metadata = collection.getMetadata();
            this.metadataCompletenessChecks = collection.getMetadataCompletenessChecks();
        }
    }

    @UIModel
    public static class DataCollectionInfo {
        public String id;
        public final String displayName;
        public final String color;
        public final String description;
        public final List<String> tags;
        public final List<AbstractDataCollectionItemInfo> items;
        public final List<BasePermissions.PermissionItem> permissions;
        public BasePermissions.Permissions currentUserPermissions;
        public MetadataCompletenessChecks metadataCompletenessChecks;
        public DataCollectionColumnsCustomization columnsCustomizationSettings;

        public DataCollectionInfo(DataCollection collection, List<AbstractDataCollectionItemInfo> items, BasePermissions.Permissions currentUserPermissions) {
            this.id = collection.id;
            this.displayName = collection.displayName;
            this.color = collection.color;
            this.description = (String)StringUtils.defaultIfBlank((CharSequence)collection.description, (CharSequence)"");
            this.tags = collection.tags;
            this.metadataCompletenessChecks = collection.getMetadataCompletenessChecks();
            this.columnsCustomizationSettings = collection.columnsCustomizationSettings;
            this.currentUserPermissions = currentUserPermissions;
            this.permissions = currentUserPermissions.admin && collection.permissions != null ? collection.permissions : new ArrayList<BasePermissions.PermissionItem>();
            this.items = items;
        }

        public DataCollectionInfo(String id, String displayName, String color, String description, List<String> tags, List<BasePermissions.PermissionItem> permissions) {
            this.id = id;
            this.displayName = displayName;
            this.color = color;
            this.description = description;
            this.tags = tags;
            this.permissions = permissions;
            this.items = new ArrayList<AbstractDataCollectionItemInfo>();
        }
    }

    public static class DiscoverableDatasetInfo
    extends AbstractDatasetInfo {
        public static final String TYPE = "discoverable-dataset";

        public DiscoverableDatasetInfo(SerializedDataset dataset, SerializedProject sourceProject, DataQualityDailyStatus quality, Integer emptyDescriptionColumnsCount) {
            super(dataset, sourceProject, quality, emptyDescriptionColumnsCount);
        }

        private DiscoverableDatasetInfo() {
        }
    }

    public static class DatasetInfo
    extends AbstractDatasetInfo {
        public static final String TYPE = "dataset";
        public int usedInProjectCount;
        public int columnCount;
        public long lastBuiltOn;

        public DatasetInfo(SerializedDataset dataset, SerializedProject sourceProject, long lastBuiltOn, DataQualityDailyStatus quality, Integer emptyDescriptionColumnsCount) {
            super(dataset, sourceProject, quality, emptyDescriptionColumnsCount);
            this.usedInProjectCount = sourceProject.exposedObjects.getProjectsExposedTo(ITaggingService.TaggableType.DATASET, this.name).size() + 1;
            this.columnCount = dataset.getSchema().columns.size();
            this.lastBuiltOn = lastBuiltOn;
        }

        private DatasetInfo() {
        }
    }

    public static abstract class AbstractDatasetInfo
    extends AbstractDataCollectionItemInfo {
        public String name;
        public String datasetType;
        public String sourceProjectKey;
        public String sourceProjectName;
        public String shortDescription;
        public String longDescription;
        public DataQualityDailyStatus quality;
        public Integer emptyDescriptionColumnsCount;

        protected AbstractDatasetInfo(SerializedDataset dataset, SerializedProject sourceProject, DataQualityDailyStatus quality, Integer emptyDescriptionColumnsCount) {
            this.name = dataset.getDisplayName();
            this.datasetType = dataset.type;
            this.sourceProjectKey = sourceProject.projectKey;
            this.sourceProjectName = sourceProject.name;
            this.shortDescription = (String)StringUtils.defaultIfBlank((CharSequence)dataset.shortDesc, (CharSequence)"");
            this.longDescription = (String)StringUtils.defaultIfBlank((CharSequence)dataset.description, (CharSequence)"");
            this.quality = quality;
            this.emptyDescriptionColumnsCount = emptyDescriptionColumnsCount;
        }

        private AbstractDatasetInfo() {
        }
    }

    @PolyJSON(value={@Mapping(value=DatasetInfo.class, type="dataset"), @Mapping(value=DiscoverableDatasetInfo.class, type="discoverable-dataset")})
    @UIModel
    public static abstract class AbstractDataCollectionItemInfo {
    }

    @UIModel
    public static class AddObjectsResponse {
        public boolean modified;
        public boolean allDataStewardsDefined;

        public AddObjectsResponse(boolean modified, boolean allDataStewardsDefined) {
            this.modified = modified;
            this.allDataStewardsDefined = allDataStewardsDefined;
        }
    }

    @UIModel
    public static class AddObject {
        public TaggableObjectsService.TaggableObjectRef ref;
        public Set<SerializedProject.ReaderAuthorization.Mode> requestedReaderAuthorizations = new HashSet<SerializedProject.ReaderAuthorization.Mode>();
        public boolean requestQuickSharing = false;
    }

    public static class ObjectAuthorizationsWithDisplayName
    extends ObjectAuthorizations {
        public String displayName;
        public String subtype;

        public ObjectAuthorizationsWithDisplayName(TaggableObjectsService.TaggableObject to, boolean isQuicklyShareable, boolean canManageExposedElements, boolean allAuthorized, Set<SerializedProject.ReaderAuthorization.Mode> authorizations) {
            super(new TaggableObjectsService.TaggableObjectRef(to.getProjectKey(), to.getTaggableType(), to.getId()), isQuicklyShareable, canManageExposedElements, allAuthorized, authorizations);
            this.displayName = to.getDisplayName();
            this.subtype = to.getSubtype();
        }
    }

    @UIModel
    public static class ObjectAuthorizations {
        public TaggableObjectsService.TaggableObjectRef ref;
        public boolean isQuicklyShareable;
        public boolean canManageExposedElements;
        public boolean allAuthorized;
        public Set<SerializedProject.ReaderAuthorization.Mode> authorizations;

        public ObjectAuthorizations(TaggableObjectsService.TaggableObjectRef ref, boolean isQuicklyShareable, boolean canManageExposedElements, boolean allAuthorized, Set<SerializedProject.ReaderAuthorization.Mode> authorizations) {
            this.ref = ref;
            this.isQuicklyShareable = isQuicklyShareable;
            this.canManageExposedElements = canManageExposedElements;
            this.allAuthorized = allAuthorized;
            this.authorizations = authorizations;
        }
    }

    @UIModel
    public static class MetadataInfo {
        public String displayName;
        public String description;
        public String color;
        public List<String> tags;

        public MetadataInfo(String displayName, String description, String color, List<String> tags) {
            this.displayName = displayName;
            this.description = description;
            this.color = color;
            this.tags = tags;
        }
    }

    @UIModel
    public static class CreationInfo {
        public String displayName;
        public String color;
        public String description;
        public List<BasePermissions.PermissionItem> permissions = new ArrayList<BasePermissions.PermissionItem>();
        public DataCollection.MetadataCompletenessChecks metadataCompletenessChecks = new DataCollection.MetadataCompletenessChecks();
    }

    @UIModel
    public static class MetadataCompletenessChecks {
        public DataCollection.CompletenessCheckType longDescriptionCheck;
        public DataCollection.CompletenessCheckType columnsDescriptionCheck;

        public MetadataCompletenessChecks(DataCollection.MetadataCompletenessChecks qualityChecksSettings) {
            if (qualityChecksSettings == null) {
                this.longDescriptionCheck = DataCollection.CompletenessCheckType.DISABLED;
                this.columnsDescriptionCheck = DataCollection.CompletenessCheckType.DISABLED;
            } else {
                this.longDescriptionCheck = qualityChecksSettings.longDescriptionCheck;
                this.columnsDescriptionCheck = qualityChecksSettings.columnsDescriptionCheck;
            }
        }
    }
}

