/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.commands.PartitionRefreshCommand;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobRuntimeSummary;
import com.dataiku.dip.dataflow.jobrunner.SerializedJob;
import com.dataiku.dip.dataflow.jobrunner.status.CoreJobStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Job {
    public JobDef def;
    public AuthCtx initiator;
    public PartitionRefreshCommand command;
    public JobActivity topLevelActivity;
    public JobRuntimeSummary runSummary = new JobRuntimeSummary();

    public Job(JobDef def, JobActivity topLevelActivity) {
        this.def = def;
        this.topLevelActivity = topLevelActivity;
    }

    public Map<String, Set<TaggableObjectsService.TaggableObjectRef>> getSources() {
        HashMap<String, Set<TaggableObjectsService.TaggableObjectRef>> ret = new HashMap<String, Set<TaggableObjectsService.TaggableObjectRef>>();
        this.getSourcesRec(this.topLevelActivity, ret);
        return ret;
    }

    public SerializedJob getSerialized() {
        return new SerializedJob(this.topLevelActivity);
    }

    public CoreJobStatus getStatus() {
        CoreJobStatus sjs = new CoreJobStatus();
        this.getStatusRec(sjs, this.topLevelActivity);
        this.computeExecutionOrder(sjs, this.topLevelActivity);
        return sjs;
    }

    private void getStatusRec(CoreJobStatus sjs, JobActivity act) {
        this.getStatusRec(sjs, act, new HashSet<String>());
    }

    private void getStatusRec(CoreJobStatus sjs, JobActivity act, Set<String> alreadyVisited) {
        if (alreadyVisited.contains(act.id())) {
            return;
        }
        alreadyVisited.add(act.id());
        for (JobActivity dependency : act.dependencies) {
            this.getStatusRec(sjs, dependency, alreadyVisited);
        }
        if (act.getSubgraph() != null) {
            sjs.activities.put(act.id(), act.getStatus());
        }
    }

    private void computeExecutionOrder(CoreJobStatus sjs, JobActivity act) {
        HashMap<String, JobActivity> activityMap = new HashMap<String, JobActivity>();
        ArrayDeque<JobActivity> queue = new ArrayDeque<JobActivity>();
        queue.add(act);
        while (!queue.isEmpty()) {
            JobActivity ja = (JobActivity)queue.poll();
            if (activityMap.containsKey(ja.id())) continue;
            activityMap.put(ja.id(), ja);
            queue.addAll(ja.dependencies);
        }
        int order = 0;
        HashSet<String> satisfiedDependencies = new HashSet<String>();
        while (satisfiedDependencies.size() < activityMap.size()) {
            ArrayList<String> runnables = new ArrayList<String>();
            for (Map.Entry item : activityMap.entrySet()) {
                boolean runnable = !satisfiedDependencies.contains(item.getKey());
                for (JobActivity dep : ((JobActivity)item.getValue()).dependencies) {
                    if (satisfiedDependencies.contains(dep.id())) continue;
                    runnable = false;
                }
                if (!runnable) continue;
                runnables.add((String)item.getKey());
            }
            for (String id : runnables) {
                satisfiedDependencies.add(id);
                if (!sjs.activities.containsKey(id)) continue;
                sjs.activities.get((Object)id).partialExecutionOrder = order;
            }
            ++order;
        }
    }

    private void getSourcesRec(JobActivity act, Map<String, Set<TaggableObjectsService.TaggableObjectRef>> sourceRefs) {
        this.getSourcesRec(act, sourceRefs, new HashSet<String>());
    }

    private void getSourcesRec(JobActivity act, Map<String, Set<TaggableObjectsService.TaggableObjectRef>> sourceRefs, Set<String> alreadyVisited) {
        if (alreadyVisited.contains(act.id())) {
            return;
        }
        alreadyVisited.add(act.id());
        for (JobActivity dependency : act.dependencies) {
            this.getSourcesRec(dependency, sourceRefs, alreadyVisited);
        }
        if (act.getSubgraph() != null) {
            RunnableSubgraph runnableSubgraph = act.getSubgraph();
            List<FlowRecipe> recipes = runnableSubgraph.listRecipes();
            assert (!recipes.isEmpty());
            String contextProjectKey = recipes.get(0).getProjectKey();
            block9: for (FlowComputable flowComputable : runnableSubgraph.getSources()) {
                ITaggingService.TaggableType taggableType;
                switch (flowComputable.getType()) {
                    case DATASET: {
                        taggableType = ITaggingService.TaggableType.DATASET;
                        break;
                    }
                    case MANAGED_FOLDER: {
                        taggableType = ITaggingService.TaggableType.MANAGED_FOLDER;
                        break;
                    }
                    case SAVED_MODEL: {
                        taggableType = ITaggingService.TaggableType.SAVED_MODEL;
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        taggableType = ITaggingService.TaggableType.MODEL_EVALUATION_STORE;
                        break;
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        taggableType = ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE;
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        Logger.getLogger((String)"dip.job").info((Object)("Ignore streaming endpoint " + flowComputable.getFullId()));
                        continue block9;
                    }
                    default: {
                        continue block9;
                    }
                }
                AnyLoc loc = AnyLoc.resolveFull(flowComputable.getFullId());
                TaggableObjectsService.TaggableObjectRef ref = new TaggableObjectsService.TaggableObjectRef(loc.getProjectKey(), taggableType, loc.getId());
                sourceRefs.computeIfAbsent(contextProjectKey, k -> new HashSet()).add(ref);
            }
        }
    }
}

