/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.dataflow.kernel.master.JobSession;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;

public class JobTicketUtils {
    public static void setJobMetadataInTicket(JobSession session, APITicketService.Ticket ticket) {
        ticket.metadata.put("jobProjectKey", session.def.projectKey);
        ticket.metadata.put("jobId", session.def.id);
        ticket.metadata.put("jobInitiator", session.def.initiator);
    }

    public static boolean isJobTicket(APITicketService.Ticket ticket) {
        return ticket.metadata.containsKey("jobProjectKey") && ticket.metadata.containsKey("jobId");
    }

    public static ComputeResourceUsageContext makeJobActivityCRUContextFromTicket(AuthCtx authCtx, APITicketService.Ticket ticket, String activityId) {
        String projectKey = (String)ticket.metadata.get("jobProjectKey");
        String jobId = (String)ticket.metadata.get("jobId");
        return ComputeResourceUsageContext.forJobActivity((AuthCtx)authCtx, (String)projectKey, (String)jobId, (String)activityId);
    }
}

