/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.ProjectLibPathHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.ComputableFromRefService;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedActivityRunner;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.kernel.slave.DSSJobKernelMain;
import com.dataiku.dip.dataflow.streaming.ContinuousActivity;
import com.dataiku.dip.dataflow.streaming.slave.DSSCAKernelMain;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.dataflow.utils.FlowVariables;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeParams;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class EnvironmentStash {
    private static String fakeWriterBasePath;
    private static Map<String, Schema> forcedSchemaMap;
    public Map<String, String> env = Maps.newHashMap();
    public String apiTicket;
    public String projectKey;
    public List<String> pythonPath = Lists.newArrayList();
    public List<String> rsrcPath = Lists.newArrayList();
    public Map<String, String> flowVariables;
    public Map<String, Object> customVariables;
    public AbstractCodeBasedActivityRunner.FlowSpec flowSpec;
    private static DKULogger logger;

    public static void setUseFakeWriter(String basePath) {
        fakeWriterBasePath = basePath;
    }

    public static void setForcedDatasetSchema(String fullName, Schema schema) {
        forcedSchemaMap.put(fullName, schema);
    }

    public Map<String, String> getAsEnvVariables(boolean addPythonPathForLocalExecution, boolean addDkuRPathForLocalExecution, boolean addFlowVariablesInEnv) {
        HashMap ret = Maps.newHashMap();
        Set<String> excludedKeys = EnvironmentStash.getExcludedEnvKeys(false);
        for (Map.Entry<String, String> e : this.env.entrySet()) {
            if (excludedKeys.contains(e.getKey())) continue;
            ret.put(e.getKey(), e.getValue());
        }
        if (StringUtils.isNotBlank((String)this.apiTicket)) {
            ret.put("DKU_API_TICKET", this.apiTicket);
        }
        if (StringUtils.isNotBlank((String)this.projectKey)) {
            ret.put("DKU_CURRENT_PROJECT_KEY", this.projectKey);
        }
        if (this.flowVariables != null && addFlowVariablesInEnv) {
            ret.put("DKUFLOW_VARIABLES", JSON.pretty(this.flowVariables));
        }
        if (this.customVariables != null && addFlowVariablesInEnv) {
            ret.put("DKU_CUSTOM_VARIABLES", JSON.jsonWithUnicodeEscaped(this.customVariables));
        }
        if (addPythonPathForLocalExecution) {
            ArrayList finalPythonPath = Lists.newArrayList(this.pythonPath);
            String sysPythonPath = System.getenv("PYTHONPATH");
            if (StringUtils.isNotBlank((String)sysPythonPath)) {
                finalPythonPath.add(sysPythonPath);
            }
            ret.put("PYTHONPATH", Joiner.on((String)File.pathSeparator).join((Iterable)finalPythonPath));
        }
        if (addDkuRPathForLocalExecution) {
            ret.put("DKU_SOURCE_LIB_R_PATH", Joiner.on((String)File.pathSeparator).join(this.rsrcPath));
        }
        if (fakeWriterBasePath != null) {
            ret.put("FLOW_FAKE_WRITER", "true");
            ret.put("FLOW_FAKE_WRITER_ROOT", fakeWriterBasePath);
        }
        ret.put("FLOW_FORCED_SCHEMAS", JSON.pretty(forcedSchemaMap));
        if (this.flowSpec != null && addFlowVariablesInEnv) {
            ret.put("DKUFLOW_SPEC", JSON.pretty((Object)this.flowSpec));
        }
        return ret;
    }

    public void copyToRemoteRunEnvDef(RemoteRunEnvDef envResource, boolean addPythonPathForLocalExecution, boolean addDkuRPathForLocalExecution, boolean addFlowVariablesInEnv) {
        envResource.env = this.getAsEnvVariables(addPythonPathForLocalExecution, addDkuRPathForLocalExecution, addFlowVariablesInEnv);
        envResource.flowVariables = this.flowVariables;
        envResource.customVariables = this.customVariables;
        envResource.flowSpec = this.flowSpec;
    }

    public EnvironmentStash fillDefault() {
        this.env.putAll(DKUtils.getEnvironment());
        return this;
    }

    public EnvironmentStash fillDefaultForLocalExec() {
        String basePort = RemoteRunNetworkingUtils.getBasePort();
        if (basePort != null) {
            this.env.put("DKU_BASE_PORT", basePort);
        }
        this.env.put("DKU_BASE_PROTOCOL", RemoteRunNetworkingUtils.getBaseProtocol());
        return this;
    }

    public EnvironmentStash fillDefaultForRemote() {
        Set<String> excludedKeys = EnvironmentStash.getExcludedEnvKeys(true);
        HashSet excludedValues = Sets.newHashSet();
        String excludedValuesStr = ApplicationConfigurator.getParams().getParam("dku.remote.env.value.exclusion", "[]");
        excludedValues.addAll((Collection)JSON.parse((String)excludedValuesStr, (TypeToken)new TypeToken<List<String>>(){}));
        for (Map.Entry e : DKUtils.getEnvironment().entrySet()) {
            if (excludedKeys.contains(e.getKey())) continue;
            String v = StringUtils.defaultIfEmpty((String)((String)e.getValue()), (String)"");
            if (excludedValues.stream().anyMatch(s -> v.contains((CharSequence)s))) continue;
            this.env.put((String)e.getKey(), (String)e.getValue());
        }
        return this;
    }

    private static Set<String> getExcludedEnvKeys(boolean remote) {
        HashSet excludedKeys = Sets.newHashSet();
        String excludedKeysStr = ApplicationConfigurator.getParams().getParam("dku.any.env.key.exclusion", "[\"HOME\",\"USER\",\"PATH\",\"TMPDIR\",\"LD_LIBRARY_PATH\",\"XLA_FLAGS\"]");
        if (remote) {
            excludedKeysStr = ApplicationConfigurator.getParams().getParam("dku.remote.env.key.exclusion", excludedKeysStr);
        }
        try {
            excludedKeys.addAll((Collection)JSON.parse((String)excludedKeysStr, (TypeToken)new TypeToken<List<String>>(){}));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid value for the dku.remote.env.key.exclusion property, it needs to be a list of strings in JSON", e);
        }
        return excludedKeys;
    }

    public void fillForVisualRecipe(JobActivity activity) {
        RunnableSubgraph subgraph = activity.getSubgraph();
        FlowRecipe recipe = ((RecipeRunnableSubgraph)subgraph).getRecipe();
        this.fillForRecipe(recipe);
    }

    public void fillForUserCodeRecipe(AuthCtx authCtx, JobActivity activity, File tmpDir, AppendModeGetter appendModeGetter) throws IOException, SQLException, CodedException, DKUSecurityException {
        RunnableSubgraph subgraph = activity.getSubgraph();
        FlowRecipe recipe = ((RecipeRunnableSubgraph)subgraph).getRecipe();
        this.fillForRecipe(recipe);
        this.flowVariables = new HashMap<String, String>();
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        FlowVariables.addPartitioningVariables(authCtx, this.flowVariables, subgraph, datasetsDAO);
        this.flowVariables.putAll(FlowVariables.getSQLTableVariables(authCtx, recipe.getModel()));
        this.customVariables = this.getCustomVariablesFromProject(this.projectKey);
        if (FlowJobUtils.getCurrentJobFolder() != null) {
            this.env.put("DKUFLOW_CONTEXT_FOLDER", FlowJobUtils.getCurrentJobFolder().getAbsolutePath());
        }
        this.flowSpec = this.buildSpec(activity, tmpDir, datasetsDAO, appendModeGetter);
        this.fillProjectLibsForJob(tmpDir);
    }

    private void fillForRecipe(FlowRecipe recipe) {
        this.projectKey = recipe.getProjectKey();
        this.fillCommunicationVars();
        APITicketService.TicketUsage tu = ((APITicketService)SpringUtils.getBean(APITicketService.class)).getAndUseSingleTicket();
        assert (tu != null);
        this.apiTicket = tu.getTicket().getSecret();
    }

    public void fillForContinuousRecipe(AuthCtx authCtx, ContinuousActivity activity, File tmpDir) throws IOException, SQLException, CodedException, DKUSecurityException {
        this.projectKey = activity.projectKey;
        this.flowVariables = new HashMap<String, String>();
        RecipesDAO recipesDAO = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
        SerializedRecipe sr = (SerializedRecipe)recipesDAO.getMandatory(activity.projectKey, activity.recipeId);
        this.flowVariables.putAll(FlowVariables.getSQLTableVariables(authCtx, sr));
        this.customVariables = this.getCustomVariablesFromProject(this.projectKey);
        if (FlowJobUtils.getCurrentJobFolder() != null) {
            this.env.put("DKUFLOW_CONTEXT_FOLDER", FlowJobUtils.getCurrentJobFolder().getAbsolutePath());
        }
        this.flowSpec = EnvironmentStash.buildNoAppendFlowSpec(activity);
        this.fillCommunicationVars();
        this.fillProjectLibsForNonJob(authCtx, tmpDir);
        APITicketService.TicketUsage tu = ((APITicketService)SpringUtils.getBean(APITicketService.class)).getAndUseSingleTicket();
        assert (tu != null);
        this.apiTicket = tu.getTicket().getSecret();
    }

    private Map<String, Object> getCustomVariablesFromProject(String projectKey) {
        HashMap vars = Maps.newHashMap();
        vars.putAll(((VariablesService)SpringUtils.getBean(VariablesService.class)).getContext(projectKey).getAllVariables());
        return vars;
    }

    public void fillProjectLibsForJob(File tmpDir) throws IOException {
        DSSGitModel.ExternalLibraries externalLibraries;
        ProjectLibPathHelper.ProjectLibsPaths outputAbsolutePaths = new ProjectLibPathHelper.ProjectLibsPaths();
        outputAbsolutePaths.projectKey = this.projectKey;
        ProjectLibPathHelper.preparePathsFromProjectCopyIfNeeded(this.projectKey, tmpDir, outputAbsolutePaths);
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead(IsolationLevel.YOLO);){
            RelFile externalLibrariesFile = new RelFile(new String[]{"projects", this.projectKey, "lib", "external-libraries.json"});
            externalLibraries = (DSSGitModel.ExternalLibraries)t.readObjectDefault(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
        }
        for (String foreignProjectKey : externalLibraries.getNonNullLibrariesFromProjects()) {
            logger.info((Object)("Fetching foreign libs from project " + foreignProjectKey));
            ProjectLibPathHelper.preparePathsFromProjectCopyIfNeeded(foreignProjectKey, tmpDir, outputAbsolutePaths);
        }
        this.pythonPath.addAll(outputAbsolutePaths.pythonPath);
        this.rsrcPath.addAll(outputAbsolutePaths.rsrcPath);
    }

    public void fillProjectLibsForNonJob(AuthCtx authCtx, File tmpDir) throws IOException, DKUSecurityException {
        DSSGitModel.ExternalLibraries externalLibraries;
        ProjectLibPathHelper.ProjectLibsPaths outputAbsolutePaths = new ProjectLibPathHelper.ProjectLibsPaths();
        outputAbsolutePaths.projectKey = this.projectKey;
        ProjectLibPathHelper.preparePathsFromProjectCopyIfNeeded(this.projectKey, tmpDir, outputAbsolutePaths);
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead(IsolationLevel.YOLO);){
            RelFile externalLibrariesFile = new RelFile(new String[]{"projects", this.projectKey, "lib", "external-libraries.json"});
            externalLibraries = (DSSGitModel.ExternalLibraries)t.readObjectDefault(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
        }
        for (String foreignProjectKey : externalLibraries.getNonNullLibrariesFromProjects()) {
            block28: {
                if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.CAK) {
                    APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                    try (APITicketService.TicketUsage tu = apiTicketService.getAndUseSingleTicket();){
                        int backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                        try (TicketBasedIntercomAPIClient apiClient = new TicketBasedIntercomAPIClient("http://127.0.0.1:" + backendPort, null, tu.getTicket().getSecret());){
                            apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-project-privilege", Void.class, new Object[]{"projectKey", foreignProjectKey, "privilege", Privileges.ProjectLevelPrivilegeType.READ_CONF.toString()});
                            break block28;
                        }
                    }
                    catch (Exception e) {
                        throw new DKUSecurityException("Unable to check permission to use " + foreignProjectKey, (Throwable)e);
                    }
                }
                try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead(IsolationLevel.YOLO);){
                    ((IPermissionsService)SpringUtils.getBean(IPermissionsService.class)).checkProjectPrivileges(authCtx, foreignProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                }
            }
            ProjectLibPathHelper.preparePathsFromProjectCopyIfNeeded(foreignProjectKey, tmpDir, outputAbsolutePaths);
        }
        this.pythonPath.addAll(outputAbsolutePaths.pythonPath);
        this.rsrcPath.addAll(outputAbsolutePaths.rsrcPath);
    }

    public EnvironmentStash fillCommunicationVars() {
        this.env.put("DKU_BACKEND_PORT", RemoteRunNetworkingUtils.getBackendRPCPort());
        this.env.put("DKU_BACKEND_HOST", RemoteRunNetworkingUtils.getBackendHost());
        this.env.put("DKU_BACKEND_PROTOCOL", EncryptedRPC.enabled() ? "https" : "http");
        this.env.put("DKU_BASE_PORT", RemoteRunNetworkingUtils.getBasePort());
        this.env.put("DKU_BASE_PROTOCOL", RemoteRunNetworkingUtils.getBaseProtocol());
        this.env.put("DKU_SERVER_KIND", String.valueOf(RemoteRunNetworkingUtils.getServerKind()));
        this.env.put("DKU_SERVER_PORT", String.valueOf(RemoteRunNetworkingUtils.getServerPort()));
        this.env.put("DKU_SERVER_HOST", RemoteRunNetworkingUtils.getBackendHost());
        this.env.put("DKU_SERVER_PROTOCOL", EncryptedRPC.enabled() ? "https" : "http");
        if (EncryptedRPC.enabled()) {
            this.env.put("DKU_SERVER_CERT", EncryptedRPC.getPEMCertificateText());
        }
        return this;
    }

    public void setCommunicationVarsForLocalOnlyExecution() {
        for (String key : Sets.newHashSet((Object[])new String[]{"DKU_BACKEND_HOST", "DKU_SERVER_HOST"})) {
            if (!this.env.containsKey(key)) continue;
            this.env.put(key + "_FOR_REMOTE", this.env.get(key));
            this.env.remove(key);
        }
    }

    public void fillForPlugin(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, CustomCodeRecipeParams params, LoadedCustomCodeRecipeDesc desc, CustomCodeRecipesService service) throws IOException, DKUSecurityException {
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = service.getExpandedPluginSettings(desc.recipeType, authCtx, projectKey, params.customConfig);
        this.env.put("DKU_CUSTOM_RECIPE_PLUGIN_ID", desc.getOwnerPluginId());
        this.env.put("DKU_CUSTOM_RECIPE_CONFIG", JSON.json((Object)expandedPluginSettings.config));
        this.env.put("DKU_CUSTOM_RECIPE_PLUGIN_CONFIG", JSON.json((Object)expandedPluginSettings.pluginConfig));
        service.putResourceFolderEnvironmentVariable(this.env, desc.getType(), containerConfig == null, "DKU_CUSTOM_RECIPE_RESOURCE_FOLDER");
    }

    public void fillForCustomPythonRecipe(LoadedCustomCodeRecipeDesc desc, CustomCodeRecipesService service) {
        String pythonlibFolder = service.getLibFolder(desc.getType());
        if (pythonlibFolder != null && pythonlibFolder.length() > 0) {
            this.pythonPath.add(pythonlibFolder);
        }
    }

    protected AbstractCodeBasedActivityRunner.FlowSpec buildSpec(JobActivity activity, File tempDir, DatasetsDAO datasetsDAO, AppendModeGetter getter) throws IOException, SQLException {
        AbstractCodeBasedActivityRunner.FlowSpec spec = EnvironmentStash.buildNoAppendFlowSpec(activity, this.projectKey, datasetsDAO);
        spec.tmpDir = tempDir.getAbsolutePath();
        for (AbstractCodeBasedActivityRunner.FlowSpec.SpecOutput out : spec.out) {
            out.appendMode = getter.isAppendMode(out.smartName);
        }
        return spec;
    }

    public static AbstractCodeBasedActivityRunner.FlowSpec buildBareFlowSpec() {
        AbstractCodeBasedActivityRunner.FlowSpec spec = new AbstractCodeBasedActivityRunner.FlowSpec();
        spec.tintercomAPIBase = "kernel/tintercom";
        spec.jekHost = ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.CAK ? DSSCAKernelMain.getKernelHost() : DSSJobKernelMain.getKernelHost();
        spec.jekPort = ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.CAK ? DSSCAKernelMain.getKernelPort() : DSSJobKernelMain.getKernelPort();
        spec.currentActivityId = JobContext.getCurrentActivity();
        return spec;
    }

    public static AbstractCodeBasedActivityRunner.FlowSpec buildNoAppendFlowSpec(JobActivity activity, String projectKey, DatasetsDAO datasetsDAO) throws IOException, SQLException {
        int i;
        List<Object> roleItems;
        RecipeRunnableSubgraph rrs;
        RunnableSubgraph subgraph = activity.getSubgraph();
        AbstractCodeBasedActivityRunner.FlowSpec spec = new AbstractCodeBasedActivityRunner.FlowSpec();
        spec.tintercomAPIBase = "kernel/tintercom";
        spec.jekHost = ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.CAK ? DSSCAKernelMain.getKernelHost() : DSSJobKernelMain.getKernelHost();
        spec.jekPort = ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.CAK ? DSSCAKernelMain.getKernelPort() : DSSJobKernelMain.getKernelPort();
        spec.currentActivityId = JobContext.getCurrentActivity();
        for (FlowComputable flowComputable : subgraph.getSources()) {
            AbstractCodeBasedActivityRunner.FlowSpec.SpecInput in = new AbstractCodeBasedActivityRunner.FlowSpec.SpecInput();
            in.smartName = AnyLoc.resolveFull(flowComputable.getFullId()).getSmartName(projectKey);
            in.fullName = flowComputable.getFullId();
            if (subgraph instanceof RecipeRunnableSubgraph) {
                rrs = (RecipeRunnableSubgraph)subgraph;
                block15: for (Map.Entry<String, SerializedRecipe.InputRole> entry : rrs.getRecipe().getModel().getInputsUnsafe().entrySet()) {
                    roleItems = entry.getValue().items;
                    for (i = 0; i < roleItems.size(); ++i) {
                        SerializedRecipe.RecipeInput ri = roleItems.get(i);
                        if (!ri.ref.equals(in.smartName)) continue;
                        in.role = entry.getKey();
                        in.indexInRole = i;
                        continue block15;
                    }
                }
            }
            in.type = flowComputable.getType();
            switch (flowComputable.getType()) {
                case DATASET: {
                    FlowComputable source = (FlowDataset)flowComputable;
                    Dataset sourceDS = ((FlowDataset)source).getMandatory(datasetsDAO);
                    if (!sourceDS.getPartitioningSchema().isPartitioned()) break;
                    in.partitions = new ArrayList<String>();
                    for (Partition p : subgraph.getSourcePartitions(source)) {
                        in.partitions.add(p.id());
                    }
                    break;
                }
                case SAVED_MODEL: {
                    in.modelLabel = ((FlowSavedModel)flowComputable).getSavedModel().name;
                    break;
                }
                case MANAGED_FOLDER: {
                    FlowComputable source = (FlowManagedFolder)flowComputable;
                    ManagedFolder sourceMF = ((FlowManagedFolder)source).getManagedFolder();
                    in.boxLabel = sourceMF.name;
                    if (!sourceMF.getPartitioningSchema().isPartitioned()) break;
                    in.partitions = new ArrayList<String>();
                    for (Partition p : subgraph.getSourcePartitions(source)) {
                        in.partitions.add(p.id());
                    }
                    break;
                }
                case STREAMING_ENDPOINT: {
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    FlowComputable source = (FlowModelEvaluationStore)flowComputable;
                    ModelEvaluationStore sourceMES = ((FlowModelEvaluationStore)source).getModelEvaluationStore();
                    in.boxLabel = sourceMES.name;
                    if (!sourceMES.getPartitioningSchema().isPartitioned()) break;
                    in.partitions = new ArrayList<String>();
                    for (Partition p : subgraph.getSourcePartitions(source)) {
                        in.partitions.add(p.id());
                    }
                    break;
                }
            }
            spec.in.add(in);
        }
        for (FlowComputable flowComputable : subgraph.getTargets()) {
            AbstractCodeBasedActivityRunner.FlowSpec.SpecOutput out = new AbstractCodeBasedActivityRunner.FlowSpec.SpecOutput();
            out.smartName = DatasetLocUtils.resolveFull(flowComputable.getFullId()).getSmartName(projectKey);
            out.fullName = flowComputable.getFullId();
            if (subgraph instanceof RecipeRunnableSubgraph) {
                rrs = (RecipeRunnableSubgraph)subgraph;
                block21: for (Map.Entry entry : rrs.getRecipe().getModel().getOutputsUnsafe().entrySet()) {
                    roleItems = ((SerializedRecipe.OutputRole)entry.getValue()).items;
                    for (i = 0; i < roleItems.size(); ++i) {
                        SerializedRecipe.RecipeOutput ro = (SerializedRecipe.RecipeOutput)roleItems.get(i);
                        if (!ro.ref.equals(out.smartName)) continue;
                        out.role = (String)entry.getKey();
                        out.indexInRole = i;
                        continue block21;
                    }
                }
            }
            out.type = flowComputable.getType();
            switch (flowComputable.getType()) {
                case DATASET: {
                    FlowComputable target = (FlowDataset)flowComputable;
                    Dataset targetDS = ((FlowDataset)target).getMandatory(datasetsDAO);
                    if (!targetDS.getPartitioningSchema().isPartitioned()) break;
                    out.partition = subgraph.getTargetPartition(target).id();
                    break;
                }
                case SAVED_MODEL: {
                    break;
                }
                case MANAGED_FOLDER: {
                    FlowComputable target = (FlowManagedFolder)flowComputable;
                    ManagedFolder targetMF = ((FlowManagedFolder)target).getManagedFolder();
                    out.boxLabel = targetMF.name;
                    if (!targetMF.getPartitioningSchema().isPartitioned()) break;
                    out.partition = subgraph.getTargetPartition(target).id();
                    break;
                }
                case STREAMING_ENDPOINT: {
                    break;
                }
                case MODEL_EVALUATION_STORE: {
                    FlowComputable target = (FlowModelEvaluationStore)flowComputable;
                    ModelEvaluationStore targetMES = ((FlowModelEvaluationStore)target).getModelEvaluationStore();
                    if (!targetMES.getPartitioningSchema().isPartitioned()) break;
                    out.partition = subgraph.getTargetPartition(target).id();
                }
            }
            spec.out.add(out);
        }
        spec.sortIOAccordingToRoles();
        return spec;
    }

    public static AbstractCodeBasedActivityRunner.FlowSpec buildNoAppendFlowSpec(ContinuousActivity activity) throws IOException, SQLException {
        int i;
        List<Object> roleItems;
        RecipesDAO recipesDAO = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        ComputableFromRefService cfrService = (ComputableFromRefService)SpringUtils.getBean(ComputableFromRefService.class);
        SerializedRecipe sr = (SerializedRecipe)recipesDAO.getMandatory(activity.projectKey, activity.recipeId);
        AbstractCodeBasedActivityRunner.FlowSpec spec = new AbstractCodeBasedActivityRunner.FlowSpec();
        spec.jekPort = DSSCAKernelMain.getKernelPort();
        spec.tintercomAPIBase = "cak/tintercom";
        for (Map.Entry<String, SerializedRecipe.InputRole> entry : sr.getInputsUnsafe().entrySet()) {
            roleItems = entry.getValue().items;
            for (i = 0; i < roleItems.size(); ++i) {
                SerializedRecipe.RecipeInput ri = roleItems.get(i);
                FlowComputable _source = cfrService.get(activity.projectKey, ri.ref);
                AbstractCodeBasedActivityRunner.FlowSpec.SpecInput in = new AbstractCodeBasedActivityRunner.FlowSpec.SpecInput();
                in.smartName = ri.ref;
                in.fullName = _source.getFullId();
                in.type = _source.getType();
                in.role = entry.getKey();
                in.indexInRole = i;
                switch (_source.getType()) {
                    case DATASET: {
                        FlowComputable source = (FlowDataset)_source;
                        Dataset sourceDS = ((FlowDataset)source).getMandatory(datasetsDAO);
                        if (!sourceDS.getPartitioningSchema().isPartitioned()) break;
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        break;
                    }
                    case RETRIEVABLE_KNOWLEDGE: {
                        break;
                    }
                    case SAVED_MODEL: {
                        in.modelLabel = ((FlowSavedModel)_source).getSavedModel().name;
                        break;
                    }
                    case MANAGED_FOLDER: {
                        FlowComputable source = (FlowManagedFolder)_source;
                        ManagedFolder sourceMF = ((FlowManagedFolder)source).getManagedFolder();
                        in.boxLabel = sourceMF.name;
                        if (!sourceMF.getPartitioningSchema().isPartitioned()) break;
                        break;
                    }
                    case MODEL_EVALUATION_STORE: {
                        FlowComputable source = (FlowModelEvaluationStore)_source;
                        ModelEvaluationStore sourceMES = ((FlowModelEvaluationStore)source).getModelEvaluationStore();
                        in.boxLabel = sourceMES.name;
                        if (!sourceMES.getPartitioningSchema().isPartitioned()) break;
                        break;
                    }
                }
                spec.in.add(in);
            }
        }
        for (Map.Entry<String, Object> entry : sr.getOutputsUnsafe().entrySet()) {
            roleItems = ((SerializedRecipe.OutputRole)entry.getValue()).items;
            for (i = 0; i < roleItems.size(); ++i) {
                SerializedRecipe.RecipeOutput ro = (SerializedRecipe.RecipeOutput)roleItems.get(i);
                FlowComputable _target = cfrService.get(activity.projectKey, ro.ref);
                AbstractCodeBasedActivityRunner.FlowSpec.SpecOutput out = new AbstractCodeBasedActivityRunner.FlowSpec.SpecOutput();
                out.smartName = DatasetLocUtils.resolveFull(_target.getFullId()).getSmartName(activity.projectKey);
                out.fullName = _target.getFullId();
                out.type = _target.getType();
                out.role = entry.getKey();
                out.indexInRole = i;
                switch (_target.getType()) {
                    case DATASET: {
                        break;
                    }
                    case STREAMING_ENDPOINT: {
                        break;
                    }
                    case SAVED_MODEL: {
                        break;
                    }
                    case MANAGED_FOLDER: {
                        FlowManagedFolder target = (FlowManagedFolder)_target;
                        ManagedFolder targetMF = target.getManagedFolder();
                        out.boxLabel = targetMF.name;
                        break;
                    }
                }
                spec.out.add(out);
            }
        }
        spec.sortIOAccordingToRoles();
        return spec;
    }

    static {
        forcedSchemaMap = new HashMap<String, Schema>();
        logger = DKULogger.getLogger((String)"dku.remoterun.env");
    }

    public static interface AppendModeGetter {
        public boolean isAppendMode(String var1);
    }
}

