/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.Assertions;
import java.util.List;

public class FSSubgraphHelper {
    public static FilePartitioner.ResolvedFilesFilterResult getInputFiles(AuthCtx authCtx, List<Partition> inputPartitions, Dataset inputDS) throws Exception {
        try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, inputDS);){
            FilePartitioner.ResolvedFilesFilterResult resolvedFilesFilterResult = FSSubgraphHelper.getInputFiles(inputPartitions, dh);
            return resolvedFilesFilterResult;
        }
    }

    public static FilePartitioner.ResolvedFilesFilterResult getInputFiles(List<Partition> inputPartitions, DatasetHandler dh) throws Exception {
        Assertions.assertInstanceof((Object)dh, AbstractFSDatasetHandler.class);
        AbstractFSDatasetHandler fid = (AbstractFSDatasetHandler)dh;
        InputFilter filter = new InputFilter().withSelectedPartitions(inputPartitions);
        assert (filter.getPartitionsClause() != null);
        FilePartitioner.ResolvedFilesFilterResult ret = fid.getRequiredFiles(filter);
        assert (ret != null);
        return ret;
    }
}

