/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGroupByQueryGenerator;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureJoinQueryGenerator;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.EntityQueryGenerator;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureContainer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureUtils;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.QueryVisitor;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import java.util.List;
import java.util.Map;

public class FeatureQueryVisitor
extends QueryVisitor {
    private final Dataset targetDataset;

    public FeatureQueryVisitor(AutoFeatureGenerationRecipePayloadParams params, SQLDialect dialect, Map<Integer, String> viewNameByDataset, Map<String, Dataset> datasetsMap, Map<String, SQLUtils.SQLTable> sqlTablesMap, Dataset targetDataset) {
        super(params, dialect, viewNameByDataset, datasetsMap, sqlTablesMap);
        this.targetDataset = targetDataset;
    }

    @Override
    public void visit(RelationshipGraph.Node node) {
        List<FeatureContainer> entityFeatures = FeatureUtils.getEntityFeatures(node, this.params, this.identifierMaxLength);
        EntityQueryGenerator entityQueryGenerator = new EntityQueryGenerator(this.datasetsMap, this.sqlTablesMap, this.dialect, this.viewNameByDataset, this.targetDataset);
        String entityFeaturesQuery = entityQueryGenerator.generateQuery(node, entityFeatures);
        node.addComputedColumns(FeatureUtils.convertToColumns(entityFeatures));
        if (node.isRoot()) {
            this.selectQuery = entityFeaturesQuery;
        } else {
            String entityViewName = SQLUtils.generateSqlViewName(node.getDatasetSanitizedLabel(), Partition.newNP(), this.dialect);
            this.generateSqlViewQueries(entityViewName, entityFeaturesQuery);
            this.registerNewSQLView(node, entityViewName);
        }
    }

    @Override
    public void visit(RelationshipGraph.ForwardEdge edge) {
        List<FeatureContainer> forwardFeatures = FeatureUtils.getForwardFeatures(edge, this.params, this.identifierMaxLength);
        AutoFeatureJoinQueryGenerator joinQueryGenerator = new AutoFeatureJoinQueryGenerator(this.datasetsMap, this.sqlTablesMap, this.dialect, this.viewNameByDataset);
        String joinQuery = joinQueryGenerator.generateQuery(edge, forwardFeatures);
        String joinViewName = SQLUtils.generateSqlViewName(edge.getCurrentNodeSanitizedLabel(), Partition.newNP(), this.dialect);
        this.generateSqlViewQueries(joinViewName, joinQuery);
        edge.addColumnsToCurrentNode(FeatureUtils.convertToColumns(forwardFeatures));
        this.registerNewSQLView(edge.getCurrentNode(), joinViewName);
    }

    @Override
    public void visit(RelationshipGraph.BackwardEdge edge) {
        String groupingDatasetName = this.viewNameByDataset.getOrDefault(edge.relatedNode, edge.getRelatedNodeName());
        Dataset groupingDataset = (Dataset)this.datasetsMap.get(groupingDatasetName);
        List<FeatureContainer> backwardFeatures = FeatureUtils.getBackwardFeatures(edge, this.params, this.identifierMaxLength, groupingDataset.getSchema());
        AutoFeatureGroupByQueryGenerator groupByQueryGenerator = new AutoFeatureGroupByQueryGenerator(this.datasetsMap, this.sqlTablesMap, this.viewNameByDataset, this.dialect, this.identifierMaxLength);
        GroupingRecipePayloadParams groupParams = AutoFeatureGroupByQueryGenerator.generateParams(edge, this.params);
        String groupQuery = groupByQueryGenerator.generateQuery(edge, groupParams);
        String groupViewName = SQLUtils.generateSqlViewName(edge.getRelatedNodeSanitizedLabel(), Partition.newNP(), this.dialect);
        this.generateSqlViewQueries(groupViewName, groupQuery);
        Dataset groupedDataset = AutoFeatureGroupByQueryGenerator.createGroupByDataset(groupParams.getRawGroupingKeys(), backwardFeatures);
        this.addViewToSources(groupViewName, groupedDataset);
        this.addViewToSqlTables(groupViewName);
        AutoFeatureJoinQueryGenerator joinUtils = new AutoFeatureJoinQueryGenerator(this.datasetsMap, this.sqlTablesMap, this.dialect, this.viewNameByDataset);
        String joinQuery = joinUtils.generateQuery(edge, groupViewName, backwardFeatures);
        String joinViewName = SQLUtils.generateSqlViewName(edge.getCurrentNodeSanitizedLabel(), Partition.newNP(), this.dialect);
        this.generateSqlViewQueries(joinViewName, joinQuery);
        edge.addColumnsToCurrentNode(FeatureUtils.convertToColumns(backwardFeatures));
        this.registerNewSQLView(edge.getCurrentNode(), joinViewName);
    }
}

