/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.grouping;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.AbstractStagedThreadedBuiltinRunner;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.grouping.Grouper2;
import com.dataiku.dip.dataflow.exec.grouping.GroupingRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.shaker.processors.transform.ColumnRenamer;
import com.dataiku.dip.shaker.processors.transform.FindReplace;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class GroupingRecipeBuiltinRunner
extends AbstractStagedThreadedBuiltinRunner {
    private GroupingRecipePayloadParams params;

    public GroupingRecipeBuiltinRunner(JobActivity activity, GroupingRecipePayloadParams params) {
        super(activity);
        this.params = params;
    }

    @Override
    public List<AbstractInitializedRunner.Output> prepareStages(File tempDirectory) throws Exception {
        assert (this.inputs.containsKey("main"));
        assert (!((List)this.inputs.get("main")).isEmpty());
        assert (this.outputs.containsKey("main"));
        assert (!((List)this.outputs.get("main")).isEmpty());
        AbstractInitializedRunner.Input input = (AbstractInitializedRunner.Input)((List)this.inputs.get("main")).get(0);
        AbstractInitializedRunner.Output output = (AbstractInitializedRunner.Output)((List)this.outputs.get("main")).get(0);
        FlowDataset inputFD = this.activity.getSubgraph().getSingleTargetDataset();
        Dataset inputDS = inputFD.getMandatory(this.datasetsDAO);
        OracleSQLDialect dialect = inputDS.getType().equals(BuiltinSQLDatasets.ORACLE_META.getType()) ? new OracleSQLDialect(this.authCtxService.getAuthCtx(), inputDS) : null;
        GrelExpression preFilterExpression = FilterDescUtils.willFilter(this.params.preFilter) ? FilterDescUtils.getGrelFilterExpression(this.params.preFilter) : null;
        GrelExpression postFilterExpression = FilterDescUtils.willFilter(this.params.postFilter) ? FilterDescUtils.getGrelFilterExpression(this.params.postFilter) : null;
        if (this.params.preFilter != null && this.params.preFilter.distinct) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(input.schema, new File(tempDirectory, "prefilter")));
        }
        if (preFilterExpression != null) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.FilteringThread(preFilterExpression));
        }
        Schema schemaAfterComputedCols = new Schema(input.schema);
        if (this.params.computedColumns != null && !this.params.computedColumns.isEmpty()) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.ComputedColumnsThread(this.params.computedColumns));
            for (ComputedColumn cc : this.params.computedColumns) {
                schemaAfterComputedCols.addColumn(cc.name, Type.forName((String)cc.type));
            }
        }
        Schema computedOutputSchema = schemaAfterComputedCols;
        Grouper2 grouper = new Grouper2(this.params.getResolvedGroupingKeys(input.schema), this.params.values, this.params.globalCount ? "count" : null, new File(tempDirectory, "grouper"), this.mergeSortParams, dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()));
        this.stages.add(new AbstractStagedThreadedBuiltinRunner.GrouperThread(grouper, computedOutputSchema));
        computedOutputSchema = grouper.getOutputSchema(computedOutputSchema);
        if (postFilterExpression != null) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.FilteringThread(postFilterExpression));
        }
        if (this.params.postFilter != null && this.params.postFilter.distinct) {
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.KeepDistinctRowsThread(computedOutputSchema, new File(tempDirectory, "postfilter")));
        }
        if (this.params.outputColumnNameOverrides != null && !this.params.outputColumnNameOverrides.keySet().isEmpty()) {
            ColumnRenamer.Parameter rp = new ColumnRenamer.Parameter();
            for (String from : this.params.outputColumnNameOverrides.keySet()) {
                String to = this.params.outputColumnNameOverrides.get(from);
                if (!StringUtils.isNotBlank((String)from) || !StringUtils.isNotBlank((String)to)) continue;
                rp.renamings.add(new FindReplace.Substitution(from, to));
            }
            ColumnRenamer columnRenamer = new ColumnRenamer(rp);
            columnRenamer.setColumnFactory((ColumnFactory)output.cf);
            columnRenamer.init();
            this.stages.add(new AbstractStagedThreadedBuiltinRunner.RenamingThread(columnRenamer, computedOutputSchema));
        }
        return Lists.newArrayList((Object[])new AbstractInitializedRunner.Output[]{output});
    }
}

