/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.joinlike;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.filter.GrelExpression;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.LevenshteinMatcher;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnSuggestion;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnSuggestionWithDistance;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class JoinLikeRecipeUtils {
    public static void checkJoinColumns(int virtualInputIndex, List<? extends JoinDescBase<?>> joins, InputReplacementTestResult ret, Schema newSchema) {
        for (JoinDescBase<?> join : joins) {
            if (join.table2 == virtualInputIndex) {
                for (MatchingConditionBase cond : join.getJoinConditions()) {
                    if (newSchema.getColumn(cond.column2.name) != null) continue;
                    ret.warn("Dataset has no column '" + cond.column2.name + "' (used in join condition)");
                }
            }
            if (join.table1 != virtualInputIndex) continue;
            for (MatchingConditionBase cond : join.getJoinConditions()) {
                if (newSchema.getColumn(cond.column1.name) != null) continue;
                ret.warn("Dataset has no column '" + cond.column1.name + "' (used in join condition)");
            }
        }
    }

    public static boolean sameType(SchemaColumn col1, SchemaColumn col2, boolean strictTypeEquality) {
        if (col1 == null || col2 == null) {
            return false;
        }
        if (strictTypeEquality) {
            return col1.getType() == col2.getType();
        }
        return col1.getType().isInteger() && col2.getType().isInteger() || col1.getType().isFloatingPoint() && col2.getType().isFloatingPoint();
    }

    public static void checkSelectedColumns(int virtualInputIndex, List<ColumnDesc> selectedColumns, InputReplacementTestResult ret, Schema newSchema) {
        if (selectedColumns != null) {
            for (ColumnDesc col : selectedColumns) {
                if (col.table != virtualInputIndex || newSchema.getColumn(col.name) != null) continue;
                ret.warn("Dataset has no column '" + col.name + "' (selected for output)");
            }
        }
    }

    public static void checkPreFilterDescUtil(InputReplacementTestResult ret, Schema newSchema, FilterDesc preFilter) throws Exception {
        if (FilterDescUtils.willFilter(preFilter)) {
            List<String> vars = GrelExpression.build(JoinLikeRecipeUtils.createGrelFilterExpression(preFilter)).getVariables();
            for (String var : vars) {
                if (newSchema.getColumn(var) != null) continue;
                ret.warn("Dataset has no column '" + var + "' (used in pre-filter)");
            }
        }
    }

    private static GrelExpression createGrelFilterExpression(FilterDesc preFilter) throws Exception {
        if (preFilter.uiData != null && "SQL".equals(preFilter.uiData.mode)) {
            return new GrelExpression(FilterDescUtils.getSQLExpression(preFilter), preFilter.expressionVariablesContext);
        }
        return FilterDescUtils.getGrelFilterExpression(preFilter);
    }

    public static boolean checkSchemaEmptiness(Schema schema) {
        return schema == null || schema.getColumns().size() == 0;
    }

    public static class InputReplacementTestResult {
        private HashSet<String> warningMessages;

        public void warn(String msg) {
            if (this.warningMessages == null) {
                this.warningMessages = new HashSet();
            }
            this.warningMessages.add(msg);
        }
    }

    public static abstract class JoinConditionsSuggester<M extends MatchingConditionBase, J extends JoinDescBase<M>> {
        public List<M> computeSuggestions(J join, Schema schema1, Schema schema2) {
            double joinConditionMatchThreshold = 0.4;
            ArrayList suggestions = new ArrayList();
            List<ColumnSuggestionWithDistance<M>> columnPairs = this.buildColumnSuggestionsWithDistance(schema1, schema2);
            for (ColumnSuggestionWithDistance<M> candidate : columnPairs) {
                if (suggestions.size() >= 5) break;
                if (!(candidate.distance < joinConditionMatchThreshold)) continue;
                this.addSuggestion(join, suggestions, candidate);
            }
            if (suggestions.isEmpty() && !columnPairs.isEmpty()) {
                this.addSuggestion(join, suggestions, columnPairs.get(0));
            }
            return suggestions;
        }

        private void addSuggestion(J join, List<M> suggestions, ColumnSuggestionWithDistance<M> candidate) {
            SchemaColumn c1 = candidate.suggestion.leftCol;
            SchemaColumn c2 = candidate.suggestion.rightCol;
            ColumnDesc cd1 = new ColumnDesc(((JoinDescBase)join).table1, c1.getName());
            ColumnDesc cd2 = new ColumnDesc(((JoinDescBase)join).table2, c2.getName());
            Optional suggestedMatchDesc = candidate.suggestedMatchDesc;
            if (suggestedMatchDesc.isPresent()) {
                MatchingConditionBase suggestion = (MatchingConditionBase)suggestedMatchDesc.get();
                suggestion.column1 = cd1;
                suggestion.column2 = cd2;
                suggestions.add(suggestion);
            }
        }

        protected List<ColumnSuggestionWithDistance<M>> buildColumnSuggestionsWithDistance(Schema schema1, Schema schema2) {
            LevenshteinMatcher levenshteinMatcher = new LevenshteinMatcher(0.0, null, true);
            ArrayList<ColumnSuggestionWithDistance<M>> pairs = new ArrayList<ColumnSuggestionWithDistance<M>>();
            schema1.columns.stream().filter(this::isJoinableColumn).forEach(c1 -> schema2.getColumns().stream().filter(this::isJoinableColumn).forEach(c2 -> {
                double distance = levenshteinMatcher.computeMatch((String)c1.getName(), (String)c2.getName()).distance;
                Optional<M> suggestedMatchDesc = this.suggestedMatchDesc((SchemaColumn)c1, (SchemaColumn)c2);
                pairs.add(new ColumnSuggestionWithDistance<M>(distance /= (double)Math.max(c1.getName().length(), c2.getName().length()), new ColumnSuggestion((SchemaColumn)c1, (SchemaColumn)c2), suggestedMatchDesc));
            }));
            pairs.sort(Comparator.comparingDouble(o -> o.distance));
            return pairs;
        }

        protected boolean isJoinableColumn(SchemaColumn schemaColumn) {
            return true;
        }

        protected abstract Optional<M> suggestedMatchDesc(SchemaColumn var1, SchemaColumn var2);
    }
}

