/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.listaccess;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.listaccess.ListAccessRecipeExecutor;
import com.dataiku.dip.dataflow.exec.listaccess.ListAccessRecipeParams;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.SharePointOnlineFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonArray;
import com.dataiku.dss.shadelibazure.com.google.gson.JsonElement;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.content.BatchResponseContent;
import com.dataiku.dss.shadelibazure.com.microsoft.graph.content.BatchResponseStep;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ListAccessRecipeStreamExecutor
implements ListAccessRecipeExecutor {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private final JobActivity activity;
    private final StreamColumnFactory cf = new StreamColumnFactory();
    private final StreamRowFactory rf = new StreamRowFactory();
    private final AuthCtx authCtx;
    private final ListAccessRecipeParams params;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipe.executor.stream.list_access");

    public ListAccessRecipeStreamExecutor(AuthCtx authCtx, JobActivity activity, ListAccessRecipeParams params) {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.activity = activity;
        this.params = params;
    }

    @Override
    public void run() throws Exception {
        RunnableSubgraph subgraph = this.activity.getSubgraph();
        FlowRecipe recipe = ((RecipeRunnableSubgraph)subgraph).getRecipe();
        FlowManagedFolder flowManagedFolder = this.getFlowManagedFolder(subgraph);
        ManagedFolder managedFolder = flowManagedFolder.getManagedFolder();
        if (!"SharePointOnline".equals(managedFolder.getType())) {
            throw new IllegalStateException("List Access recipe accepts only a folder of type SharePoint as the input");
        }
        try (ManagedFolderHandler inputHandler = (ManagedFolderHandler)managedFolder.buildHandler(this.authCtx);){
            if (inputHandler.getProvider() instanceof SharePointOnlineFSProvider) {
                ProcessorOutput out = this.getProcessorOutput(subgraph, recipe);
                List<Partition> sourcePartitions = subgraph.getSourcePartitions(flowManagedFolder);
                for (Partition sourcePartition : sourcePartitions) {
                    logger.info((Object)"Retrieving file paths");
                    ManagedFolderHandler.ManagedFolderListing sourceFiles = inputHandler.listFS(sourcePartition, true, false);
                    logger.info((Object)"Retrieving file permissions related to groups");
                    Map<String, Set<PermissionResponse>> fileToPermissionMap = this.getFileToPermissionMap(inputHandler, sourceFiles);
                    Set<String> allEntraGroupIds = fileToPermissionMap.values().stream().flatMap(Collection::stream).filter(e -> e.isSuccess).map(e -> e.groupId).collect(Collectors.toSet());
                    logger.info((Object)"Retrieving group details");
                    Map<String, GroupDetailResponse> entraGroupIdToDetailMap = this.getEntraGroupIdToDetailMap(inputHandler, allEntraGroupIds);
                    InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                    logger.info((Object)"Retrieving manual mapping data");
                    Map<String, List<String>> manualMapping = this.getManualMapping(recipe, subgraph, messages);
                    Map<String, List<String>> entraToDSSGroupMap = this.getEntraToDssGroupMap(manualMapping, messages);
                    if (messages.anyMessage) {
                        this.activity.warnContext.addWarning(WarningsContext.WarningType.INPUT_DATA_BAD_DATA, messages.report("\n"), logger);
                    }
                    this.emitRows(fileToPermissionMap, entraToDSSGroupMap, entraGroupIdToDetailMap, out);
                }
                out.lastRowEmitted();
            }
        }
    }

    @VisibleForTesting
    Map<String, Set<PermissionResponse>> getFileToPermissionMap(ManagedFolderHandler inputHandler, ManagedFolderHandler.ManagedFolderListing sourceFiles) throws IOException, DKUSecurityException, CodedException {
        SharePointOnlineFSProvider provider = (SharePointOnlineFSProvider)inputHandler.getProvider();
        if (provider == null) {
            throw new IllegalStateException("The provider of the folder needs to be of SharePoint type");
        }
        List<String> relativeItemPaths = sourceFiles.items.stream().filter(a -> a != null && a.path != null).map(a -> a.path).toList();
        HashMap<String, String> requestIdToFileMap = new HashMap<String, String>();
        Map<String, String> accessInfo = inputHandler.getAccessInfo(false);
        List<BatchResponseContent> batchResponses = this.getSharepointOnlineClient(inputHandler).getPermissionForFiles(accessInfo.get("siteId"), accessInfo.get("driveId"), provider, relativeItemPaths, requestIdToFileMap);
        HashMap<String, Set<PermissionResponse>> fileToPermissionMap = new HashMap<String, Set<PermissionResponse>>();
        for (BatchResponseContent batchResponse : batchResponses) {
            for (BatchResponseStep response : batchResponse.responses) {
                if (response == null) continue;
                try {
                    JsonElement deserializedBody = (JsonElement)response.getDeserializedBody(JsonElement.class);
                    JsonArray entraGroups = deserializedBody.getAsJsonObject().getAsJsonArray("value");
                    if (entraGroups != null) {
                        for (JsonElement entraGroup : entraGroups) {
                            Optional.ofNullable(entraGroup.getAsJsonObject()).map(e -> e.getAsJsonObject("grantedToV2")).map(e -> e.getAsJsonObject("group")).map(e -> e.get("id").getAsString()).ifPresent(e -> fileToPermissionMap.computeIfAbsent((String)requestIdToFileMap.get(response.id), key -> new HashSet()).add(new PermissionResponse(true, (String)e, null)));
                        }
                        continue;
                    }
                    logger.warn((Object)String.join((CharSequence)" ", "File permission response doesn't have the right structure: ", deserializedBody.toString()));
                    fileToPermissionMap.computeIfAbsent((String)requestIdToFileMap.get(response.id), key -> new HashSet()).add(new PermissionResponse(false, null, deserializedBody.toString()));
                }
                catch (Exception e2) {
                    logger.warn((Object)"File permission response isn't properly formatted as JSON", (Throwable)e2);
                    fileToPermissionMap.computeIfAbsent((String)requestIdToFileMap.get(response.id), key -> new HashSet()).add(new PermissionResponse(false, null, String.valueOf(response.body)));
                }
            }
        }
        return fileToPermissionMap;
    }

    @VisibleForTesting
    Map<String, GroupDetailResponse> getEntraGroupIdToDetailMap(ManagedFolderHandler inputHandler, Set<String> entraGroupIds) throws IOException, DKUSecurityException {
        SharePointOnlineConnection.SharePointOnlineClient sharepointOnlineClient = this.getSharepointOnlineClient(inputHandler);
        HashMap<String, String> requestIdToGroupIdMap = new HashMap<String, String>();
        List<BatchResponseContent> batchResponses = sharepointOnlineClient.getGroups(entraGroupIds, requestIdToGroupIdMap);
        HashMap<String, GroupDetailResponse> entraGroupIdToDetailMap = new HashMap<String, GroupDetailResponse>();
        for (BatchResponseContent batchResponse : batchResponses) {
            for (BatchResponseStep response : batchResponse.responses) {
                if (response == null) continue;
                if (response.status >= 400) {
                    entraGroupIdToDetailMap.put((String)requestIdToGroupIdMap.get(response.id), new GroupDetailResponse(false, "", ((JsonElement)response.body).toString()));
                    continue;
                }
                try {
                    JsonElement deserializedBody = (JsonElement)response.getDeserializedBody(JsonElement.class);
                    Optional.ofNullable(deserializedBody.getAsJsonObject()).map(e -> e.get("displayName").getAsString()).ifPresent(e -> entraGroupIdToDetailMap.put((String)requestIdToGroupIdMap.get(response.id), new GroupDetailResponse(true, (String)e, "")));
                }
                catch (Exception e2) {
                    logger.warn((Object)"Group details response isn't properly formatted as JSON", (Throwable)e2);
                    String fullErrorMessage = String.join((CharSequence)"\n", e2.getMessage(), String.join((CharSequence)" ", "Response body:", String.valueOf(response.body)));
                    entraGroupIdToDetailMap.put((String)requestIdToGroupIdMap.get(response.id), new GroupDetailResponse(false, "", fullErrorMessage));
                }
            }
        }
        return entraGroupIdToDetailMap;
    }

    @VisibleForTesting
    Map<String, List<String>> getManualMapping(FlowRecipe recipe, RunnableSubgraph subgraph, InfoMessage.InfoMessages messages) throws Exception {
        if (recipe.getPredecessors().size() != 2 || recipe.getPredecessors().get(1) == null || StringUtils.isEmpty((String)this.params.manualMappingDssGroupCol) || StringUtils.isEmpty((String)this.params.manualMappingEntraGroupCol)) {
            return Map.of();
        }
        Dataset inputDataset = subgraph.getSingleSourceDataset().getMandatory(this.datasetsDAO);
        SchemaColumn dssGroupsColumn = inputDataset.getSchema().getColumn(this.params.manualMappingDssGroupCol);
        SchemaColumn entraGroupsColumn = inputDataset.getSchema().getColumn(this.params.manualMappingEntraGroupCol);
        if (dssGroupsColumn == null) {
            throw new IllegalArgumentException("The specified DSS group column wasn't found in the dataset schema");
        }
        if (entraGroupsColumn == null) {
            throw new IllegalArgumentException("The specified Entra groups column wasn't found in the dataset schema");
        }
        Map<String, String> manualMappingData = this.getManualMappingData(inputDataset, dssGroupsColumn, entraGroupsColumn, messages, subgraph);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> rowValues : manualMappingData.entrySet()) {
            List<String> entraGroupList = this.extractGroupList(rowValues.getValue());
            result.computeIfAbsent(rowValues.getKey(), key -> new ArrayList()).addAll(entraGroupList);
        }
        return result;
    }

    private Map<String, String> getManualMappingData(Dataset inputDataset, final SchemaColumn dssGroupsColumn, final SchemaColumn entraGroupsColumn, final InfoMessage.InfoMessages messages, RunnableSubgraph subgraph) throws Exception {
        final HashMap<String, String> manualMappingData = new HashMap<String, String>();
        try (DatasetHandler inputHandler = (DatasetHandler)inputDataset.buildHandler(this.authCtx);){
            UniversalSingleThreadPusher threadPush = new UniversalSingleThreadPusher(this.authCtx, inputDataset, new ProcessorOutput(){

                public void setMaxMemoryUsed(long size) {
                }

                public void lastRowEmitted() {
                }

                public void emitRow(Row row) {
                    String dssGroupValue = row.get((Column)ListAccessRecipeStreamExecutor.this.cf.getColumn(dssGroupsColumn.getName()));
                    String entraGroupsValue = row.get((Column)ListAccessRecipeStreamExecutor.this.cf.getColumn(entraGroupsColumn.getName()));
                    if (dssGroupValue == null) {
                        if (entraGroupsValue == null) {
                            messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_LIST_ACCESS_MANUAL_MAPPING_EMPTY_VALUES, (String)"Empty DSS and Entra group values were found on the same row"));
                        } else {
                            messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_LIST_ACCESS_MANUAL_MAPPING_EMPTY_DSS_GROUP, (String)("Empty DSS group value for the associated Entra groups: " + entraGroupsValue)));
                        }
                    } else if (entraGroupsValue == null) {
                        messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_LIST_ACCESS_MANUAL_MAPPING_EMPTY_ENTRA_GROUP, (String)("Empty Entra groups value for the associated DSS group: " + dssGroupValue)));
                    } else {
                        manualMappingData.put(dssGroupValue, entraGroupsValue);
                    }
                }

                public void cancel() {
                }
            }, (ColumnFactory)this.cf, (RowFactory)this.rf, true);
            StreamableDatasetSelection full = StreamableDatasetSelection.full();
            if (inputDataset.getPartitioningSchema().isPartitioned()) {
                full.withSelectedPartitions(subgraph.getSourcePartitions(subgraph.getSingleSourceDataset()));
            }
            threadPush.setDatasetSelection(full);
            threadPush.push();
        }
        return manualMappingData;
    }

    private List<String> extractGroupList(String entraGroups) {
        if (entraGroups == null) {
            throw new IllegalArgumentException("Entra group list cannot be null");
        }
        Gson gson = new Gson();
        Type listType = new TypeToken<List<String>>(){}.getType();
        try {
            List entraGroupsList = (List)gson.fromJson(entraGroups, listType);
            if (entraGroupsList == null) {
                throw new IllegalArgumentException("Entra group list cannot be null");
            }
            return entraGroupsList;
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The Entra groups column must contain a list of values, for instance [\"Entra group 1\", \"Entra group 2\"]", e);
        }
    }

    private FlowManagedFolder getFlowManagedFolder(RunnableSubgraph subgraph) {
        List<? extends FlowComputable> sources = subgraph.getSources();
        if (sources.isEmpty()) {
            throw new IllegalStateException("Recipe graph can't be empty");
        }
        FlowManagedFolder flowManagedFolder = (FlowManagedFolder)sources.get(0);
        if (flowManagedFolder == null) {
            throw new IllegalStateException("Flow managed folder can't be null");
        }
        return flowManagedFolder;
    }

    private SharePointOnlineConnection.SharePointOnlineClient getSharepointOnlineClient(ManagedFolderHandler managedFolderHandler) throws IOException, DKUSecurityException {
        AbstractFSDatasetHandler.AbstractFSConfig resolvedConfig = managedFolderHandler.getResolvedConfig();
        SharePointOnlineConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, resolvedConfig.connection, SharePointOnlineConnection.class);
        ProxySettings proxySettings = connection.getProxySettings();
        return connection.getSharePointOnlineClient(this.authCtx, proxySettings);
    }

    private ProcessorOutput getProcessorOutput(RunnableSubgraph subgraph, FlowRecipe recipe) throws Exception {
        FlowDataset outputFD = subgraph.getTargetsDatasets().get(0);
        Dataset outputDS = outputFD.getMandatory(this.datasetsDAO);
        Partition targetPartition = subgraph.getTargetPartition(outputFD);
        SerializedRecipe.RecipeOutput recipeOutput = recipe.getModel().getSingleOutput("main");
        Output.WriteMode writeMode = recipeOutput.getWriteMode();
        try (DatasetHandler outputDatasetHandler = DatasetHandlerFactory.build(this.authCtx, outputDS);){
            if (writeMode == Output.WriteMode.OVERWRITE && !outputDatasetHandler.outputHandlesClear()) {
                if (outputDatasetHandler.getMeta().isFSLike()) {
                    outputDatasetHandler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                }
                writeMode = Output.WriteMode.APPEND;
            }
        }
        WarningsContext warnContext = this.activity.warnContext;
        ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing(this.authCtx, outputDS, targetPartition, (ColumnFactory)this.cf, warnContext, writeMode);
        return streamer.getAsOutput();
    }

    private Map<String, List<String>> getEntraToDssGroupMap(Map<String, List<String>> manualMapping, InfoMessage.InfoMessages messages) throws IOException {
        HashMap<String, List<String>> entraToDSSGroupMap = new HashMap<String, List<String>>();
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafeAutoTXN();
        Set<Object> dssGroupsFoundInManualMapping = new HashSet();
        boolean dssGroupsRead = false;
        if (generalSettings != null && generalSettings.azureADSettings != null && generalSettings.azureADSettings.isEnabled() && (generalSettings.azureADSettings.azureADGroupsRetrievableBy == AzureADSettings.AzureADGroupsRetrievableBy.EVERYBODY || this.authCtx.isAdmin())) {
            List<UsersDAO.Group> allGroups;
            try (Transaction t = this.transactionService.retrieveOrBeginRead();){
                allGroups = this.usersDAO.listGroups();
                dssGroupsRead = true;
            }
            List<UsersDAO.Group> azureADGroups = allGroups.stream().filter(g -> g.sourceType == UserSourceType.AZURE_AD).toList();
            for (UsersDAO.Group dssGroup : azureADGroups) {
                if (manualMapping.containsKey(dssGroup.name)) continue;
                for (String entraGroup : dssGroup.azureADGroupNames) {
                    entraToDSSGroupMap.computeIfAbsent(entraGroup, key -> new LinkedList()).add(dssGroup.name);
                }
            }
            dssGroupsFoundInManualMapping = allGroups.stream().filter(g -> manualMapping.containsKey(g.name)).map(g -> g.name).collect(Collectors.toSet());
        }
        ArrayList<String> misspelledDssGroups = new ArrayList<String>();
        for (Map.Entry<String, List<String>> dssGroupManualMapping : manualMapping.entrySet()) {
            if (dssGroupsRead && !dssGroupsFoundInManualMapping.contains(dssGroupManualMapping.getKey())) {
                misspelledDssGroups.add(dssGroupManualMapping.getKey());
            }
            for (String entraGroup : dssGroupManualMapping.getValue()) {
                entraToDSSGroupMap.computeIfAbsent(entraGroup, key -> new LinkedList()).add(dssGroupManualMapping.getKey());
            }
        }
        if (dssGroupsRead && !misspelledDssGroups.isEmpty()) {
            String groupsForMessage = String.join((CharSequence)", ", misspelledDssGroups);
            messages.addMessage(InfoMessage.warning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_LIST_ACCESS_MANUAL_MAPPING_BAD_DSS_GROUP, (String)("The following DSS group(s) specified in the manual mapping couldn't be found in DSS: " + groupsForMessage)));
        }
        return entraToDSSGroupMap;
    }

    private void emitRows(Map<String, Set<PermissionResponse>> fileToPermissionMap, Map<String, List<String>> entraGroupDssGroupMap, Map<String, GroupDetailResponse> entraGroupIdDetailMap, ProcessorOutput out) throws Exception {
        for (Map.Entry<String, Set<PermissionResponse>> filePathToGroupIds : fileToPermissionMap.entrySet()) {
            HashSet<String> entraGroupNames = new HashSet<String>();
            HashSet<String> dssGroupNames = new HashSet<String>();
            HashSet<String> errorDetails = new HashSet<String>();
            for (PermissionResponse permission : filePathToGroupIds.getValue()) {
                if (permission == null) continue;
                if (permission.isSuccess) {
                    GroupDetailResponse entraGroupDetailResponse = entraGroupIdDetailMap.get(permission.groupId);
                    if (entraGroupDetailResponse == null) {
                        logger.warn((Object)("Entra group detail is null for the entra group ID: " + String.valueOf(permission)));
                        continue;
                    }
                    if (entraGroupDetailResponse.isSuccess) {
                        entraGroupNames.add(entraGroupDetailResponse.name);
                        if (!entraGroupDssGroupMap.containsKey(entraGroupDetailResponse.name)) continue;
                        List<String> prefixedDssGroups = entraGroupDssGroupMap.get(entraGroupDetailResponse.name).stream().map(e -> "dss_group:" + e).toList();
                        dssGroupNames.addAll(prefixedDssGroups);
                        continue;
                    }
                    errorDetails.add(entraGroupDetailResponse.error);
                    continue;
                }
                errorDetails.add(permission.error);
            }
            this.emitRow(out, filePathToGroupIds.getKey(), entraGroupNames, dssGroupNames, errorDetails);
        }
    }

    private void emitRow(ProcessorOutput out, String path, Set<String> entraGroupNames, Set<String> dssGroupNames, Set<String> errorDetails) throws Exception {
        Gson gson = new Gson();
        Row row = this.rf.row();
        row.put((Column)this.cf.column("path"), path);
        row.put((Column)this.cf.column("entra_groups"), gson.toJson(entraGroupNames));
        row.put((Column)this.cf.column("dss_groups"), gson.toJson(dssGroupNames));
        row.put((Column)this.cf.column("error_details"), gson.toJson(errorDetails));
        out.emitRow(row);
    }

    @Override
    public void notifyBeforeAborting() {
    }

    public record PermissionResponse(boolean isSuccess, String groupId, String error) {
    }

    public record GroupDetailResponse(boolean isSuccess, String name, String error) {
    }
}

