/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.lsfolder;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.lsfolder.ListFolderContentsRecipeParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamColumn;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.utils.DKUDateUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataExtractor {
    static final String PATH_COLUMN = "path";
    static final String BASENAME_COLUMN = "basename";
    static final String EXTENSION_COLUMN = "extension";
    static final String LAST_MODIFIED_COLUMN = "last_modified";
    static final String SIZE_COLUMN = "size";
    static final String DEFAULT_EXTENSION_REGEX = "tar\\.bz2|tar\\.gz|\\w+";
    private final Pattern extensionPattern = Pattern.compile("(?<!^)\\.(?:" + DKUApp.getProperty((String)"dku.recipes.list_folder_contents.extension_regex", (String)"tar\\.bz2|tar\\.gz|\\w+") + ")$");
    private final ListFolderContentsRecipeParams params;

    public MetadataExtractor(ListFolderContentsRecipeParams params) {
        this.params = params;
    }

    public Schema getSchema() {
        Schema outputSchema = new Schema();
        if (this.params.path) {
            outputSchema.addColumn(new SchemaColumn(PATH_COLUMN, Type.STRING));
        }
        if (this.params.basename) {
            outputSchema.addColumn(new SchemaColumn(BASENAME_COLUMN, Type.STRING));
        }
        if (this.params.extension) {
            outputSchema.addColumn(new SchemaColumn(EXTENSION_COLUMN, Type.STRING));
        }
        if (this.params.lastModified) {
            outputSchema.addColumn(new SchemaColumn(LAST_MODIFIED_COLUMN, Type.DATE));
        }
        if (this.params.size) {
            outputSchema.addColumn(new SchemaColumn(SIZE_COLUMN, Type.BIGINT));
        }
        for (ListFolderContentsRecipeParams.LevelMappingDesc e : this.params.getLevelMapping()) {
            if (outputSchema.hasColumn(e.to)) continue;
            outputSchema.addColumn(new SchemaColumn(e.to, Type.STRING));
        }
        return outputSchema;
    }

    public Row buildRow(StreamRowFactory rf, StreamColumnFactory cf, ManagedFolderHandler.ManagedFolderListingItem item) {
        Row row = rf.row();
        Path path = Paths.get(item.path, new String[0]);
        if (this.params.path) {
            row.put((Column)cf.column(PATH_COLUMN), this.getPath(path));
        }
        if (this.params.basename) {
            row.put((Column)cf.column(BASENAME_COLUMN), this.getBasename(path));
        }
        if (this.params.extension) {
            row.put((Column)cf.column(EXTENSION_COLUMN), this.getExtension(path));
        }
        if (this.params.lastModified) {
            row.put((Column)cf.column(LAST_MODIFIED_COLUMN), this.getLastModified(item));
        }
        if (this.params.size) {
            row.put((Column)cf.column(SIZE_COLUMN), this.getSize(item));
        }
        for (ListFolderContentsRecipeParams.LevelMappingDesc m : this.params.getLevelMapping()) {
            int level = Integer.parseInt(m.from);
            StreamColumn column = cf.column(m.to);
            int levelCount = path.getNameCount();
            if (level > 0 && level < levelCount) {
                row.put((Column)column, path.getName(level - 1).toString());
                continue;
            }
            if (level >= 0 || -level >= levelCount) continue;
            row.put((Column)column, path.getName(levelCount + level - 1).toString());
        }
        return row;
    }

    private String getPath(Path path) {
        return path.toString();
    }

    private String getBasename(Path path) {
        String filename = path.getFileName().toString();
        String ext = this.getExtension(path);
        if (ext != null) {
            filename = filename.substring(0, filename.length() - ext.length() - 1);
        }
        return filename;
    }

    private String getExtension(Path path) {
        String filename = path.getFileName().toString();
        Matcher m = this.extensionPattern.matcher(filename);
        if (m.find()) {
            return m.group().substring(1);
        }
        return null;
    }

    private String getLastModified(ManagedFolderHandler.ManagedFolderListingItem item) {
        return DKUDateUtils.isoFormatUTC((long)item.lastModified);
    }

    private long getSize(ManagedFolderHandler.ManagedFolderListingItem item) {
        return item.size;
    }
}

