/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.ActivityAbortedException;
import com.dataiku.dip.dataflow.exec.PreRunSchemaPropagationHandler;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.exec.sql.AbstractSQLQueryRecipeRunner;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import java.util.stream.Stream;

public class SQLQueryRecipeRunner
extends AbstractSQLQueryRecipeRunner
implements InitializableAbortableRecipeRunner,
RecipeRunnerWithPayload {
    private String userCode;
    private QueryBunch unexpandedQueryBunch;
    private SQLQueryRecipeMeta.SQLQueryRecipeParams params;

    public SQLQueryRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        this.userCode = payload;
    }

    @Override
    public synchronized void init() throws Exception {
        if (this.abortNotified) {
            throw new ActivityAbortedException();
        }
        Preconditions.checkArgument((this.subgraph.getTargets().size() == 1 ? 1 : 0) != 0, (Object)"A SQL query recipe has one output");
        if (this.recipe.getModel().params != null && this.recipe.getModel().params instanceof SQLQueryRecipeMeta.SQLQueryRecipeParams) {
            this.params = RecipeRegistry.getParamsAs(this.activity, SQLQueryRecipeMeta.SQLQueryRecipeParams.class);
        } else {
            this.params = new SQLQueryRecipeMeta.SQLQueryRecipeParams();
            this.params.allowMultipleConnections = false;
        }
        if (!this.params.allowMultipleConnections) {
            this.mainConnection = SQLQueryRecipeRunner.getMainSingleConnection(this.authCtxService.getAuthCtx(), this.subgraph, this.datasetsDAO);
        } else {
            if (this.params.mainConnectionDataset == null) {
                throw ErrorContext.iae((String)"The dataset whose connection the query should be run in is not specified (mandatory when using multiple connections).");
            }
            String fullName = DatasetLocUtils.resolveSmart(this.recipe.getProjectKey(), this.params.mainConnectionDataset).getFullName();
            Dataset dataset = Stream.concat(this.subgraph.getSourceDatasets().stream(), this.subgraph.getTargetsDatasets().stream()).filter(flowDataset -> flowDataset.getFullName().equals(fullName)).findFirst().orElseThrow(() -> ErrorContext.iaef((String)"The dataset %s is not among the inputs nor output of the recipe.", (Object)this.params.mainConnectionDataset, (Object[])new Object[0])).getMandatory(this.datasetsDAO);
            AbstractSQLDatasetHandler.AbstractSQLConfig config = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
            this.mainConnection = config.connection;
        }
        new PreRunSchemaPropagationHandler(this.activity, this.recipe).propagateIfNeeded();
        SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), this.mainConnection);
        this.unexpandedQueryBunch = QueryBunch.fromScript(connData, this.userCode);
        if (this.unexpandedQueryBunch.query == null) {
            throw new Error("Could not find SQL query for " + this.recipe.getName());
        }
        this.outputDataset = this.subgraph.getSingleTargetDataset().getMandatory(this.datasetsDAO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        VariablesExpansionLoopItemsIterable veLoopIterable = new VariablesExpansionLoopItemsIterable(this.authCtxService.getAuthCtx(), this.recipeProjectKey, this.params.variablesExpansionLoopConfig);
        try {
            if (SQLQueryRecipeUtils.runsInSQLMode(this.mainConnection, this.outputDataset, this.unexpandedQueryBunch.query)) {
                logger.info((Object)"Running the SQL query recipe in full-SQL mode");
                Partition targetPartition = this.subgraph.getTargetPartition(this.subgraph.getTargets().get(0));
                AbstractSQLDatasetHandler.AbstractSQLConfig outputConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)this.outputDataset.getParams();
                this.runFullSQL(this.mainConnection, outputConfig.catalog, outputConfig.schema, outputConfig.table, targetPartition, this.unexpandedQueryBunch, veLoopIterable);
            } else {
                this.runRegular(this.mainConnection, this.unexpandedQueryBunch, veLoopIterable);
            }
        }
        finally {
            SQLQueryRecipeRunner sQLQueryRecipeRunner = this;
            synchronized (sQLQueryRecipeRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
    }
}

