/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.sql.queries.ExpressionUtils;

public class VerticaPartitionConfig {
    public final String keyColumn;
    public final Partition outKey;
    public final String partitionValue;
    public final boolean partitioned;

    public VerticaPartitionConfig(Dataset outputDS, Partition outputPartition) {
        if (outputDS.getPartitioningSchema() != null && outputDS.getPartitioningSchema().isPartitioned()) {
            this.keyColumn = (String)outputDS.getPartitioningSchema().getDimensionNames().get(0);
            this.outKey = this.computeVerticaPartitionKey(outputPartition);
            this.partitionValue = this.computePartitionValue(outputDS, outputPartition, this.keyColumn);
            this.partitioned = true;
        } else {
            this.keyColumn = null;
            this.outKey = null;
            this.partitionValue = null;
            this.partitioned = false;
        }
    }

    private Partition computeVerticaPartitionKey(Partition targetPartition) {
        targetPartition.getScheme().getSingleDimension();
        return targetPartition;
    }

    private String computePartitionValue(Dataset outputDS, Partition outputPartition, String singlePartitionColumn) {
        DimensionValue dimensionValue = (DimensionValue)outputPartition.getDimensionValues().get(singlePartitionColumn);
        if (dimensionValue == null) {
            return null;
        }
        SchemaColumn partitionColumn = outputDS.getSchema().getColumn(singlePartitionColumn);
        if (partitionColumn == null) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Dataset '" + outputDS.getName() + "' does not contain the partitioning column: " + singlePartitionColumn);
        }
        Type partitionColumnType = partitionColumn.getType();
        return ExpressionUtils.getStringForDimensionValue(dimensionValue, partitionColumnType);
    }
}

