/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.export.execution;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dataflow.export.execution.FlowEnrichedExport;
import com.dataiku.dip.dataflow.export.model.FlowExportFormat;
import com.dataiku.dip.graphicsexport.execution.ExportScriptRunner;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import java.io.File;
import java.util.Set;

public class FlowExportScriptRunner
extends ExportScriptRunner {
    public FlowExportScriptRunner(FlowEnrichedExport export, File exportDirectory, InternalAPIKeysService.APIKey apiKey) {
        super(export, exportDirectory, apiKey);
    }

    @Override
    protected String getScriptFileName() {
        return "export-flow.js";
    }

    @Override
    protected ExportScriptRunner.ScriptConfig getScriptConfig() {
        FlowEnrichedExport flowExport = (FlowEnrichedExport)this.export;
        FlowExportFormat format = (FlowExportFormat)flowExport.format;
        Config result = new Config();
        result.urlsRequiringAuthentication = this.getUrlsRequiringAuthentication();
        result.browserSandBoxing = this.export.browserSandBoxing;
        result.pageDefaultTimeout = ApplicationConfigurator.getProperty((String)"dku.exports.puppeteer.pageDefaultTimeout", (int)0);
        result.outputDirectory = this.exportDirectory.getAbsolutePath();
        result.fileType = String.valueOf((Object)format.fileType);
        result.width = String.valueOf(format.width);
        result.height = String.valueOf(format.height);
        result.tileScale = String.valueOf(format.tileScale);
        result.flowUrl = flowExport.flowUrl;
        result.drawZones = format.drawZones;
        result.collapsedZones = format.collapsedZones;
        result.searchQuery = format.searchQuery;
        return result;
    }

    private static class Config
    extends ExportScriptRunner.ScriptConfig {
        public String fileType;
        public String width;
        public String height;
        public String tileScale;
        public String flowUrl;
        public boolean drawZones;
        public Set<String> collapsedZones;
        public String searchQuery;

        private Config() {
        }
    }
}

