/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.XMLUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import se.fishtank.css.selectors.NodeSelectorException;
import se.fishtank.css.selectors.dom.DOMNodeSelector;

public abstract class GraphSerializerCommon {
    private static final String CACHE_NAME = "flowGraph.svg";
    private static final int CACHE_MAX_SIZE = ApplicationConfigurator.getParams().getIntParam("dku.caches.flowGraph.svg.maxSize", Integer.valueOf(500));
    protected List<LabelRemapping> labelsRemapping = new ArrayList<LabelRemapping>();
    protected GraphCache cache;
    private static Logger logger = Logger.getLogger((String)"dku.GraphSerializerCommon");

    public static String graphVizEscape(String str) {
        int c2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i += Character.charCount(c2)) {
            c2 = str.codePointAt(i);
            if (c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 >= 48 && c2 <= 57) {
                sb.append((char)c2);
                continue;
            }
            if (c2 == 95) {
                sb.append("__");
                continue;
            }
            sb.append("_" + c2 + "_");
        }
        return sb.toString();
    }

    public static String escapeForQuotedField(String str) {
        int c2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i += Character.charCount(c2)) {
            c2 = str.codePointAt(i);
            if (c2 == 34) {
                sb.append("\\\"");
                continue;
            }
            if (c2 == 92) {
                sb.append("\\\\");
                continue;
            }
            sb.append((char)c2);
        }
        return sb.toString();
    }

    public static String graphVizUnescape(String str) {
        int c2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); i += Character.charCount(c2)) {
            c2 = str.codePointAt(i);
            if (c2 == 95) {
                int n = 0;
                boolean z = false;
                ++i;
                while (i < str.length() && (c2 = str.codePointAt(i)) != 95) {
                    z = true;
                    n = 10 * n + (c2 - 48);
                    i += Character.charCount(c2);
                }
                if (z) {
                    sb.appendCodePoint(n);
                    continue;
                }
                sb.append('_');
                continue;
            }
            sb.append((char)c2);
        }
        return sb.toString();
    }

    protected String cleanupSVG(byte[] in, boolean replaceTextContent) throws Exception {
        Document doc = XMLUtils.parse(in);
        DOMNodeSelector selector = new DOMNodeSelector((Node)doc.getDocumentElement());
        this.cleanupBeginning(doc, selector);
        for (Node edgeNode : selector.querySelectorAll("g.edge")) {
            this.cleanupEdge(edgeNode);
        }
        for (Node edgePathNode : selector.querySelectorAll("g.edge > path")) {
            this.cleanupEdgePath(edgePathNode);
        }
        for (Node edgeTextNode : selector.querySelectorAll("g.edge > text")) {
            this.cleanupEdgeText(edgeTextNode);
        }
        for (Node nodeTextNode : selector.querySelectorAll("g.node > text")) {
            String id = ((Element)nodeTextNode.getParentNode()).getAttribute("id");
            if (!StringUtils.isNumeric((String)id)) continue;
            this.cleanupNodeText(nodeTextNode, id, replaceTextContent);
        }
        this.cleanupEnding(doc, selector);
        return XMLUtils.writeToString(doc);
    }

    protected void cleanupBeginning(Document doc, DOMNodeSelector selector) {
    }

    protected void cleanupEnding(Document doc, DOMNodeSelector selector) throws IOException, SAXException {
    }

    protected void cleanupNodeText(Node nodeTextNode, String id, boolean replaceTextContent) throws NodeSelectorException {
        NodeRemapping text = (NodeRemapping)this.labelsRemapping.get(Integer.parseInt(id));
        Element parentNode = (Element)nodeTextNode.getParentNode();
        parentNode.setAttribute("data-id", text.id);
        parentNode.setAttribute("data-name", text.name);
        parentNode.setAttribute("data-description", text.description);
        parentNode.setAttribute("data-type", text.type);
        parentNode.setAttribute("id", text.id);
        if (replaceTextContent) {
            nodeTextNode.setTextContent(text.name);
        }
        new DOMNodeSelector((Node)parentNode).querySelector("title").setTextContent(text.label);
    }

    protected void cleanupEdge(Node edgeNode) {
    }

    protected void cleanupEdgeText(Node edgeTextNode) {
        EdgeRemapping text = (EdgeRemapping)this.labelsRemapping.get(Integer.parseInt(edgeTextNode.getChildNodes().item(0).getNodeValue()));
        Element parentNode = (Element)edgeTextNode.getParentNode();
        parentNode.setAttribute("data-from", text.from);
        parentNode.setAttribute("data-to", text.to);
    }

    protected void cleanupEdgePath(Node edgeNodePath) {
    }

    public void setCache(GraphCache cache) {
        this.cache = cache;
    }

    public String cleanSVGCache(String graphviz, String layoutEngine, boolean replaceTextContent) throws Exception {
        if (!layoutEngine.equals("dot") && !layoutEngine.equals("neato")) {
            throw new SecurityException("Illegal layout engine");
        }
        String cacheKey = this.getCacheKeyPrefix() + "_" + layoutEngine + "_" + graphviz;
        String cleanedSVG = null;
        if (this.cache != null) {
            cleanedSVG = (String)this.cache.dot2CleanedSVG.getIfPresent((Object)cacheKey);
        }
        if (cleanedSVG == null) {
            logger.info((Object)"SVG Graph not in cache, executing");
            try (AutoDelete tmpFile = DSSTempUtils.getTempFolder((String)"flow-layout-graphviz", (String)"flow-");){
                DKUFileUtils.writeFileUTF8((File)tmpFile, (String)graphviz);
                byte[] rawSvg = DKUtils.execAndGetOutputWithThreadsBaseName((String)"svg-build", (String[])new String[]{layoutEngine, "-q", "-Tsvg", tmpFile.getAbsolutePath()}, null);
                cleanedSVG = this.cleanupSVG(rawSvg, replaceTextContent);
            }
            logger.info((Object)"Conversion to SVG done");
            if (this.cache != null) {
                this.cache.dot2CleanedSVG.put((Object)cacheKey, (Object)cleanedSVG);
            }
        }
        return cleanedSVG;
    }

    protected abstract String getCacheKeyPrefix();

    protected static class NodeRemapping
    implements LabelRemapping {
        String id;
        String name;
        String label;
        String description;
        String type;

        protected NodeRemapping() {
        }
    }

    protected static class EdgeRemapping
    implements LabelRemapping {
        String from;
        String to;

        protected EdgeRemapping() {
        }
    }

    public static class GraphCache {
        Cache<String, String> dot2CleanedSVG = CacheBuilder.newBuilder().maximumSize((long)CACHE_MAX_SIZE).recordStats().softValues().build();

        public GraphCache() {
            if (!DSSMetrics.registry().getNames().contains("dku.caches.flowGraph.svg.loadCount")) {
                DSSMetrics.registry().registerAll(GuavaCacheMetrics.cacheMetricsSet((String)GraphSerializerCommon.CACHE_NAME, this.dot2CleanedSVG));
            }
        }
    }

    protected static interface LabelRemapping {
    }
}

