/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.postactions;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.kernel.master.postactions.PostJobAction;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ProjectsUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class RemoveDanglingPods
extends PostJobAction {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.jobs.postactions.pods");

    public RemoveDanglingPods(String projectKey, String jobId) {
        super(projectKey, jobId);
    }

    @Override
    public void run() throws Exception {
        logger.debug((Object)("Executing post-action " + this.getClass().getSimpleName()));
        Params p = ProjectsUtils.getProjectDKUPropertiesAsParamsWithSystemOverrideEvenIfProjectDoesNotExist_AutoTXN(this.projectKey);
        if (!p.getBoolParam("dku.jobs.postActions.removeDanglingPods.enabled", true)) {
            logger.info((Object)"Leaving dangling pods (requested by project property)");
            return;
        }
        if (!this.instanceUsesKubernetes()) {
            logger.debug((Object)"Instance does not use Kubernetes, not cleaning up dangling pods");
            return;
        }
        ClusterSettings clusterSettings = new ClusterSelector().selectForProject(DSSAuthCtx.fakeAdminForTests("__DSS__"), this.projectKey);
        ContainerExecRuntimeConfig inlineConfig = new ContainerExecRuntimeConfig();
        inlineConfig.type = ContainerExecRuntimeConfig.Container.KUBERNETES;
        inlineConfig.noImplicitK8sClusterAndNoDefaultClusterId = clusterSettings.isNoImplicitK8sClusterAndNoDefaultClusterId();
        ContainerExecRuntimeConfig configOverrides = clusterSettings.getContainerSettings().executionConfigsGenericOverrides;
        ContainerExecRuntimeConfig k8sConfig = ContainerOverrideMask.getOverriden(inlineConfig, configOverrides);
        ArrayList<CallSite> selectorLabels = new ArrayList<CallSite>();
        selectorLabels.add((CallSite)((Object)("dataiku.com/dku-install-id=" + KubernetesExecUtils.sanitizeLabelValue(ApplicationConfigurator.getInstallId(), false))));
        selectorLabels.add((CallSite)((Object)("dataiku.com/dku-project-key=" + KubernetesExecUtils.sanitizeLabelValue(this.projectKey, false))));
        selectorLabels.add((CallSite)((Object)("dataiku.com/dku-job-id=" + KubernetesExecUtils.sanitizeLabelValue(this.jobId, true))));
        selectorLabels.add((CallSite)((Object)("dataiku.com/dku-process-type!=" + KubernetesExecUtils.sanitizeLabelValue(MainLoggingConfigurator.ProcessType.BACKEND.name(), true))));
        String selector = StringUtils.join(selectorLabels, (String)",");
        try {
            logger.info((Object)("Pods corresponding to job: " + String.valueOf(KubectlHelper.executeKubectlToJSON(k8sConfig, "get", "pods", "--all-namespaces", "-l", selector))));
            String ret = KubectlHelper.executeKubectlToRawString(k8sConfig, "delete", "pods", "--all-namespaces", "-l", selector, "--wait=false");
            logger.info((Object)("Deletion result:" + ret));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete dangling pods", (Throwable)e);
        }
    }

    private boolean instanceUsesKubernetes() {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        boolean hasK8SContainerExecutionConfig = gs.containerSettings.executionConfigs.stream().anyMatch(x -> x.type == ContainerExecRuntimeConfig.Container.KUBERNETES);
        boolean hasManagedSparkonK8S = gs.sparkSettings.sparkEnabled && gs.sparkSettings.executionConfigs.stream().anyMatch(x -> x.kubernetesSettings.managedKubernetes);
        return hasK8SContainerExecutionConfig || hasManagedSparkonK8S;
    }
}

