/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.status.SerializedJobActivityStatus;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPipelineRunnableSubgraph
extends RunnableSubgraph {
    private final JobActivity root;
    private List<JobActivity> includedActivitiesWithRoot = new ArrayList<JobActivity>();
    private boolean frozen;
    private String precomputedId;
    protected List<FlowComputable.FlowComputableWithRole> sources = new ArrayList<FlowComputable.FlowComputableWithRole>();
    protected List<FlowComputable.FlowComputableWithRole> targets = new ArrayList<FlowComputable.FlowComputableWithRole>();

    public AbstractPipelineRunnableSubgraph(JobActivity root) {
        this.root = root;
    }

    public abstract SerializedJobActivityStatus.ActivityType getActivityType();

    public List<JobActivity> getAllIncludedActivitiesWithRoot() {
        return this.includedActivitiesWithRoot;
    }

    public JobActivity getRoot() {
        return this.root;
    }

    void addIncludedActivities(Collection<JobActivity> as) {
        assert (!this.frozen);
        this.includedActivitiesWithRoot.addAll(as);
    }

    protected abstract String getIdPrefix();

    public void freeze() {
        assert (!this.frozen);
        this.frozen = true;
    }

    @Override
    public String id() {
        assert (this.frozen);
        if (this.precomputedId != null) {
            return this.precomputedId;
        }
        ArrayList<String> idElements = new ArrayList<String>();
        idElements.add(this.getIdPrefix());
        String targetPartitionsId = this.getTargetPartitionsId();
        if (StringUtils.isNotBlank((String)targetPartitionsId)) {
            idElements.add(targetPartitionsId);
        }
        idElements.add("incl_");
        for (JobActivity i : this.includedActivitiesWithRoot) {
            idElements.add(i.id());
        }
        String id = Joiner.on((String)"_").join(idElements);
        this.precomputedId = id = id.substring(0, Math.min(id.length(), 200));
        return id;
    }

    private String getTargetPartitionsId() {
        int numberOfTargets = this.getTargets().size();
        if (numberOfTargets < 1) {
            return "";
        }
        String result = this.getTargetPartitions().values().iterator().next().id();
        return AbstractPipelineRunnableSubgraph.makePathSafePartitionValue(result);
    }

    @Override
    public Map<String, FlowComputable> getSourcesMap() {
        HashMap<String, FlowComputable> ret = new HashMap<String, FlowComputable>();
        for (FlowComputable.FlowComputableWithRole fd : this.sources) {
            ret.put(fd.computable.getFullId(), fd.computable);
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public Map<String, FlowComputable> getTargetsMap() {
        HashMap<String, FlowComputable> ret = new HashMap<String, FlowComputable>();
        for (FlowComputable.FlowComputableWithRole fd : this.targets) {
            ret.put(fd.computable.getFullId(), fd.computable);
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public List<? extends FlowComputable> getSources() {
        return Collections.unmodifiableList(this.sources.stream().map(x -> x.computable).collect(Collectors.toList()));
    }

    @Override
    public List<FlowComputable.FlowComputableWithRole> getSourcesWithRoles() {
        return Collections.unmodifiableList(this.sources);
    }

    @Override
    public void addSource_NoRole(FlowComputable source) {
        assert (!this.frozen);
        this.sources.add(new FlowComputable.FlowComputableWithRole(source, null));
    }

    @Override
    public List<? extends FlowComputable> getTargets() {
        return Collections.unmodifiableList(this.targets.stream().map(x -> x.computable).collect(Collectors.toList()));
    }

    @Override
    public List<FlowComputable.FlowComputableWithRole> getTargetsWithRoles() {
        return Collections.unmodifiableList(this.targets);
    }

    @Override
    public void addTarget_NoRole(FlowComputable target) {
        assert (!this.frozen);
        this.targets.add(new FlowComputable.FlowComputableWithRole(target, null));
    }

    @Override
    public List<FlowRecipe> listRecipes() {
        HashMap recipeById = Maps.newHashMap();
        for (FlowRecipe recipe : this.root.getSubgraph().listRecipes()) {
            recipeById.put(recipe.getFullId(), recipe);
        }
        for (JobActivity jobActivity : this.includedActivitiesWithRoot) {
            for (FlowRecipe recipe : jobActivity.getSubgraph().listRecipes()) {
                recipeById.put(recipe.getFullId(), recipe);
            }
        }
        return Lists.newArrayList(recipeById.values());
    }

    @Override
    public boolean isAllTargetPartitions() {
        return false;
    }
}

