/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming.slave;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.dataflow.AbstractJobKernelServlet;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.streaming.slave.CAKernelSession;
import com.dataiku.dip.dataflow.streaming.slave.RPCModel;
import com.dataiku.dip.exceptions.NotAuthenticatedException;
import com.dataiku.dip.recipes.streaming.python.ContinuousPythonRecipeRunner;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.hproxy.model.PingResponse;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;

public class CAKServlet
extends AbstractJobKernelServlet {
    private static final long serialVersionUID = 1L;
    private String sharedSecret;
    protected CAKernelSession currentSession;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.jobs");

    public CAKServlet(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    @Override
    protected RWTransactionRef getCurrentTransactionRef() {
        return this.currentSession.getTransactionRef();
    }

    @Override
    protected void setJobContext() {
        JobContext.setJob(this.currentSession.getJobProjectKey(), this.currentSession.getJobId(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        long startTime = System.currentTimeMillis();
        String receivedSecretKey = req.getHeader("X-DKU-IPythonSharedSecret");
        String receivedApiKey = req.getHeader("X-DKU-APITicket");
        try {
            AbstractJobKernelServlet.AuthenticationType authenticationType;
            if (this.currentSession != null && this.currentSession.authenticates(receivedApiKey)) {
                logger.info((Object)"Connects using API ticket");
                authenticationType = AbstractJobKernelServlet.AuthenticationType.API_TICKET;
            } else {
                if (!StringUtils.isNotBlank((String)receivedSecretKey) || !StringUtils.equals((String)this.sharedSecret, (String)receivedSecretKey)) throw new NotAuthenticatedException("No or bad authentication", "no-authentication");
                logger.info((Object)"Connects using Shared secret");
                authenticationType = AbstractJobKernelServlet.AuthenticationType.SHARED_SECRET;
            }
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.equals("/ping")) {
                logger.debug((Object)("Received command : " + path));
            }
            switch (path) {
                case "/pintercom/ping": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    PingResponse pr = new PingResponse();
                    pr.ok = true;
                    this.writeJSON(resp, pr);
                    return;
                }
                case "/pintercom/run": {
                    this.assertCallFromBackend(path, authenticationType);
                    assert (this.currentSession == null);
                    String bodyData = IOUtils.toString((InputStream)req.getInputStream(), (String)"utf8");
                    RPCModel.RunQuery ssq = (RPCModel.RunQuery)JSON.parse((String)bodyData, RPCModel.RunQuery.class);
                    logger.info((Object)("Start Session:\n" + JSON.json((Object)ssq)));
                    this.currentSession = new CAKernelSession(ssq.definition, ssq.ticketSecret, ssq.initiatorAuthContext);
                    SpringUtils.getInstance().autowire((Object)this.currentSession);
                    SerializedError err = this.currentSession.run();
                    this.writeJSON(resp, err);
                    return;
                }
                case "/pintercom/abort": {
                    JettyUtils.consumeRequest((HttpServletRequest)req);
                    this.assertCallFromBackend(path, authenticationType);
                    assert (this.currentSession != null);
                    logger.warn((Object)"Received abort signal");
                    this.currentSession.notifyAbort();
                    return;
                }
                case "/tintercom/cpython/start-one": {
                    this.verifyCallFromChild(path, authenticationType);
                    String functionId = req.getParameter("functionId");
                    this.writeJSON(resp, ContinuousPythonRecipeRunner.startContainerizedFunctionReplica(functionId));
                    return;
                }
                case "/tintercom/variables/get-resolved-for-project": {
                    this.verifyCallFromChild(path, authenticationType);
                    String typed = StringUtils.defaultIfBlank((String)req.getParameter("typed"), (String)"false");
                    this.writeJSON(resp, this.currentSession.getResolvedProjectVariables(req.getParameter("projectKey"), Boolean.parseBoolean(typed)));
                    return;
                }
                default: {
                    this.baseCommandService(this.currentSession, path, authenticationType, req, resp);
                    return;
                }
            }
        }
        catch (AbstractJobKernelServlet.AuthenticationTypeException e) {
            resp.sendError(403);
            return;
        }
        catch (Throwable e) {
            this.sendError(resp, e);
            return;
        }
        finally {
            long endTime = System.currentTimeMillis();
            if (!path.equals("/ping")) {
                logger.debug((Object)("Command " + path + " processed in " + (endTime - startTime) + "ms"));
            }
        }
    }
}

