/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.utils;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeMeta;
import com.dataiku.dip.dataflow.exec.sql.SQLScriptRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreSynchronizationUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;

public class FlowVariables {
    private static final Set<String> INJECT_SQL_QUERY_RECIPE_TYPES = new HashSet<String>(Arrays.asList(SQLQueryRecipeMeta.META.getType(), SQLScriptRecipeMeta.META.getType(), HiveRecipeMeta.META.getType()));
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.variables");

    public static void addPartitioningVariables(AuthCtx authCtx, Map<String, String> additionalVariables, RunnableSubgraph subgraph, DatasetsDAO datasetsDAO) throws IOException, CodedException, DKUSecurityException {
        Partitionable dataset;
        for (FlowPartitionable fds : subgraph.getPartitionedTargets()) {
            dataset = fds.getPartitioned(datasetsDAO);
            Partition targetPart = subgraph.getTargetPartitions().get(fds.getFullName());
            FlowVariables.addVariablesForDstDataset(authCtx, additionalVariables, dataset, targetPart, "DKU_DST_");
        }
        for (FlowPartitionable fds : subgraph.getPartitionedSources()) {
            dataset = fds.getPartitioned(datasetsDAO);
            List<Partition> sourceParts = subgraph.getSourcePartitions((FlowComputable)((Object)fds));
            FlowVariables.addVariablesForSrcDataset(authCtx, additionalVariables, dataset, sourceParts, "DKU_SRC_" + dataset.getName() + "_");
            if (subgraph.getSources().size() != 1) continue;
            FlowVariables.addVariablesForSrcDataset(authCtx, additionalVariables, dataset, sourceParts, "DKU_SRC_");
        }
    }

    public static Map<String, String> getSQLTableVariables(AuthCtx authCtx, SerializedRecipe recipe) throws IOException, DKUSecurityException {
        return FlowVariables.getSQLTableVariables(authCtx, recipe, false);
    }

    public static Map<String, String> getSQLTableVariables(AuthCtx authCtx, SerializedRecipe recipe, boolean isForHiveValidation) throws IOException, DKUSecurityException {
        int i;
        List<Object> roleItems;
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, SerializedRecipe.InputRole> entry : recipe.getInputsUnsafe().entrySet()) {
            roleItems = entry.getValue().items;
            for (i = 0; i < roleItems.size(); ++i) {
                SerializedRecipe.RecipeInput input = roleItems.get(i);
                result.putAll(FlowVariables.getSQLTableVariables(authCtx, recipe, input.ref, "input", i, isForHiveValidation));
            }
        }
        for (Map.Entry<String, Object> entry : recipe.getOutputsUnsafe().entrySet()) {
            roleItems = ((SerializedRecipe.OutputRole)entry.getValue()).items;
            for (i = 0; i < roleItems.size(); ++i) {
                SerializedRecipe.RecipeOutput output = (SerializedRecipe.RecipeOutput)roleItems.get(i);
                result.putAll(FlowVariables.getSQLTableVariables(authCtx, recipe, output.ref, "output", i, false));
            }
        }
        return result;
    }

    private static Map<String, String> getSQLTableVariables(AuthCtx authCtx, SerializedRecipe recipe, String ref, String prefix, int indexInRole, boolean isForHiveValidation) throws IOException, DKUSecurityException {
        AnyLoc loc;
        HashMap<String, String> result = new HashMap<String, String>();
        DatasetsDAO datasetsDAO = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        SerializedDataset sd = (SerializedDataset)datasetsDAO.getOrNull(loc = AnyLoc.resolveSmart(recipe.projectKey, ref));
        if (sd != null) {
            AbstractSQLDatasetHandler dh;
            Dataset dataset = Dataset.fromSerialized(sd);
            if (DatasetInspector.isSQLTable(dataset)) {
                dh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);
                try {
                    SQLUtils.SQLTable table = ((AbstractSQLTableDatasetHandler)dh).getResolvedTable();
                    SQLDialect dialect = dh.getDialect();
                    result.put("tbl:" + ref, dialect.getQuotedTableFullName(table));
                    result.put(prefix + ":tbl:" + indexInRole, dialect.getQuotedTableFullName(table));
                    if (StringUtils.isNotBlank((String)table.getCatalog())) {
                        result.put("catalog:" + ref, dialect.quoteIdentifier(table.getCatalog()));
                        result.put(prefix + ":catalog:" + indexInRole, dialect.quoteIdentifier(table.getCatalog()));
                    }
                    if (StringUtils.isNotBlank((String)table.getSchemaNullIfBlank())) {
                        result.put("schema:" + ref, dialect.quoteIdentifier(table.getSchemaNullIfBlank()));
                        result.put(prefix + ":schema:" + indexInRole, dialect.quoteIdentifier(table.getSchemaNullIfBlank()));
                    }
                }
                finally {
                    if (dh != null) {
                        dh.close();
                    }
                }
            }
            if (DatasetInspector.isSQLQuery(dataset.getModel())) {
                dh = (AbstractSQLDatasetHandler)DatasetHandlerFactory.build(authCtx, dataset);
                try {
                    SQLDialect dialect = dh.getDialect();
                    AbstractSQLDatasetHandler.AbstractSQLConfig config = dh.getResolvedAbstractConfig();
                    Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
                    if (StringUtils.isBlank((String)config.query)) {
                        logger.warn((Object)(recipe.name + ": query dataset " + dh.getDataset().getFullName() + " is empty, not adding it to variables"));
                    } else {
                        String[] statements = splitter.split(config.query);
                        int selectIndex = SQLUtils.findLastSelectStatement(statements, splitter);
                        if (statements.length == 1 && selectIndex == 0) {
                            String queryNoSemiColon = splitter.stripComments(statements[0]);
                            Object queryTable = "(\n" + queryNoSemiColon + "\n) as " + dialect.quoteIdentifier("dku__query_" + indexInRole + "_" + dh.getDataset().getName());
                            if (isForHiveValidation) {
                                queryTable = dh.getDataset().getName();
                            }
                            result.put("tbl:" + ref, (String)queryTable);
                            result.put(prefix + ":tbl:" + indexInRole, (String)queryTable);
                            result.put("query:" + ref, queryNoSemiColon);
                            result.put(prefix + ":query:" + indexInRole, queryNoSemiColon);
                        } else {
                            if (INJECT_SQL_QUERY_RECIPE_TYPES.contains(recipe.type)) {
                                throw ErrorContext.ice((String)(recipe.name + ": query dataset " + dh.getDataset().getFullName() + " must only contain a SELECT statement to be usable in SQL recipe."));
                            }
                            logger.warn((Object)(recipe.name + ": query dataset " + dh.getDataset().getFullName() + " doesn't just contain a SELECT statement, not adding it to variables"));
                        }
                    }
                }
                finally {
                    if (dh != null) {
                        dh.close();
                    }
                }
            }
            if (DatasetInspector.isHDFSDataset(dataset) && MetastoreSynchronizationUtils.synchronizationRequested((AuthCtx)authCtx, (Dataset)dataset).requested || DatasetInspector.isHiveTable(dataset)) {
                SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
                result.put("tbl:" + ref, tableRef.getTable());
                result.put(prefix + ":tbl:" + indexInRole, tableRef.getTable());
                if (StringUtils.isNotBlank((String)tableRef.getSchemaNullIfBlank())) {
                    result.put("db:" + ref, tableRef.getSchemaNullIfBlank());
                    result.put(prefix + ":db:" + indexInRole, tableRef.getSchemaNullIfBlank());
                }
            }
        }
        return result;
    }

    public static void addWhereClauseVariables(Map<String, String> additionalVariables, RunnableSubgraph subgraph, DatasetsDAO datasetsDAO, SQLDialect dialect) throws IOException {
        for (FlowDataset fds : subgraph.getSourceDatasets()) {
            Dataset dataset = fds.getMandatory(datasetsDAO);
            List<Partition> sourceParts = subgraph.getSourcePartitions(fds);
            FlowVariables.addWhereClauseVariablesForSrcDataset(additionalVariables, dataset, sourceParts, "_" + dataset.getName(), dialect);
            if (subgraph.getSources().size() != 1) continue;
            FlowVariables.addWhereClauseVariablesForSrcDataset(additionalVariables, dataset, sourceParts, "", dialect);
        }
    }

    public static void addVariablesForDstDataset(AuthCtx authCtx, Map<String, String> additionalVariables, Partitionable partitioned, Partition partition, String prefix) throws IOException, CodedException, DKUSecurityException {
        if (partitioned instanceof Dataset && DatasetHandlerFactory.getMeta((Dataset)partitioned).isFS()) {
            try (AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, (Dataset)partitioned);){
                additionalVariables.put("DKU_LOCATION_" + partitioned.getName(), fsdh.getInformationalRootPath());
            }
        }
        if (partition == null || partition.getScheme() == null) {
            return;
        }
        for (String dimName : partition.getScheme().getDimensionNames()) {
            Dimension dim = partition.getScheme().getDimension(dimName);
            DimensionValue dimVal = (DimensionValue)partition.getDimensionValues().get(dimName);
            if (dim instanceof TimeDimension) {
                FlowVariables.addVariablesForTimeDimension(additionalVariables, (TimeDimension)dim, (TimeDimensionValue)dimVal, prefix);
            }
            additionalVariables.put(prefix + dimName, dimVal.id());
        }
    }

    public static void addVariablesForSrcDataset(AuthCtx authCtx, Map<String, String> additionalVariables, Partitionable partitioned, List<Partition> partitions, String prefix) throws IOException, DKUSecurityException, CodedException {
        if (partitioned instanceof Dataset && DatasetHandlerFactory.getMeta((Dataset)partitioned).isFS()) {
            try (AbstractFSDatasetHandler fsdh = (AbstractFSDatasetHandler)DatasetHandlerFactory.build(authCtx, (Dataset)partitioned);){
                additionalVariables.put("DKU_LOCATION_" + partitioned.getName(), fsdh.getInformationalRootPath());
            }
        }
        if (partitions.size() >= 1 && partitions.get(0).getScheme() == null) {
            return;
        }
        if (partitions.size() == 1) {
            for (String dimName : partitioned.getPartitioningSchema().getDimensionNames()) {
                Dimension dim = partitioned.getPartitioningSchema().getDimension(dimName);
                DimensionValue dimensionValue = (DimensionValue)partitions.get(0).getDimensionValues().get(dimName);
                if (dim instanceof TimeDimension) {
                    FlowVariables.addVariablesForTimeDimension(additionalVariables, (TimeDimension)dim, (TimeDimensionValue)dimensionValue, prefix);
                }
                additionalVariables.put(prefix + dimName, dimensionValue.id());
            }
        }
        ArrayList<String> timeIds = new ArrayList<String>();
        HashMap values = Maps.newHashMap();
        for (Partition partition : partitions) {
            for (String dimName : partitioned.getPartitioningSchema().getDimensionNames()) {
                Dimension dim = partitioned.getPartitioningSchema().getDimension(dimName);
                String partitionId = ((DimensionValue)partition.getDimensionValues().get(dimName)).id();
                Set list = (Set)values.get(dimName);
                if (list == null) {
                    list = Sets.newHashSet();
                    values.put(dimName, list);
                }
                list.add(partitionId);
                if (!(dim instanceof TimeDimension)) continue;
                timeIds.add(partitionId);
            }
        }
        if (timeIds.size() > 0) {
            PartitioningUtils.sortIdsList(timeIds, false);
            additionalVariables.put(prefix + "FIRST_DATE", (String)timeIds.get(0));
            additionalVariables.put(prefix + "LAST_DATE", (String)timeIds.get(timeIds.size() - 1));
        }
        for (Map.Entry entry : values.entrySet()) {
            additionalVariables.put(prefix + (String)entry.getKey() + "_VALUES", "'" + Joiner.on((String)"', '").join((Iterable)entry.getValue()) + "'");
        }
    }

    public static void addVariablesForTimeDimension(Map<String, String> additionalVariables, TimeDimension td, TimeDimensionValue tdv, String prefix) {
        String vp = prefix;
        if (td.hasYear()) {
            additionalVariables.put(vp + "YEAR", String.format("%04d", tdv.getYear()));
        }
        if (td.hasMonth()) {
            additionalVariables.put(vp + "MONTH", String.format("%02d", tdv.getMonth()));
        }
        if (td.hasDay()) {
            Calendar cal = DKUtils.getUTCCalendar();
            cal.set(tdv.getYear(), tdv.getMonth() - 1, tdv.getDay(), tdv.getHour(), 0, 0);
            additionalVariables.put(vp + "DAY", String.format("%02d", tdv.getDay()));
            additionalVariables.put(vp + "DATE", String.format("%04d-%02d-%02d", tdv.getYear(), tdv.getMonth(), tdv.getDay()));
            cal.add(5, 1);
            FlowVariables.generateForCalendar(td, additionalVariables, cal, vp, "1DAYAFTER");
            cal.add(5, -2);
            FlowVariables.generateForCalendar(td, additionalVariables, cal, vp, "1DAYBEFORE");
            cal.add(5, -6);
            FlowVariables.generateForCalendar(td, additionalVariables, cal, vp, "7DAYSBEFORE");
            if (td.hasHour()) {
                cal.add(5, 7);
                additionalVariables.put(vp + "HOUR", String.format("%02d", tdv.getHour()));
                cal.add(11, 1);
                FlowVariables.generateForCalendar(td, additionalVariables, cal, vp, "1HOURAFTER");
                cal.add(11, -2);
                FlowVariables.generateForCalendar(td, additionalVariables, cal, vp, "1HOURBEFORE");
                cal.add(11, 1);
            }
        }
    }

    private static void generateForCalendar(TimeDimension td, Map<String, String> map, Calendar cal, String prefix, String suffix) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(cal.getTimeZone());
        map.put(prefix + "DATE_" + suffix, sdf.format(cal.getTime()));
        if (td.hasHour()) {
            map.put(prefix + "HOUR_" + suffix, String.format("%02d", cal.get(11)));
        }
        if (td.hasDay()) {
            map.put(prefix + "DAY_" + suffix, String.format("%02d", cal.get(5)));
        }
        if (td.hasMonth()) {
            map.put(prefix + "MONTH_" + suffix, String.format("%02d", 1 + cal.get(2)));
        }
        if (td.hasYear()) {
            map.put(prefix + "YEAR_" + suffix, String.format("%02d", cal.get(1)));
        }
    }

    public static String substituteSafe(final Map<String, String> subst, String input) {
        StrSubstitutor subs = new StrSubstitutor(new StrLookup(){

            public String lookup(String s) {
                return (String)subst.get(s);
            }
        });
        return subs.replace(input);
    }

    public static String substitute(final Map<String, String> subst, String i) {
        List c2 = Ordering.natural().reverse().onResultOf((Function)new Function<Map.Entry<String, String>, Integer>(){

            public Integer apply(@Nullable Map.Entry<String, String> arg0) {
                return arg0.getKey().length();
            }
        }).sortedCopy(subst.entrySet());
        for (Map.Entry av : c2) {
            String regex = Pattern.quote("$" + (String)av.getKey()) + "([^A-z0-9_])";
            i = i.replaceAll(regex, (String)av.getValue() + "$1");
        }
        StrSubstitutor subs = new StrSubstitutor(new StrLookup(){

            public String lookup(String s) {
                return (String)subst.get(s);
            }
        });
        i = subs.replace(i);
        return i;
    }

    public static void addWhereClauseVariablesForSrcDataset(Map<String, String> additionalVariables, Dataset dataset, List<Partition> partitions, String suffix, SQLDialect dialect) throws IOException {
        if (partitions.size() == 0) {
            return;
        }
        if (partitions.size() >= 1 && partitions.get(0).getScheme() == null) {
            return;
        }
        ExpressionBuilder partitionClause = ExpressionUtils.getPartitionFilterClause(partitions.get(0).getScheme(), dataset, partitions, dialect);
        if (partitionClause != null) {
            additionalVariables.put("DKU_PARTITION_FILTER" + suffix, partitionClause.toSQL(dialect));
        }
    }
}

