/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.output.FSProviderOutput;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.SingleFileOutput;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class DirectoryAwareFSDatasetHandler<Config extends AbstractFSDatasetHandler.AbstractFSConfig>
extends AbstractFSDatasetHandler
implements FSDatasetBrowseService.BrowsableHandler {
    private final Config config;
    protected final Config resolvedConfig;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.ftplike");

    public DirectoryAwareFSDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
        this.config = (AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParams();
        this.resolvedConfig = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.deepCopy(this.config);
        ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).path = VariablesUtils.expand(dataset.getProjectKey(), ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).path, authCtx);
        VariablesUtils.expandListAllowUnresolved(dataset.getProjectKey(), ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).filesSelectionRules.explicitFiles);
        this.completeResolvedConfig(this.config, this.resolvedConfig);
    }

    protected void completeResolvedConfig(Config config, Config resolvedConfig) {
    }

    protected FSLikeFSProvider getTypedProvider() throws IOException, DKUSecurityException, CodedException {
        return (FSLikeFSProvider)this.getProvider();
    }

    protected abstract DSSConnection getConnection() throws IOException, DKUSecurityException;

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        this.checkConfiguration();
        ConnectionUtils.checkConnectionWritable(this.authCtx, ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).connection);
        if (this.isSingleFile()) {
            logger.info((Object)"Single-file output");
            OutputFormatter formatter = FormatFactory.buildFormatter(this.authCtx, this.dataset.getProjectKey(), this.dataset.getFormatType(), this.dataset.getFormatParams());
            formatter.setOutputSchema(this.dataset.getSchema());
            if (warningsContext != null) {
                formatter.setWarningsContext(warningsContext);
            }
            return new SingleFileOutput(this.getProvider(), this.getSingleFile(), formatter);
        }
        return new FSProviderOutput(this.authCtx, this.dataset.getProjectKey(), this.getProvider(), "", targetPartition, this.dataset.getPartitioningSchema(), targetSplit, resplitFactor, this.dataset.getFormatType(), this.dataset.getFormatParams(), this.dataset.getSchema(), warningsContext, this.dataset.getModel().readWriteOptions);
    }

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException, CodedException {
        this.getConnection();
    }

    @Override
    public void createManaged() throws Exception {
        if (this.isSingleFile()) {
            return;
        }
        ConnectionUtils.checkConnectionWritable(this.authCtx, ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).connection);
        this.checkClearIsNotDangerous();
        this.getTypedProvider().makeEmpty("/");
        this.invalidateRootEnumerationCache();
    }

    @Override
    public void clearAllData() throws Exception {
        logger.info((Object)"Clear all data");
        ConnectionUtils.checkConnectionWritable(this.authCtx, ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).connection);
        FSLikeFSProvider provider = this.getTypedProvider();
        this.checkClearIsNotDangerous();
        if (this.isManaged()) {
            if (provider.stat("/") != null) {
                provider.deleteRecursive("/");
            }
        } else if (this.isSingleFile()) {
            provider.makeEmpty(this.getSingleFile());
        } else {
            provider.makeEmpty("/");
        }
        this.invalidateRootEnumerationCache();
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)"Clear partitions");
        ConnectionUtils.checkConnectionWritable(this.authCtx, ((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).connection);
        FSLikeFSProvider provider = this.getTypedProvider();
        PartitioningScheme scheme = this.dataset.getPartitioningSchema();
        if (scheme != null && (!scheme.isPartitioned() || FilePartitioner.isSchemeRepresentableAsFolder(scheme))) {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition as a folder : '" + p.id() + "'"));
                String partitionPath = FilePartitioner.computePartitionRelPathAsFolder(p, this.dataset.getPartitioningSchema());
                this.clearOrEmptyPartitionPath(provider, partitionPath);
                logger.info((Object)("Done clearing partition '" + p.id() + "'"));
            }
        } else {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition as set of paths : '" + p.id() + "'"));
                List<FSPath> paths = this.enumeratePartition(p, this.getEnumerationSettings());
                this.clearOrEmptyPartitionPaths(provider, paths);
                logger.info((Object)("Done clearing partition '" + p.id() + "'"));
            }
        }
        this.invalidateRootEnumerationCache();
    }

    @Override
    public FSBrowsePath browse(String prefix) throws IOException, DKUSecurityException, CodedException {
        if (this.isSingleFile()) {
            return this.getProvider().browse("/" + this.getSingleFile(), FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
        }
        return this.getProvider().browse(prefix, FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY);
    }

    @Override
    public FSEnumerationSettings getEnumerationSettings() {
        FSEnumerationSettings enumerationSettings = new FSEnumerationSettings();
        enumerationSettings.selectionRules = (FilesSelectionRules)JSON.deepCopy((Object)((AbstractFSDatasetHandler.AbstractFSConfig)this.resolvedConfig).filesSelectionRules);
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForEverything(null, this.authCtx, this.dataset.getProjectKey());
        FSEnumerationSettings.expandSelectionRulesInPlace((FilesSelectionRules)enumerationSettings.selectionRules, (VariablesContext)vc);
        logger.trace((Object)("Variable-expanded selection rules: " + JSON.json((Object)enumerationSettings.selectionRules)));
        return enumerationSettings;
    }

    @Override
    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, DKUSecurityException, CodedException {
        logger.info((Object)("Enumerating Filesystem dataset prefix=" + prefix));
        if (this.isSingleFile()) {
            FSPathOrDirectory file = this.getProvider().stat(this.getSingleFile());
            return file == null ? null : Lists.newArrayList((Object[])new FSPath[]{file});
        }
        FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive(prefix, enumerationSettings);
        if (!enumerationResult.isSuccessful()) {
            throw new DataStoreIOException("Failed to list files", enumerationResult.getError());
        }
        if (!enumerationResult.enumerationPrefixExists()) {
            if (StringUtils.isBlank((String)prefix)) {
                throw new DataStoreIOException("Root path of the dataset " + this.dataset.getName() + " does not exist").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_ROOT_PATH_DOES_NOT_EXIST);
            }
            throw new DataStoreIOException("Path does not exist in the dataset " + this.dataset.getName() + ": '" + prefix + "'").withCode((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_PATH_DOES_NOT_EXIST);
        }
        return Lists.newArrayList((Iterable)enumerationResult.getPaths());
    }

    @Override
    public FSPath getFirstNonEmptyPath() throws Exception {
        logger.info((Object)"Finding first non empty path in dataset");
        if (this.isSingleFile()) {
            FSPathOrDirectory status = this.getProvider().stat("/" + this.getSingleFile());
            return status != null && status.getSize() > 0L ? status : null;
        }
        JsonObject jo = VariablesExpansionLoopItemsIterable.firstIterationOnlyFailIfNone(this.authCtx, this.dataset.getProjectKey(), this.dataset.getParamsAs(AbstractFSDatasetHandler.AbstractFSConfig.class).variablesExpansionLoopConfig, "Driving dataset is empty, cannot find file for preview");
        try (AutoCloseable ignored = DynamicLevelsStack.withLevel(jo);){
            FSEnumerationSettings enumerationSettings = this.getEnumerationSettings();
            enumerationSettings.firstNonEmpty = true;
            FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive("/", enumerationSettings);
            if (!enumerationResult.isSuccessful() || !enumerationResult.enumerationPrefixExists()) {
                FSPath fSPath = null;
                return fSPath;
            }
            Iterator paths = enumerationResult.getPaths().iterator();
            FSPath fSPath = paths.hasNext() ? (FSPath)paths.next() : null;
            return fSPath;
        }
    }

    @Override
    public EnrichedInputStream getStream(FSPath path, FilePartition partition) throws IOException, DKUSecurityException, CodedException {
        EnrichedInputStream ret = this.isSingleFile() ? this.getProvider().read(this.getSingleFile()) : this.getProvider().read(path.path());
        if (ret != null) {
            ret.setPartition((Partition)partition);
        }
        return ret;
    }

    @Override
    public String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException {
        if (this.isSingleFile()) {
            return this.getTypedProvider().getRoot() + "/" + this.getSingleFile();
        }
        return this.getTypedProvider().getRoot();
    }

    @Override
    public boolean executeFastPostCreateOperations() {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }
}

