/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderBuildersRegistry;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetMeta;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetParams;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDatasetTestHandler;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProviderDesc;
import com.dataiku.dip.datasets.fs.plugin.LoadedFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.fs.FilesSelectionRules;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.output.FSProviderOutput;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.SingleFileOutput;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.variables.VariablesUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomFSProviderDatasetHandler<Desc extends CustomFSProviderDesc>
extends AbstractFSDatasetHandler
implements AutoCloseable {
    private final LoadedFSProvider<Desc> desc;
    private final CustomFSProviderDatasetParams config;
    private final CustomFSProviderDatasetParams resolvedConfig;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.customfsprovider");

    public CustomFSProviderDatasetHandler(AuthCtx authCtx, LoadedFSProvider<Desc> desc, Dataset dataset) {
        super(authCtx, dataset);
        this.desc = desc;
        this.config = dataset.getParamsAs(CustomFSProviderDatasetParams.class);
        this.resolvedConfig = (CustomFSProviderDatasetParams)JSON.deepCopy((Object)this.config);
        this.resolvedConfig.path = VariablesUtils.expand(dataset.getProjectKey(), this.resolvedConfig.path);
    }

    protected FSProvider getTypedProvider() throws IOException, DKUSecurityException, CodedException {
        return this.getProvider();
    }

    public Desc getDesc() {
        return this.desc.desc;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return new CustomFSProviderDatasetMeta<Desc>(this.desc);
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String rawPath) throws IOException {
        String path = StringUtils.isBlank((String)rawPath) ? this.resolvedConfig.path : rawPath;
        FSProvider provider = CustomFSProviderBuildersRegistry.get(this.desc.fsProviderType).build(this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, path);
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, path);
    }

    @Override
    public String suggestName() {
        if (((CustomFSProviderDesc)this.desc.getDesc()).meta != null && StringUtils.isNotBlank((String)((CustomFSProviderDesc)this.desc.getDesc()).meta.label)) {
            return ((CustomFSProviderDesc)this.desc.getDesc()).meta.label;
        }
        return this.desc.id;
    }

    @Override
    public void checkConfiguration() throws IOException {
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    @Override
    public void createManaged() throws Exception {
        if (this.isSingleFile()) {
            throw new IOException("Object already exists !");
        }
    }

    @Override
    public void clearAllData() throws Exception {
        logger.info((Object)"Clear all data");
        FSProvider provider = this.getTypedProvider();
        if (this.isManaged()) {
            if (provider.stat("/") != null) {
                this.getProvider().deleteRecursive("/");
            }
        } else if (this.isSingleFile()) {
            this.getProvider().write(this.getSingleFile()).close();
        } else if (provider.stat("/") != null) {
            this.getProvider().deleteRecursive("/");
        }
        this.invalidateRootEnumerationCache();
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        logger.info((Object)"Clear partitions");
        ConnectionUtils.checkConnectionWritable(this.authCtx, this.resolvedConfig.connection);
        FSProvider provider = this.getTypedProvider();
        PartitioningScheme scheme = this.dataset.getPartitioningSchema();
        if (scheme != null && (!scheme.isPartitioned() || FilePartitioner.isSchemeRepresentableAsFolder(scheme))) {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition as a folder : '" + p.id() + "'"));
                String partitionPath = FilePartitioner.computePartitionRelPathAsFolder(p, this.dataset.getPartitioningSchema());
                this.clearPartitionPath(provider, partitionPath);
                logger.info((Object)("Done clearing partition '" + p.id() + "'"));
            }
        } else {
            for (Partition p : partitions) {
                logger.info((Object)("Clearing partition as set of paths : '" + p.id() + "'"));
                List<FSPath> paths = this.enumeratePartition(p, this.getEnumerationSettings());
                this.clearPartitionPaths(provider, paths);
                logger.info((Object)("Done clearing partition '" + p.id() + "'"));
            }
        }
        this.invalidateRootEnumerationCache();
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new CustomFSProviderDatasetTestHandler(this.authCtx, this.dataset, this);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        this.checkConfiguration();
        if (this.isSingleFile()) {
            logger.info((Object)"Single-file output");
            OutputFormatter formatter = FormatFactory.buildFormatter(this.authCtx, this.dataset.getProjectKey(), this.dataset.getFormatType(), this.dataset.getFormatParams());
            formatter.setOutputSchema(this.dataset.getSchema());
            if (warningsContext != null) {
                formatter.setWarningsContext(warningsContext);
            }
            return new SingleFileOutput(this.getProvider(), this.getSingleFile(), formatter);
        }
        return new FSProviderOutput(this.authCtx, this.dataset.getProjectKey(), this.getProvider(), "", targetPartition, this.dataset.getPartitioningSchema(), targetSplit, resplitFactor, this.dataset.getFormatType(), this.dataset.getFormatParams(), this.dataset.getSchema(), warningsContext, this.dataset.getModel().readWriteOptions);
    }

    @Override
    public FSEnumerationSettings getEnumerationSettings() {
        FSEnumerationSettings enumerationSettings = new FSEnumerationSettings();
        enumerationSettings.selectionRules = (FilesSelectionRules)JSON.deepCopy((Object)this.resolvedConfig.filesSelectionRules);
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForEverything(null, this.authCtx, this.dataset.getProjectKey());
        FSEnumerationSettings.expandSelectionRulesInPlace((FilesSelectionRules)enumerationSettings.selectionRules, (VariablesContext)vc);
        logger.trace((Object)("Variable-expanded selection rules: " + JSON.json((Object)enumerationSettings.selectionRules)));
        return enumerationSettings;
    }

    @Override
    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        logger.info((Object)("Enumerating Filesystem dataset prefix=" + prefix));
        if (this.isSingleFile()) {
            FSPathOrDirectory file = this.getProvider().stat(this.getSingleFile());
            if (file != null) {
                ArrayList ret = Lists.newArrayList();
                ret.add(file);
                return ret;
            }
            return null;
        }
        FSEnumerationResult enumerationResult = this.getProvider().enumerateRecursive(prefix, enumerationSettings);
        if (!enumerationResult.isSuccessful()) {
            return Lists.newArrayList();
        }
        if (!enumerationResult.enumerationPrefixExists()) {
            throw new FileNotFoundException("Nothing at path " + prefix);
        }
        return Lists.newArrayList((Iterable)enumerationResult.getPaths());
    }

    @Override
    public EnrichedInputStream getStream(FSPath path, FilePartition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        EnrichedInputStream ret = this.isSingleFile() ? this.getProvider().read(this.getSingleFile()) : this.getProvider().read(path.path());
        if (ret != null) {
            ret.setPartition((Partition)partition);
        }
        return ret;
    }

    @Override
    public String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException {
        if (this.desc.desc instanceof CustomPythonFSProviderDesc) {
            return null;
        }
        try {
            Map accessInfo = this.getTypedProvider().getAccessInfo(false);
            return accessInfo != null ? (String)accessInfo.get("root") : null;
        }
        catch (DKUSecurityException e) {
            throw new IOException("Failed to get root of dataset", e);
        }
    }
}

