/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.docextraction.DocExtractionServer;
import com.dataiku.dip.docextraction.StructuredContent;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.kernel.DSSKernelUtils;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.dataiku.dss.shadelib.org.apache.commons.codec.binary.Hex;
import com.dataiku.dss.shadelib.org.apache.commons.codec.digest.DigestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocExtractionKernelPool {
    @Autowired
    private CodeEnvResolutionService codeEnvResolutionService;
    private final KernelPool<DocExtractionServer, KernelDesc, KernelDesc> manager;
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("docextraction-kernel-pool-startstop-%d").build());
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.docextraction.pool");

    private static String getGroupKey(String containerConfName, String clusterId, String envName, DocExtractionServer.Settings settings) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        JSON.updateDigest((MessageDigest)digest, (Object)containerConfName);
        JSON.updateDigest((MessageDigest)digest, (Object)clusterId);
        JSON.updateDigest((MessageDigest)digest, (Object)envName);
        JSON.updateDigest((MessageDigest)digest, (Object)settings);
        return "docextraction-" + Hex.encodeHexString((byte[])digest.digest()).substring(0, 10);
    }

    private KernelDesc buildKernelDesc(AuthCtx authCtx, String projectKey, StructuredExtractor.StructuredExtractorSettings settings) throws IOException {
        KernelDesc kernelDesc = new KernelDesc();
        kernelDesc.cruContext = ComputeResourceUsageContext.forDocModel((String)projectKey);
        kernelDesc.projectKey = projectKey;
        kernelDesc.authCtx = authCtx;
        kernelDesc.settings = new DocExtractionServer.Settings();
        kernelDesc.settings.imageHandlingMode = settings.imageHandlingMode;
        kernelDesc.settings.ocrSettings = settings.ocrSettings;
        kernelDesc.envName = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings.getTextExtractionCodeEnv();
        try {
            ContainerExecSelection containerExecSelection = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings.documentExtractionContainerExecSelection;
            kernelDesc.containerConfName = new ContainerExecConfigSelector().selectName_autoTXN(projectKey, containerExecSelection, WorkloadType.VISUAL_RECIPES);
            kernelDesc.clusterId = new ClusterSelector().selectForProject(authCtx, projectKey).getClusterId();
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException(e);
        }
        this.codeEnvResolutionService.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, kernelDesc.envName);
        kernelDesc.hash = DocExtractionKernelPool.getGroupKey(kernelDesc.containerConfName, kernelDesc.clusterId, kernelDesc.envName, kernelDesc.settings);
        kernelDesc.cruContext = CurrentComputeResourceUsageContext.get();
        kernelDesc.jobContext = JobContext.getCurrentJobContext();
        return kernelDesc;
    }

    public StructuredContentResponse structuredExtractWithDocling(AuthCtx authCtx, String projectKey, StructuredExtractor.StructuredExtractorSettings structuredExtractorSettings, InputStream fileStream, String fileName, int timeoutInMinutes) throws Exception {
        String docContent = Base64.getEncoder().encodeToString(fileStream.readAllBytes());
        KernelDesc kernelDesc = this.buildKernelDesc(authCtx, projectKey, structuredExtractorSettings);
        StructuredExtractionCommand command = new StructuredExtractionCommand(docContent, fileName, structuredExtractorSettings);
        CompletableFuture future = this.manager.handle(kernel -> kernel.processAsync(command).orTimeout(timeoutInMinutes, TimeUnit.MINUTES), (Object)kernelDesc, kernelDesc.hash, (Object)command);
        return (StructuredContentResponse)DKUCompletableFuture.collectResponse((CompletableFuture)future);
    }

    public DocExtractionKernelPool() {
        this.manager = new KernelPool((KernelPool.KernelController)new KernelPool.KernelController<DocExtractionServer, KernelDesc, KernelDesc>(){

            @Nonnull
            public DocExtractionServer createKernel(KernelDesc kernelDesc) {
                return new DocExtractionServer(kernelDesc.authCtx, kernelDesc.envName, kernelDesc.projectKey, kernelDesc.containerConfName, kernelDesc.settings);
            }

            @Nonnull
            public CompletableFuture<Void> startKernel(DocExtractionServer kernel, KernelDesc kernelDesc) {
                return DKUCompletableFuture.runAsync(() -> {
                    NDC.push((String)("start-docextraction-kernel: " + kernel.getKernelId()));
                    try {
                        DSSKernelUtils.setKernelContext(kernelDesc.cruContext, kernelDesc.jobContext, logger);
                        kernel.start();
                    }
                    finally {
                        NDC.pop();
                    }
                }, (Executor)DocExtractionKernelPool.this.executorService);
            }

            public int getGlobalMaxKernelCount() {
                return ApplicationConfigurator.getParams().getIntParam("dku.docextraction.structured.maxKernels", Integer.valueOf(10));
            }

            public int getAutoscaleTimeWindowSeconds(KernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam("dku.docextraction.structured.autoscaleWindowSeconds", Integer.valueOf(600));
            }

            public int getHardMaxParallelRequests(KernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam("dku.docextraction.structured.hardMaxRequestsPerKernel", Integer.valueOf(4));
            }

            public int getSoftMaxParallelRequests(KernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam("dku.docextraction.structured.softMaxRequestsPerKernel", Integer.valueOf(4));
            }

            @Nonnull
            public CompletableFuture<Void> killKernel(DocExtractionServer kernel) {
                return CompletableFuture.runAsync(() -> {
                    NDC.push((String)("stop-docextraction-kernel: " + kernel.getKernelId()));
                    try {
                        kernel.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while closing kernel", (Throwable)e);
                    }
                    finally {
                        NDC.pop();
                    }
                }, DocExtractionKernelPool.this.executorService);
            }

            public boolean isAlive(DocExtractionServer kernel) {
                return kernel.isAlive();
            }

            public String getKernelId(DocExtractionServer kernel) {
                return kernel.getKernelId();
            }

            public boolean killKernelOnRequestFailure() {
                return super.killKernelOnRequestFailure();
            }
        }, "docextraction", logger);
    }

    public KernelPool.PoolDump dump(boolean full) {
        return this.manager.dump(full);
    }

    public void killAllRequests() {
        this.manager.killAllRequests();
    }

    public void killAllKernels(KernelPool.DeathReason reason) {
        this.manager.killAllKernels(reason);
    }

    public static class KernelDesc {
        String containerConfName;
        ComputeResourceUsageContext cruContext;
        JobContext jobContext;
        String projectKey;
        String clusterId;
        String hash;
        String envName;
        AuthCtx authCtx;
        DocExtractionServer.Settings settings;
    }

    public static class StructuredExtractionCommand {
        public final String type = "process-document";
        public String documentContent;
        public String fileName;
        public Integer maxSectionDepth;
        public StructuredExtractor.ImageHandlingMode imageHandlingMode;
        public StructuredExtractor.OCRSettings ocrSettings;

        StructuredExtractionCommand(String documentContent, String fileName, StructuredExtractor.StructuredExtractorSettings settings) {
            this.fileName = fileName;
            this.documentContent = documentContent;
            this.maxSectionDepth = settings.maxSectionDepth;
            this.imageHandlingMode = settings.imageHandlingMode;
            if (this.imageHandlingMode == StructuredExtractor.ImageHandlingMode.OCR) {
                this.ocrSettings = settings.ocrSettings;
            }
        }
    }

    public static class StructuredContentResponse {
        public StructuredContent resp;
        public boolean ok;
        public String error;
    }
}

