/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.computations.transformers;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.transformers.TransformedComputation;
import com.dataiku.dip.eda.compute.computations.transformers.Transformer;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.engine.WrappedComputationResultSession;

public class TransformingRunner
implements ComputationRunner {
    private final Transformer transformer;
    private final ComputationRunner runner;

    public TransformingRunner(Transformer transformer, ComputationRunner runner) {
        this.transformer = transformer;
        this.runner = runner;
    }

    @Override
    public ComputationResultSession computeAndOpenSession(Computation computation) throws Exception {
        TransformedComputation transformedComputation = this.transformer.transform(computation);
        ComputationResultSession session = this.runner.computeAndOpenSession(transformedComputation.computation);
        ComputationResult reconstructedResult = transformedComputation.reconstruct(session.getComputationResult());
        return new WrappedComputationResultSession(session, reconstructedResult);
    }

    @Override
    public boolean isAlive() {
        return this.runner.isAlive();
    }

    @Override
    public void close() throws Exception {
        this.runner.close();
    }
}

