/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.univariate_header;

import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithHighlight;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.utils.ImmutableValueObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class CategoricalHistogramCard
extends UnivariateCard
implements CardWithHighlight {
    public static final String TYPE = "categorical_histogram";
    int maxValues = 10;
    boolean groupOthers = false;
    @Nullable
    Filter highlightFilter;

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<GroupedComputation, GroupedComputation.GroupedComputationResult>(){

            @Override
            public GroupedComputation getComputationPlan() {
                return HistogramData.getComputationPlan(CategoricalHistogramCard.this.column.name, CategoricalHistogramCard.this.maxValues, CategoricalHistogramCard.this.groupOthers, CategoricalHistogramCard.this.highlightFilter);
            }

            @Override
            protected CardResult buildFromFullyAvailableResult(GroupedComputation.GroupedComputationResult result) {
                return new CategoricalHistogramCardResult(HistogramData.buildHistogramData(result));
            }
        };
    }

    @Override
    public void setHighlightFilter(Filter filter) {
        this.highlightFilter = filter;
    }

    public static class CategoricalHistogramCardResult
    extends CardResult {
        public HistogramData histogram;

        public CategoricalHistogramCardResult(HistogramData histogram) {
            this.histogram = histogram;
        }

        private CategoricalHistogramCardResult() {
        }
    }

    public static class HistogramData
    extends ImmutableValueObject {
        public List<Filter> filters;
        public long totalCount;
        public List<Long> counts;
        @Nullable
        public List<Long> highlightedCounts;

        public static GroupedComputation getComputationPlan(String column, Integer maxValues, boolean groupOthers, @Nullable Filter highlightFilter) {
            ArrayList<Grouping> subsets = new ArrayList<Grouping>();
            subsets.add(SubsetGrouping.all());
            if (highlightFilter != null) {
                subsets.add(new SubsetGrouping(highlightFilter));
            }
            return new GroupedComputation(new Count(), new UnionGrouping(new CrossGrouping(new UnionGrouping(subsets), new AnumGrouping(column, maxValues, groupOthers)), SubsetGrouping.all()));
        }

        public static HistogramData buildHistogramData(ComputationResult result) {
            boolean hasHighlighting;
            GroupedComputation.GroupedComputationResult groupResults = result.asGrouped();
            CrossGrouping.CrossGroupingResult crossResults = groupResults.groups.asUnion().groupings.get(0).asCross();
            HistogramData data = new HistogramData();
            data.filters = crossResults.groups.get(1).listFilters();
            data.counts = new ArrayList<Long>();
            boolean bl = hasHighlighting = crossResults.groups.get(0).size() > 1;
            if (hasHighlighting) {
                data.highlightedCounts = new ArrayList<Long>();
            }
            for (int i = 0; i < data.filters.size(); ++i) {
                long count = groupResults.results.get((int)i).as(Count.CountResult.class).count;
                data.counts.add(count);
                if (!hasHighlighting) continue;
                long highlightedCount = groupResults.results.get((int)(i + data.filters.size())).as(Count.CountResult.class).count;
                data.highlightedCounts.add(highlightedCount);
            }
            data.totalCount = groupResults.results.get((int)(groupResults.results.size() - 1)).as(Count.CountResult.class).count;
            return data;
        }
    }
}

