/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.experimenttracking;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.db.AbstractDSSDBService;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.experimenttracking.Experiment;
import com.dataiku.dip.experimenttracking.ExperimentTag;
import com.dataiku.dip.experimenttracking.ExperimentTrackingExportData;
import com.dataiku.dip.experimenttracking.ExperimentTrackingGarbageCollectionReport;
import com.dataiku.dip.experimenttracking.Model;
import com.dataiku.dip.experimenttracking.Run;
import com.dataiku.dip.experimenttracking.RunMetric;
import com.dataiku.dip.experimenttracking.RunParam;
import com.dataiku.dip.experimenttracking.RunStatus;
import com.dataiku.dip.experimenttracking.RunTag;
import com.dataiku.dip.experimenttracking.ViewType;
import com.dataiku.dip.experimenttracking.mlflowfilter.MLflowSearchExperimentsTranslator;
import com.dataiku.dip.experimenttracking.mlflowfilter.MLflowSearchRunsTranslator;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.sql.queries.InsertQueryBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.security.InvalidParameterException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ExperimentTrackingInternalDBNoCreate
extends AbstractDSSDBService {
    private static final int SCHEMA_VERSION = 2;
    private static final String DB_NAME = "experiments";
    private static final String DEFAULT_EXPERIMENT_ID = "0";
    private static final String DEFAULT_EXPERIMENT_NAME = "Default";
    public static final String EXPERIMENTS_TABLE = "EXPERIMENTS";
    public static final String RUNS_TABLE = "RUNS";
    public static final String PARAMETERS_TABLE = "PARAMETERS";
    public static final String METRICS_TABLE = "METRICS";
    public static final String RUN_TAGS_TABLE = "RUN_TAGS";
    public static final String EXPERIMENT_TAGS_TABLE = "EXP_TAGS";
    public static final String MODELS_TABLE = "MODELS";
    public static final String EXPERIMENT_PROJECT_KEY_FIELD = "EXP_PROJECT_KEY";
    public static final String EXPERIMENT_ID_FIELD = "EXP_ID";
    public static final String EXPERIMENT_NAME_FIELD = "EXP_NAME";
    private static final String EXPERIMENT_ARTIFACT_LOCATION_FIELD = "EXP_ARTIFACT_LOCATION";
    public static final String EXPERIMENT_LIFE_CYCLE_STAGE_FIELD = "EXP_LIFECYCLE_STAGE";
    public static final String EXPERIMENT_LAST_UPDATE_FIELD = "EXP_LAST_UPDATE";
    public static final String EXPERIMENT_CREATION_FIELD = "EXP_CREATION";
    public static final String RUN_PROJECT_KEY_FIELD = "RUN_PROJECT_KEY";
    public static final String RUN_UUID_FIELD = "RUN_UUID";
    public static final String RUN_EXPERIMENT_ID_FIELD = "RUN_EXP_ID";
    public static final String RUN_START_TIME_FIELD = "RUN_START_TIME";
    public static final String RUN_END_TIME_FIELD = "RUN_END_TIME";
    public static final String RUN_USER_ID_FIELD = "RUN_USER_ID";
    public static final String RUN_STATUS_FIELD = "RUN_STATUS";
    public static final String RUN_ARTIFACT_URI_FIELD = "RUN_ARTIFACT_URI";
    public static final String RUN_LIFECYCLE_STAGE_FIELD = "RUN_LIFECYCLE_STAGE";
    public static final String RUN_ID_FIELD = "RUN_ID";
    public static final String PARAMETER_PROJECT_KEY_FIELD = "PARAM_PROJECT_KEY";
    private static final String PARAMETER_RUN_UUID_FIELD = "PARAM_RUN_UUID";
    public static final String PARAMETER_RUN_ID_FIELD = "PARAM_RUN_ID";
    public static final String PARAMETER_KEY_FIELD = "PARAM_KEY";
    public static final String PARAMETER_VALUE_FIELD = "PARAM_VALUE";
    public static final String METRIC_PROJECT_KEY_FIELD = "METRIC_PROJECT_KEY";
    private static final String METRIC_RUN_UUID_FIELD = "METRIC_RUN_UUID";
    public static final String METRIC_RUN_ID_FIELD = "METRIC_RUN_ID";
    public static final String METRIC_KEY_FIELD = "METRIC_KEY";
    public static final String METRIC_VALUE_FIELD = "METRIC_VALUE";
    private static final String METRIC_TIMESTAMP_FIELD = "METRIC_TIMESTAMP";
    private static final String METRIC_STEP_FIELD = "METRIC_STEP";
    public static final String TAG_PROJECT_KEY_FIELD = "TAG_PROJECT_KEY";
    private static final String TAG_RUN_UUID_FIELD = "TAG_RUN_UUID";
    public static final String TAG_RUN_ID_FIELD = "TAG_RUN_ID";
    public static final String TAG_EXPERIMENT_ID_FIELD = "TAG_EXP_ID";
    public static final String TAG_KEY_FIELD = "TAG_KEY";
    public static final String TAG_VALUE_FIELD = "TAG_VALUE";
    private static final String MODEL_PROJECT_KEY_FIELD = "MODEL_PROJECT_KEY";
    private static final String MODEL_RUN_UUID_FIELD = "MODEL_RUN_UUID";
    private static final String MODEL_RUN_ID_FIELD = "MODEL_RUN_ID";
    private static final String MODEL_ARTIFACT_PATH_FIELD = "MODEL_ARTIFACT_PATH";
    private static final SchemaColumn EXPERIMENT_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("EXP_PROJECT_KEY", Type.STRING);
    private static final SchemaColumn EXPERIMENT_ID_SCHEMA_COLUMN = new SchemaColumn("EXP_ID", Type.STRING);
    private static final SchemaColumn EXPERIMENT_NAME_SCHEMA_COLUMN = new SchemaColumn("EXP_NAME", Type.STRING);
    private static final SchemaColumn EXPERIMENT_ARTIFACT_LOCATION_COLUMN = new SchemaColumn("EXP_ARTIFACT_LOCATION", Type.STRING);
    private static final SchemaColumn EXPERIMENT_LIFECYCLE_STAGE_COLUMN = new SchemaColumn("EXP_LIFECYCLE_STAGE", Type.STRING);
    private static final SchemaColumn EXPERIMENT_LAST_UPDATE_COLUMN = new SchemaColumn("EXP_LAST_UPDATE", Type.STRING);
    private static final SchemaColumn EXPERIMENT_CREATION_COLUMN = new SchemaColumn("EXP_CREATION", Type.STRING);
    static final SchemaColumn[] EXPERIMENT_COLUMNS = new SchemaColumn[]{EXPERIMENT_PROJECT_KEY_SCHEMA_COLUMN, EXPERIMENT_ID_SCHEMA_COLUMN, EXPERIMENT_NAME_SCHEMA_COLUMN, EXPERIMENT_ARTIFACT_LOCATION_COLUMN, EXPERIMENT_LIFECYCLE_STAGE_COLUMN, EXPERIMENT_LAST_UPDATE_COLUMN, EXPERIMENT_CREATION_COLUMN};
    static final String[] EXPERIMENTS_INDEX_KEYS = new String[]{"EXP_PROJECT_KEY", "EXP_ID"};
    private static final SchemaColumn RUN_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("RUN_PROJECT_KEY", Type.STRING);
    private static final SchemaColumn RUN_UUID_SCHEMA_COLUMN = new SchemaColumn("RUN_UUID", Type.STRING);
    private static final SchemaColumn RUN_EXPERIMENT_ID_SCHEMA_COLUMN = new SchemaColumn("RUN_EXP_ID", Type.STRING);
    private static final SchemaColumn RUN_START_TIME_SCHEMA_COLUMN = new SchemaColumn("RUN_START_TIME", Type.BIGINT);
    private static final SchemaColumn RUN_END_TIME_SCHEMA_COLUMN = new SchemaColumn("RUN_END_TIME", Type.BIGINT);
    private static final SchemaColumn RUN_USER_ID_SCHEMA_COLUMN = new SchemaColumn("RUN_USER_ID", Type.STRING);
    private static final SchemaColumn RUN_STATUS_SCHEMA_COLUMN = new SchemaColumn("RUN_STATUS", Type.STRING);
    private static final SchemaColumn RUN_ARTIFACT_URI_SCHEMA_COLUMN = new SchemaColumn("RUN_ARTIFACT_URI", Type.STRING);
    private static final SchemaColumn RUN_LIFECYCLE_STAGE_SCHEMA_COLUMN = new SchemaColumn("RUN_LIFECYCLE_STAGE", Type.STRING);
    private static final SchemaColumn RUN_ID_SCHEMA_COLUMN = new SchemaColumn("RUN_ID", Type.STRING);
    public static final SchemaColumn[] RUN_COLUMNS = new SchemaColumn[]{RUN_PROJECT_KEY_SCHEMA_COLUMN, RUN_EXPERIMENT_ID_SCHEMA_COLUMN, RUN_UUID_SCHEMA_COLUMN, RUN_ID_SCHEMA_COLUMN, RUN_START_TIME_SCHEMA_COLUMN, RUN_END_TIME_SCHEMA_COLUMN, RUN_STATUS_SCHEMA_COLUMN, RUN_USER_ID_SCHEMA_COLUMN, RUN_ARTIFACT_URI_SCHEMA_COLUMN, RUN_LIFECYCLE_STAGE_SCHEMA_COLUMN};
    static final String[] RUNS_INDEX_KEYS = new String[]{"RUN_PROJECT_KEY", "RUN_ID"};
    private static final SchemaColumn PARAM_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("PARAM_PROJECT_KEY", Type.STRING);
    private static final SchemaColumn PARAM_RUN_UUID_SCHEMA_COLUMN = new SchemaColumn("PARAM_RUN_UUID", Type.STRING);
    private static final SchemaColumn PARAM_RUN_ID_SCHEMA_COLUMN = new SchemaColumn("PARAM_RUN_ID", Type.STRING);
    private static final SchemaColumn PARAM_KEY_SCHEMA_COLUMN = new SchemaColumn("PARAM_KEY", Type.STRING);
    private static final SchemaColumn PARAM_VALUE_SCHEMA_COLUMN = new SchemaColumn("PARAM_VALUE", Type.STRING);
    static final SchemaColumn[] PARAMETERS_COLUMNS = new SchemaColumn[]{PARAM_PROJECT_KEY_SCHEMA_COLUMN, PARAM_RUN_UUID_SCHEMA_COLUMN, PARAM_RUN_ID_SCHEMA_COLUMN, PARAM_KEY_SCHEMA_COLUMN, PARAM_VALUE_SCHEMA_COLUMN};
    static final String[] PARAMETERS_INDEX_KEYS = new String[]{"PARAM_PROJECT_KEY", "PARAM_RUN_ID", "PARAM_KEY"};
    private static final SchemaColumn TAGS_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("TAG_PROJECT_KEY", Type.STRING);
    private static final SchemaColumn TAGS_RUN_UUID_SCHEMA_COLUMN = new SchemaColumn("TAG_RUN_UUID", Type.STRING);
    private static final SchemaColumn TAGS_RUN_ID_SCHEMA_COLUMN = new SchemaColumn("TAG_RUN_ID", Type.STRING);
    private static final SchemaColumn TAGS_EXPERIMENT_ID_SCHEMA_COLUMN = new SchemaColumn("TAG_EXP_ID", Type.STRING);
    private static final SchemaColumn TAGS_KEY_SCHEMA_COLUMN = new SchemaColumn("TAG_KEY", Type.STRING);
    private static final SchemaColumn TAGS_VALUE_SCHEMA_COLUMN = new SchemaColumn("TAG_VALUE", Type.STRING);
    static final SchemaColumn[] RUN_TAGS_COLUMNS = new SchemaColumn[]{TAGS_PROJECT_KEY_SCHEMA_COLUMN, TAGS_RUN_UUID_SCHEMA_COLUMN, TAGS_RUN_ID_SCHEMA_COLUMN, TAGS_KEY_SCHEMA_COLUMN, TAGS_VALUE_SCHEMA_COLUMN};
    static final SchemaColumn[] EXPERIMENT_TAGS_COLUMNS = new SchemaColumn[]{TAGS_PROJECT_KEY_SCHEMA_COLUMN, TAGS_EXPERIMENT_ID_SCHEMA_COLUMN, TAGS_KEY_SCHEMA_COLUMN, TAGS_VALUE_SCHEMA_COLUMN};
    static final String[] RUN_TAGS_INDEX_KEYS = new String[]{"TAG_PROJECT_KEY", "TAG_RUN_ID", "TAG_KEY"};
    static final String[] EXPERIMENT_TAGS_INDEX_KEYS = new String[]{"TAG_PROJECT_KEY", "TAG_EXP_ID", "TAG_KEY"};
    private static final SchemaColumn METRIC_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("METRIC_PROJECT_KEY", Type.STRING);
    private static final SchemaColumn METRIC_RUN_UUID_SCHEMA_COLUMN = new SchemaColumn("METRIC_RUN_UUID", Type.STRING);
    private static final SchemaColumn METRIC_RUN_ID_SCHEMA_COLUMN = new SchemaColumn("METRIC_RUN_ID", Type.STRING);
    private static final SchemaColumn METRIC_KEY_SCHEMA_COLUMN = new SchemaColumn("METRIC_KEY", Type.STRING);
    private static final SchemaColumn METRIC_VALUE_SCHEMA_COLUMN = new SchemaColumn("METRIC_VALUE", Type.DOUBLE);
    private static final SchemaColumn METRIC_TIMESTAMP_SCHEMA_COLUMN = new SchemaColumn("METRIC_TIMESTAMP", Type.BIGINT);
    private static final SchemaColumn METRIC_STEP_SCHEMA_COLUMN = new SchemaColumn("METRIC_STEP", Type.BIGINT);
    static final SchemaColumn[] METRICS_COLUMNS = new SchemaColumn[]{METRIC_PROJECT_KEY_SCHEMA_COLUMN, METRIC_RUN_UUID_SCHEMA_COLUMN, METRIC_RUN_ID_SCHEMA_COLUMN, METRIC_KEY_SCHEMA_COLUMN, METRIC_VALUE_SCHEMA_COLUMN, METRIC_TIMESTAMP_SCHEMA_COLUMN, METRIC_STEP_SCHEMA_COLUMN};
    static final String[] METRICS_INDEX_KEYS = new String[]{"METRIC_PROJECT_KEY", "METRIC_RUN_ID", "METRIC_KEY", "METRIC_STEP", "METRIC_TIMESTAMP"};
    private static final SchemaColumn MODEL_PROJECT_KEY_SCHEMA_COLUMN = new SchemaColumn("MODEL_PROJECT_KEY", Type.STRING);
    private static final SchemaColumn MODEL_RUN_UUID_SCHEMA_COLUMN = new SchemaColumn("MODEL_RUN_UUID", Type.STRING);
    private static final SchemaColumn MODEL_RUN_ID_SCHEMA_COLUMN = new SchemaColumn("MODEL_RUN_ID", Type.STRING);
    private static final SchemaColumn MODEL_ARTIFACT_PATH_SCHEMA_COLUMN = new SchemaColumn("MODEL_ARTIFACT_PATH", Type.STRING);
    static final SchemaColumn[] MODELS_COLUMNS = new SchemaColumn[]{MODEL_PROJECT_KEY_SCHEMA_COLUMN, MODEL_RUN_UUID_SCHEMA_COLUMN, MODEL_RUN_ID_SCHEMA_COLUMN, MODEL_ARTIFACT_PATH_SCHEMA_COLUMN};
    static final String[] MODELS_UNIQUE_ARTIFACT_PATH_INDEX_KEYS = new String[]{"MODEL_PROJECT_KEY", "MODEL_RUN_UUID", "MODEL_ARTIFACT_PATH"};
    static final String[] MODELS_INDEX_KEYS = new String[]{"MODEL_PROJECT_KEY", "MODEL_RUN_UUID"};
    private final String insertExperiment = InsertQueryBuilder.insertInto(this.resolveTable("EXPERIMENTS")).addColumns(EXPERIMENT_COLUMNS).toSQL(this.getDialect());
    private final String updateExperimentSetLifecycle = "UPDATE " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " SET " + this.quote("EXP_LAST_UPDATE") + "=?, " + this.quote("EXP_LIFECYCLE_STAGE") + "=? WHERE " + this.quote("EXP_PROJECT_KEY") + "=? AND " + this.quote("EXP_ID") + "=?";
    private final String updateExperimentSetName = "UPDATE " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " SET " + this.quote("EXP_LAST_UPDATE") + "=?, " + this.quote("EXP_NAME") + "=? WHERE " + this.quote("EXP_PROJECT_KEY") + "=? AND " + this.quote("EXP_ID") + "=?";
    private final String getExperiment = "SELECT * FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " WHERE " + this.quote("EXP_PROJECT_KEY") + "=? AND " + this.quote("EXP_ID") + "=?";
    private final String getExperimentByName = "SELECT * FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " WHERE " + this.quote("EXP_PROJECT_KEY") + "=? AND " + this.quote("EXP_NAME") + "=?";
    private final String listExperiments = "SELECT *, (SELECT COUNT(*) FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("EXP_ID") + "=" + this.quote("RUN_EXP_ID") + " AND " + this.quote("EXP_PROJECT_KEY") + " = " + this.quote("RUN_PROJECT_KEY") + ") AS " + this.quote("RUN_COUNT") + ", (SELECT MAX(" + this.quote("RUN_START_TIME") + ") FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("EXP_ID") + "=" + this.quote("RUN_EXP_ID") + " AND " + this.quote("EXP_PROJECT_KEY") + " = " + this.quote("RUN_PROJECT_KEY") + ") AS " + this.quote("LAST_RUN") + " FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " WHERE " + this.quote("EXP_PROJECT_KEY") + "=?  ORDER BY " + this.quote("EXP_CREATION") + " DESC LIMIT ?";
    private final String getProjectExperimentIds = "SELECT " + this.quote("EXP_ID") + " FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " WHERE " + this.quote("EXP_PROJECT_KEY") + "=?  ORDER BY " + this.quote("EXP_CREATION") + " DESC";
    private final String countAllExperiments = "SELECT COUNT(*) AS " + this.quote("EXPERIMENT_COUNT") + " FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS");
    private final String deleteExperimentsForProject = "DELETE FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " WHERE " + this.quote("EXP_PROJECT_KEY") + "=?";
    private final String deleteDeletedExperiments = "DELETE FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " WHERE " + this.quote("EXP_PROJECT_KEY") + "=? AND " + this.quote("EXP_LIFECYCLE_STAGE") + "=" + this.quoteString("deleted");
    private final String insertRun = InsertQueryBuilder.insertInto(this.resolveTable("RUNS")).addColumns(RUN_COLUMNS).toSQL(this.getDialect());
    private final String getRun = "SELECT * FROM " + this.getQuotedFullResolvedTableName("RUNS") + "," + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " WHERE " + this.quote("RUN_PROJECT_KEY") + "=? AND " + this.quote("RUN_ID") + "=? AND " + this.quote("EXP_ID") + "=" + this.quote("RUN_EXP_ID") + " AND " + this.quote("RUN_PROJECT_KEY") + "=" + this.quote("EXP_PROJECT_KEY");
    private final String getProjectRunIds = "SELECT " + this.quote("RUN_ID") + " FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("RUN_PROJECT_KEY") + "=?  ORDER BY " + this.quote("RUN_START_TIME") + " DESC";
    private final String getRuns = "SELECT * FROM " + this.getQuotedFullResolvedTableName("RUNS") + " r  INNER JOIN " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " e  ON e." + this.quote("EXP_ID") + "=r." + this.quote("RUN_EXP_ID") + " AND e." + this.quote("EXP_PROJECT_KEY") + "=r." + this.quote("RUN_PROJECT_KEY") + " WHERE " + this.quote("RUN_PROJECT_KEY") + "=? AND " + this.quote("RUN_ID") + " IN(:runsList:) ORDER BY r." + this.quote("RUN_START_TIME") + " DESC";
    private final String getExperiments = "SELECT * FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " e  WHERE " + this.quote("EXP_PROJECT_KEY") + "=? AND " + this.quote("EXP_ID") + " IN(:experimentsList:) ORDER BY e." + this.quote("EXP_CREATION") + " DESC";
    private final String updateRunSetStatusEndTime = "UPDATE " + this.getQuotedFullResolvedTableName("RUNS") + " SET " + this.quote("RUN_STATUS") + "=?, " + this.quote("RUN_END_TIME") + "=?  WHERE " + this.quote("RUN_PROJECT_KEY") + "=? AND " + this.quote("RUN_ID") + "=?";
    private final String updateRunSetLifecycle = "UPDATE " + this.getQuotedFullResolvedTableName("RUNS") + " SET " + this.quote("RUN_LIFECYCLE_STAGE") + "=?  WHERE " + this.quote("RUN_PROJECT_KEY") + "=? AND " + this.quote("RUN_ID") + "=?";
    private final String deleteRunsForProject = "DELETE FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("RUN_PROJECT_KEY") + " =?";
    private final String updateRunSetStatusDeletedForDeletedExperiments = "UPDATE " + this.getQuotedFullResolvedTableName("RUNS") + " SET " + this.quote("RUN_LIFECYCLE_STAGE") + "=" + this.quoteString("deleted") + " WHERE " + this.quote("RUN_EXP_ID") + " IN (SELECT " + this.quote("EXP_ID") + " FROM " + this.getQuotedFullResolvedTableName("EXPERIMENTS") + " WHERE " + this.quote("EXP_PROJECT_KEY") + "=?  AND " + this.quote("EXP_LIFECYCLE_STAGE") + "=" + this.quoteString("deleted") + ")";
    private final String deleteDeletedRuns = "DELETE FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("RUN_PROJECT_KEY") + " =? AND " + this.quote("RUN_LIFECYCLE_STAGE") + "=" + this.quoteString("deleted");
    private final String updateExperimentRunsSetLifecycle = "UPDATE " + this.getQuotedFullResolvedTableName("RUNS") + " SET " + this.quote("RUN_LIFECYCLE_STAGE") + "=? WHERE " + this.quote("RUN_PROJECT_KEY") + " =? AND " + this.quote("RUN_EXP_ID") + " =?";
    private final String insertParam = InsertQueryBuilder.insertInto(this.resolveTable("PARAMETERS")).addColumns(PARAMETERS_COLUMNS).toSQL(this.getDialect());
    private final String getParam = "SELECT * FROM " + this.getQuotedFullResolvedTableName("PARAMETERS") + " WHERE " + this.quote("PARAM_PROJECT_KEY") + "=? AND " + this.quote("PARAM_RUN_ID") + "=? AND " + this.quote("PARAM_KEY") + "=?";
    private final String getRunParams = "SELECT * FROM " + this.getQuotedFullResolvedTableName("PARAMETERS") + " WHERE " + this.quote("PARAM_PROJECT_KEY") + "=? AND " + this.quote("PARAM_RUN_ID") + "=?";
    private final String getRunsParams = "SELECT * FROM " + this.getQuotedFullResolvedTableName("PARAMETERS") + " WHERE " + this.quote("PARAM_PROJECT_KEY") + "=? AND " + this.quote("PARAM_RUN_ID") + " IN (:runsList:)";
    private final String deleteParamsForProject = "DELETE FROM " + this.getQuotedFullResolvedTableName("PARAMETERS") + " WHERE " + this.quote("PARAM_PROJECT_KEY") + " =?";
    private final String deleteDeletedRunsParams = "DELETE FROM " + this.getQuotedFullResolvedTableName("PARAMETERS") + " WHERE " + this.quote("PARAM_PROJECT_KEY") + "=? AND " + this.quote("PARAM_RUN_ID") + " IN (SELECT " + this.quote("RUN_ID") + " FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("RUN_LIFECYCLE_STAGE") + "=" + this.quoteString("deleted") + ")";
    private final String insertMetric = InsertQueryBuilder.insertInto(this.resolveTable("METRICS")).addColumns(METRICS_COLUMNS).toSQL(this.getDialect());
    private final String getMetric = "SELECT * FROM " + this.getQuotedFullResolvedTableName("METRICS") + " WHERE " + this.quote("METRIC_PROJECT_KEY") + "=? AND " + this.quote("METRIC_RUN_ID") + "=? AND " + this.quote("METRIC_KEY") + "=? AND " + this.quote("METRIC_STEP") + "=? AND " + this.quote("METRIC_TIMESTAMP") + "=?";
    private final String updateMetric = "UPDATE " + this.getQuotedFullResolvedTableName("METRICS") + " SET " + this.quote("METRIC_VALUE") + "=?  WHERE " + this.quote("METRIC_PROJECT_KEY") + "=? AND " + this.quote("METRIC_RUN_ID") + "=? AND " + this.quote("METRIC_KEY") + "=? AND " + this.quote("METRIC_STEP") + "=? AND " + this.quote("METRIC_TIMESTAMP") + "=?";
    private final String getRunMetrics = "SELECT * FROM " + this.getQuotedFullResolvedTableName("METRICS") + " WHERE " + this.quote("METRIC_PROJECT_KEY") + "=? AND " + this.quote("METRIC_RUN_ID") + "=? ORDER BY " + this.quote("METRIC_KEY") + ", " + this.quote("METRIC_TIMESTAMP");
    private final String getRunsMetrics = "SELECT * FROM " + this.getQuotedFullResolvedTableName("METRICS") + " WHERE " + this.quote("METRIC_PROJECT_KEY") + "=? AND " + this.quote("METRIC_RUN_ID") + " IN (:runsList:) ORDER BY " + this.quote("METRIC_KEY") + ", " + this.quote("METRIC_TIMESTAMP");
    private final String getRunMetric = "SELECT * FROM " + this.getQuotedFullResolvedTableName("METRICS") + " WHERE " + this.quote("METRIC_PROJECT_KEY") + "=? AND " + this.quote("METRIC_RUN_ID") + "=? AND " + this.quote("METRIC_KEY") + "=? ORDER BY " + this.quote("METRIC_STEP") + ", " + this.quote("METRIC_TIMESTAMP");
    private final String deleteMetricsForProject = "DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS") + " WHERE " + this.quote("METRIC_PROJECT_KEY") + " =?";
    private final String deleteDeletedRunsMetrics = "DELETE FROM " + this.getQuotedFullResolvedTableName("METRICS") + " WHERE " + this.quote("METRIC_PROJECT_KEY") + "=? AND " + this.quote("METRIC_RUN_ID") + " IN (SELECT " + this.quote("RUN_ID") + " FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("RUN_LIFECYCLE_STAGE") + "=" + this.quoteString("deleted") + ")";
    private final String insertRunTag = InsertQueryBuilder.insertInto(this.resolveTable("RUN_TAGS")).addColumns(RUN_TAGS_COLUMNS).toSQL(this.getDialect());
    private final String getRunTag = "SELECT * FROM " + this.getQuotedFullResolvedTableName("RUN_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + "=? AND " + this.quote("TAG_RUN_ID") + "=? AND " + this.quote("TAG_KEY") + "=?";
    private final String updateRunTag = "UPDATE " + this.getQuotedFullResolvedTableName("RUN_TAGS") + " SET " + this.quote("TAG_VALUE") + "=? WHERE " + this.quote("TAG_PROJECT_KEY") + " =? AND " + this.quote("TAG_RUN_ID") + " =? AND " + this.quote("TAG_KEY") + " =?";
    private final String getRunTags = "SELECT * FROM " + this.getQuotedFullResolvedTableName("RUN_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + " =? AND " + this.quote("TAG_RUN_ID") + " =?";
    private final String getRunsTags = "SELECT * FROM " + this.getQuotedFullResolvedTableName("RUN_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + " =? AND " + this.quote("TAG_RUN_ID") + " IN (:runsList:)";
    private final String insertExperimentTag = InsertQueryBuilder.insertInto(this.resolveTable("EXP_TAGS")).addColumns(EXPERIMENT_TAGS_COLUMNS).toSQL(this.getDialect());
    private final String getExperimentTag = "SELECT * FROM " + this.getQuotedFullResolvedTableName("EXP_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + "=? AND " + this.quote("TAG_EXP_ID") + "=? AND " + this.quote("TAG_KEY") + "=?";
    private final String updateExperimentTag = "UPDATE " + this.getQuotedFullResolvedTableName("EXP_TAGS") + " SET " + this.quote("TAG_VALUE") + "=? WHERE " + this.quote("TAG_PROJECT_KEY") + " =? AND " + this.quote("TAG_EXP_ID") + " =? AND " + this.quote("TAG_KEY") + " =?";
    private final String getExperimentTags = "SELECT * FROM " + this.getQuotedFullResolvedTableName("EXP_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + " =? AND " + this.quote("TAG_EXP_ID") + " =?";
    private final String getExperimentsTags = "SELECT * FROM " + this.getQuotedFullResolvedTableName("EXP_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + " =? AND " + this.quote("TAG_EXP_ID") + " IN (:experimentsList:)";
    private final String deleteRunTag = "DELETE FROM " + this.getQuotedFullResolvedTableName("RUN_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + " =? AND " + this.quote("TAG_RUN_ID") + " =? AND " + this.quote("TAG_KEY") + " =?";
    private final String deleteTagsForProject = "DELETE FROM " + this.getQuotedFullResolvedTableName("RUN_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + " =?";
    private final String deleteDeletedRunsTags = "DELETE FROM " + this.getQuotedFullResolvedTableName("RUN_TAGS") + " WHERE " + this.quote("TAG_PROJECT_KEY") + "=? AND " + this.quote("TAG_RUN_ID") + " IN (SELECT " + this.quote("RUN_ID") + " FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("RUN_LIFECYCLE_STAGE") + "=" + this.quoteString("deleted") + ")";
    private final String insertModel = InsertQueryBuilder.insertInto(this.resolveTable("MODELS")).addColumns(MODELS_COLUMNS).toSQL(this.getDialect());
    private final String listRunModels = "SELECT * FROM " + this.getQuotedFullResolvedTableName("MODELS") + " WHERE " + this.quote("MODEL_PROJECT_KEY") + "=? AND " + this.quote("MODEL_RUN_ID") + "=?";
    private final String listRunsModels = "SELECT * FROM " + this.getQuotedFullResolvedTableName("MODELS") + " WHERE " + this.quote("MODEL_PROJECT_KEY") + "=? AND " + this.quote("MODEL_RUN_ID") + " IN (:runsList:)";
    private final String getModel = "SELECT * FROM " + this.getQuotedFullResolvedTableName("MODELS") + " WHERE " + this.quote("MODEL_PROJECT_KEY") + "=? AND " + this.quote("MODEL_RUN_ID") + "=? AND " + this.quote("MODEL_ARTIFACT_PATH") + "=?";
    private final String deleteModelsForProject = "DELETE FROM " + this.getQuotedFullResolvedTableName("MODELS") + " WHERE " + this.quote("MODEL_PROJECT_KEY") + " =?";
    private final String deleteDeletedModels = "DELETE FROM " + this.getQuotedFullResolvedTableName("MODELS") + " WHERE " + this.quote("MODEL_PROJECT_KEY") + "=? AND " + this.quote("MODEL_RUN_ID") + " IN (SELECT " + this.quote("RUN_ID") + " FROM " + this.getQuotedFullResolvedTableName("RUNS") + " WHERE " + this.quote("RUN_LIFECYCLE_STAGE") + "=" + this.quoteString("deleted") + ")";
    private final String getProjectModels = "SELECT * FROM " + this.getQuotedFullResolvedTableName("MODELS") + " WHERE " + this.quote("MODEL_PROJECT_KEY") + "=?";
    public static final List<String> TABLES = ImmutableList.of((Object)"EXPERIMENTS", (Object)"RUNS", (Object)"PARAMETERS", (Object)"METRICS", (Object)"RUN_TAGS", (Object)"EXP_TAGS", (Object)"MODELS");
    private static final int MAX_ID_LENGTH = 19;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.mlflow.db");

    public ExperimentTrackingInternalDBNoCreate() {
        super(ApplicationConfigurator.getDatabaseFile(DB_NAME), DB_NAME, DB_NAME, 2, true);
    }

    @Override
    protected void initDB(int currentSchemaVersion, DSSDBConnection conn) throws SQLException {
        assert (false);
    }

    public Experiment getOrCreateDefaultExperiment(String artifactsRoot, String projectKey) throws SQLException, NotFoundException {
        try {
            Experiment experiment = this.getExperimentByName(projectKey, DEFAULT_EXPERIMENT_NAME);
            if (StringUtils.equals((String)experiment.lifecycleStage, (String)"active")) {
                return experiment;
            }
        }
        catch (NotFoundException experiment) {
            // empty catch block
        }
        String experimentId = this.createExperiment(artifactsRoot, projectKey, DEFAULT_EXPERIMENT_NAME, null, null);
        return this.getExperiment(projectKey, experimentId);
    }

    public String createExperiment(String artifactsRoot, String projectKey, String name, String artifactLocation, List<ExperimentTag> tags) throws SQLException {
        try {
            Experiment experiment = this.getExperimentByName(projectKey, name);
            if (StringUtils.equals((String)experiment.lifecycleStage, (String)"active")) {
                throw new InvalidParameterException("An active experiment named " + name + " already exists");
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return this.realCreateExperiment(artifactsRoot, projectKey, name, artifactLocation, tags);
    }

    protected String realCreateExperiment(String artifactsRoot, String projectKey, String name, String artifactLocation, List<ExperimentTag> tags) throws SQLException {
        String experimentId;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"Experiment name can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            long timeMillis = System.currentTimeMillis();
            experimentId = this.generateExperimentId(conn, projectKey, name, timeMillis);
            if (StringUtils.isEmpty((String)artifactLocation)) {
                artifactLocation = artifactsRoot + "/" + experimentId;
            }
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertExperiment);
            ps2.setString(++i, projectKey);
            ps2.setString(++i, experimentId);
            ps2.setString(++i, name);
            ps2.setString(++i, (String)artifactLocation);
            ps2.setString(++i, "active");
            if (CollectionUtils.isNotEmpty(tags)) {
                for (ExperimentTag tag : tags) {
                    this.insertUpdateExperimentTag(conn, projectKey, experimentId, tag.key, tag.value);
                }
            }
            ps2.setLong(++i, timeMillis);
            ps2.setLong(++i, timeMillis);
            ps2.execute();
            conn.commit();
        }
        return experimentId;
    }

    public void updateExperimentLifecycleSetDeleted(String projectKey, String experimentId) throws SQLException {
        this.updateExperimentLifecycle(projectKey, experimentId, "deleted");
    }

    public void updateExperimentLifecycleSetActive(String projectKey, String experimentId) throws SQLException, NotFoundException {
        try (DSSDBConnection conn = this.acquireConnection();){
            Experiment experiment = this.getExperiment(conn, projectKey, experimentId);
            if (StringUtils.equals((String)experiment.lifecycleStage, (String)"active")) {
                return;
            }
            try {
                Experiment byName = this.getExperimentByName(conn, projectKey, experiment.name);
                if (StringUtils.equals((String)byName.lifecycleStage, (String)"active") && !StringUtils.equals((String)byName.id, (String)experimentId)) {
                    throw new InvalidParameterException("Experiment " + String.valueOf(byName) + " bears the same name " + experiment.name + " and is active");
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            this.updateExperimentLifecycle(projectKey, experimentId, "active");
        }
    }

    protected void updateExperimentLifecycle(String projectKey, String experimentId, String lifecycleStage) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateExperimentSetLifecycle);
            long timeMillis = System.currentTimeMillis();
            ps2.setLong(1, timeMillis);
            ps2.setString(2, lifecycleStage);
            ps2.setString(3, projectKey);
            ps2.setString(4, experimentId);
            ps2.execute();
            ps2 = this.getPreparedStatement(conn, this.updateExperimentRunsSetLifecycle);
            ps2.setString(1, lifecycleStage);
            ps2.setString(2, projectKey);
            ps2.setString(3, experimentId);
            ps2.execute();
            conn.commit();
        }
    }

    public void updateExperimentSetName(String projectKey, String experimentId, String name) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            try {
                Experiment e = this.getExperimentByName(conn, projectKey, name);
                if (StringUtils.equals((String)e.lifecycleStage, (String)"active") && !StringUtils.equals((String)e.id, (String)experimentId)) {
                    throw new InvalidParameterException("Experiment " + e.id + " already bears name " + name + " and is active");
                }
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateExperimentSetName);
            long timeMillis = System.currentTimeMillis();
            ps2.setLong(++i, timeMillis);
            ps2.setString(++i, name);
            ps2.setString(++i, projectKey);
            ps2.setString(++i, experimentId);
            ps2.execute();
            conn.commit();
        }
    }

    public Experiment getExperiment(String projectKey, String experimentId) throws SQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)experimentId), (Object)"Experiment id can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            Experiment experiment = this.getExperiment(conn, projectKey, experimentId);
            return experiment;
        }
    }

    protected Experiment getExperiment(DSSDBConnection conn, String projectKey, String experimentId) throws SQLException, NotFoundException {
        Experiment experiment = this.getExperimentOrNull(conn, projectKey, experimentId);
        if (experiment == null) {
            throw new NotFoundException("Experiment not found: " + experimentId);
        }
        return experiment;
    }

    protected Experiment getExperimentOrNull(DSSDBConnection conn, String projectKey, String experimentId) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getExperiment);
        ps2.setString(1, projectKey);
        ps2.setString(2, experimentId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                Experiment experiment = this.readExperiment(conn, rs2, projectKey, false);
                return experiment;
            }
            Experiment experiment = null;
            return experiment;
        }
    }

    public Experiment getExperimentByName(String projectKey, String experimentName) throws SQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)experimentName), (Object)"Experiment name can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            Experiment experiment = this.getExperimentByName(conn, projectKey, experimentName);
            return experiment;
        }
    }

    protected Experiment getExperimentByName(DSSDBConnection conn, String projectKey, String experimentName) throws SQLException, NotFoundException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getExperimentByName);
        ps2.setString(1, projectKey);
        ps2.setString(2, experimentName);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            Experiment current = null;
            while (rs2.next()) {
                current = this.readExperiment(conn, rs2, projectKey, false);
                if (!StringUtils.equals((String)current.lifecycleStage, (String)"active")) continue;
                Experiment experiment = current;
                return experiment;
            }
            if (null != current) {
                Experiment experiment = current;
                return experiment;
            }
            throw new NotFoundException("Experiment not found: " + experimentName);
        }
    }

    private Experiment readExperiment(DSSDBConnection conn, ResultSet rs2, String projectKey, boolean retrieveExtensions) throws SQLException {
        Experiment experiment = new Experiment();
        experiment.id = rs2.getString(EXPERIMENT_ID_FIELD);
        experiment.name = rs2.getString(EXPERIMENT_NAME_FIELD);
        String artifactLocation = rs2.getString(EXPERIMENT_ARTIFACT_LOCATION_FIELD);
        if (!StringUtils.isEmpty((String)artifactLocation)) {
            experiment.artifactLocation = artifactLocation;
        }
        experiment.tags = this.getExperimentTags(conn, projectKey, experiment.id);
        if (retrieveExtensions) {
            experiment.tags.add(new ExperimentTag("dku-ext.experimentName", rs2.getString(EXPERIMENT_NAME_FIELD)));
            experiment.tags.add(new ExperimentTag("dku-ext.experimentRunCount", rs2.getString("RUN_COUNT")));
            try {
                experiment.tags.add(new ExperimentTag("dku-ext.experimentLastRunStart", rs2.getString("LAST_RUN")));
            }
            catch (Exception e) {
                logger.trace((Object)("Experiment " + experiment.id + " has no runs"));
            }
        }
        experiment.lifecycleStage = rs2.getString(EXPERIMENT_LIFE_CYCLE_STAGE_FIELD);
        experiment.creationTime = rs2.getLong(EXPERIMENT_CREATION_FIELD);
        experiment.lastUpdateTime = rs2.getLong(EXPERIMENT_LAST_UPDATE_FIELD);
        return experiment;
    }

    public List<Experiment> listExperiments(String projectKey, long maxResults, ViewType viewType, boolean retrieveExtensions) throws SQLException {
        if (maxResults > 100000L) {
            logger.warn((Object)"listExperiments: maxResults reduced to 100000");
            maxResults = 100000L;
        }
        maxResults = Math.min(maxResults, 100000L);
        ArrayList<Experiment> ret = new ArrayList<Experiment>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.listExperiments);
            ps2.setString(1, projectKey);
            ps2.setLong(2, maxResults);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    Experiment experiment = this.readExperiment(conn, rs2, projectKey, retrieveExtensions);
                    switch (viewType) {
                        case ALL: {
                            ret.add(experiment);
                            break;
                        }
                        case ACTIVE_ONLY: {
                            if (!StringUtils.equals((String)experiment.lifecycleStage, (String)"active")) break;
                            ret.add(experiment);
                            break;
                        }
                        case DELETED_ONLY: {
                            if (!StringUtils.equals((String)experiment.lifecycleStage, (String)"deleted")) break;
                            ret.add(experiment);
                        }
                    }
                }
            }
        }
        return ret;
    }

    public int countAllExperiments() throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            int n;
            block12: {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.countAllExperiments);
                ps2.execute();
                ResultSet rs2 = ps2.getResultSet();
                try {
                    rs2.next();
                    n = rs2.getInt("EXPERIMENT_COUNT");
                    if (rs2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs2.close();
            }
            return n;
        }
    }

    private Object getTagValue(List<RunTag> tags, String key) {
        return tags.stream().filter(elem -> StringUtils.equals((String)elem.key, (String)key)).findFirst().map(elem -> elem != null ? elem.value : null).orElse(null);
    }

    public Run createRun(String artifactsRoot, String projectKey, String experimentId, String userId, long startTime, List<RunTag> tags) throws SQLException, NotFoundException {
        String artifactURI;
        String runId;
        Experiment experiment;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)experimentId), (Object)"Experiment id can not be empty");
        RunStatus status = RunStatus.RUNNING;
        try {
            experiment = this.getExperiment(projectKey, experimentId);
        }
        catch (NotFoundException e) {
            if (!DEFAULT_EXPERIMENT_ID.equals(experimentId)) {
                throw e;
            }
            experiment = this.getOrCreateDefaultExperiment(artifactsRoot, projectKey);
        }
        try (DSSDBConnection conn = this.acquireConnection();){
            runId = this.generateRunId(conn, projectKey, tags, startTime);
            artifactURI = experiment.artifactLocation + "/" + runId + "/artifacts";
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.insertRun);
            ps2.setString(++i, projectKey);
            ps2.setString(++i, experiment.id);
            ps2.setString(++i, runId);
            ps2.setString(++i, runId);
            ps2.setLong(++i, startTime);
            ps2.setLong(++i, 0L);
            ps2.setString(++i, status.toString());
            ps2.setString(++i, userId);
            ps2.setString(++i, artifactURI);
            ps2.setString(++i, "active");
            if (CollectionUtils.isNotEmpty(tags)) {
                for (RunTag tag : tags) {
                    this.insertUpdateRunTag(conn, projectKey, runId, runId, tag.key, tag.value);
                }
            }
            ps2.execute();
            conn.commit();
        }
        Run run = new Run();
        run.info.runId = runId;
        run.info.runUuid = runId;
        run.info.startTime = startTime;
        run.info.status = status;
        run.info.userId = userId;
        run.info.experimentId = experiment.id;
        run.info.artifactUri = artifactURI;
        run.info.lifecycleStage = "active";
        if (CollectionUtils.isNotEmpty(tags)) {
            run.data.runTags = tags.stream().map(dssTag -> new RunTag(dssTag.key, dssTag.value)).collect(Collectors.toList());
            run.info.runName = (String)this.getTagValue(tags, "mlflow.runName");
        }
        return run;
    }

    static String generateId(String name, long startTime, Predicate<String> isUnique) {
        String candidateId = (name = StringUtils.isEmpty((String)name) ? DKUDateUtils.isoFormatLocal((long)startTime) : name.toLowerCase(Locale.ROOT)).replaceAll("[^\\w]", "_");
        if (candidateId.length() > 19) {
            candidateId = candidateId.substring(0, 19);
        }
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        String finalId = candidateId;
        while (!isUnique.test(finalId)) {
            String moreUniqueId = candidateId + "_" + SecretKeyGenerator.generate((int)3);
            finalId = transmogrifier.transmogrify(moreUniqueId);
        }
        return finalId;
    }

    private String generateExperimentId(DSSDBConnection conn, String projectKey, String name, long startTime) {
        return ExperimentTrackingInternalDBNoCreate.generateId(name, startTime, candidateId -> {
            try {
                return this.getExperimentOrNull(conn, projectKey, (String)candidateId) == null;
            }
            catch (Exception e) {
                logger.error((Object)"Error while generating experiment id.", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    private String generateRunId(DSSDBConnection conn, String projectKey, List<RunTag> tags, long startTime) {
        return ExperimentTrackingInternalDBNoCreate.generateId(this.getRunNameFromTags(tags), startTime, candidateId -> {
            try {
                return this.getRunOrNull(conn, projectKey, (String)candidateId, false) == null;
            }
            catch (Exception e) {
                logger.error((Object)"Error while generating experiment id.", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    private String getRunNameFromTags(List<RunTag> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            return null;
        }
        RunTag nameTag = tags.stream().filter(tag -> "mlflow.runName".equals(tag.key)).findFirst().orElse(null);
        if (nameTag == null) {
            return null;
        }
        return nameTag.value;
    }

    private List<RunMetric> getRunMetrics(DSSDBConnection conn, String projectKey, String runId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRunMetrics);
        int i = 0;
        ps2.setString(++i, projectKey);
        ps2.setString(++i, runId);
        ps2.execute();
        ArrayList<RunMetric> ret = new ArrayList<RunMetric>();
        try (ResultSet rs2 = ps2.getResultSet();){
            while (rs2.next()) {
                ret.add(new RunMetric(rs2.getString(METRIC_KEY_FIELD), rs2.getDouble(METRIC_VALUE_FIELD), rs2.getLong(METRIC_STEP_FIELD), rs2.getLong(METRIC_TIMESTAMP_FIELD)));
            }
        }
        return ret;
    }

    public List<RunMetric> getMetricHistory(String projectKey, String runId, String metricKey) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)metricKey), (Object)"metricKey can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRunMetric);
            int i = 0;
            ps2.setString(++i, projectKey);
            ps2.setString(++i, runId);
            ps2.setString(++i, metricKey);
            ps2.execute();
            ArrayList<RunMetric> ret = new ArrayList<RunMetric>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    ret.add(new RunMetric(rs2.getString(METRIC_KEY_FIELD), rs2.getDouble(METRIC_VALUE_FIELD), rs2.getLong(METRIC_STEP_FIELD), rs2.getLong(METRIC_TIMESTAMP_FIELD)));
                }
            }
            ArrayList<RunMetric> arrayList = ret;
            return arrayList;
        }
    }

    private List<RunParam> getRunParams(DSSDBConnection conn, String projectKey, String runId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRunParams);
        int i = 0;
        ps2.setString(++i, projectKey);
        ps2.setString(++i, runId);
        ps2.execute();
        ArrayList<RunParam> ret = new ArrayList<RunParam>();
        try (ResultSet rs2 = ps2.getResultSet();){
            while (rs2.next()) {
                ret.add(new RunParam(rs2.getString(PARAMETER_KEY_FIELD), rs2.getString(PARAMETER_VALUE_FIELD)));
            }
        }
        return ret;
    }

    private List<RunTag> getRunTags(DSSDBConnection conn, String projectKey, String runId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRunTags);
        int i = 0;
        ps2.setString(++i, projectKey);
        ps2.setString(++i, runId);
        ps2.execute();
        ArrayList<RunTag> ret = new ArrayList<RunTag>();
        try (ResultSet rs2 = ps2.getResultSet();){
            while (rs2.next()) {
                ret.add(new RunTag(rs2.getString(TAG_KEY_FIELD), rs2.getString(TAG_VALUE_FIELD)));
            }
        }
        return ret;
    }

    private List<ExperimentTag> getExperimentTags(DSSDBConnection conn, String projectKey, String experimentId) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)experimentId), (Object)"runId can not be empty");
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getExperimentTags);
        int i = 0;
        ps2.setString(++i, projectKey);
        ps2.setString(++i, experimentId);
        ps2.execute();
        ArrayList<ExperimentTag> ret = new ArrayList<ExperimentTag>();
        try (ResultSet rs2 = ps2.getResultSet();){
            while (rs2.next()) {
                ret.add(new ExperimentTag(rs2.getString(TAG_KEY_FIELD), rs2.getString(TAG_VALUE_FIELD)));
            }
        }
        return ret;
    }

    public Run updateRunStatusEndTime(String projectKey, String runId, String status, long endTime) throws SQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)status), (Object)"status can not be empty");
        Preconditions.checkArgument((endTime >= 0L ? 1 : 0) != 0, (Object)"end of time can not be negative");
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateRunSetStatusEndTime);
            ps2.setString(++i, status);
            ps2.setLong(++i, endTime);
            ps2.setString(++i, projectKey);
            ps2.setString(++i, runId);
            ps2.execute();
            conn.commit();
        }
        return this.getRun(projectKey, runId, false);
    }

    public Run updateRunLifecycle(String projectKey, String runId, String lifecycleStage) throws SQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)lifecycleStage), (Object)"lifecycleStage can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            int i = 0;
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.updateRunSetLifecycle);
            ps2.setString(++i, lifecycleStage);
            ps2.setString(++i, projectKey);
            ps2.setString(++i, runId);
            ps2.execute();
            conn.commit();
        }
        return this.getRun(projectKey, runId, false);
    }

    public void setRunTag(String projectKey, String runUUID, String runId, String key, String value) throws SQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            this.getRun(conn, projectKey, runId, false);
            this.insertUpdateRunTag(conn, projectKey, runUUID, runId, key, value);
            conn.commit();
        }
    }

    public void setExperimentTag(String projectKey, String experimentId, String key, String value) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)experimentId), (Object)"experimentI can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            this.insertUpdateExperimentTag(conn, projectKey, experimentId, key, value);
            conn.commit();
        }
    }

    public void deleteRunTag(String projectKey, String runId, String key) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement psDelete = this.getPreparedStatement(conn, this.deleteRunTag);
            int i = 0;
            psDelete.setString(++i, projectKey);
            psDelete.setString(++i, runId);
            psDelete.setString(++i, key);
            psDelete.execute();
            conn.commit();
        }
    }

    public Run getRun(String projectKey, String runId, boolean fullRun) throws SQLException, NotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            Run run = this.getRun(conn, projectKey, runId, fullRun);
            return run;
        }
    }

    private Run getRun(DSSDBConnection conn, String projectKey, String runId, boolean fullRun) throws SQLException, NotFoundException {
        Run run = this.getRunOrNull(conn, projectKey, runId, fullRun);
        if (run == null) {
            throw new NotFoundException("Run not found: " + runId);
        }
        return run;
    }

    private Run getRunOrNull(DSSDBConnection conn, String projectKey, String runId, boolean fullRun) throws SQLException {
        int i = 0;
        PreparedStatement ps2 = this.getPreparedStatement(conn, this.getRun);
        ps2.setString(++i, projectKey);
        ps2.setString(++i, runId);
        ps2.execute();
        try (ResultSet rs2 = ps2.getResultSet();){
            if (rs2.next()) {
                Run run = new Run();
                run.info.runId = runId;
                run.info.experimentId = rs2.getString(RUN_EXPERIMENT_ID_FIELD);
                run.info.runUuid = rs2.getString(RUN_UUID_FIELD);
                run.info.startTime = rs2.getLong(RUN_START_TIME_FIELD);
                run.info.endTime = rs2.getLong(RUN_END_TIME_FIELD);
                run.info.status = RunStatus.valueOf(rs2.getString(RUN_STATUS_FIELD));
                run.info.artifactUri = rs2.getString(RUN_ARTIFACT_URI_FIELD);
                run.info.userId = rs2.getString(RUN_USER_ID_FIELD);
                run.info.lifecycleStage = rs2.getString(RUN_LIFECYCLE_STAGE_FIELD);
                run.data.runTags = this.getRunTags(conn, projectKey, runId);
                run.data.runTags.add(new RunTag("dku-ext.experimentName", rs2.getString(EXPERIMENT_NAME_FIELD)));
                if (fullRun) {
                    run.data.metrics = this.getRunMetrics(conn, projectKey, runId);
                    run.data.runParams = this.getRunParams(conn, projectKey, runId);
                }
                run.info.runName = (String)this.getTagValue(run.data.runTags, "mlflow.runName");
                Run run2 = run;
                return run2;
            }
            Run run = null;
            return run;
        }
    }

    public List<Run> getProjectRuns(String projectKey, boolean retrieveExtensions) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getProjectRunIds);
            ps2.setString(1, projectKey);
            ps2.execute();
            ArrayList<String> runIds = new ArrayList<String>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    runIds.add(rs2.getString(RUN_ID_FIELD));
                }
            }
            List<Run> list = this.getRuns(conn, projectKey, runIds, retrieveExtensions);
            return list;
        }
    }

    public List<Experiment> getProjectExperiments(String projectKey, boolean retrieveExtensions) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getProjectExperimentIds);
            ps2.setString(1, projectKey);
            ps2.execute();
            ArrayList<String> experimentIds = new ArrayList<String>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    experimentIds.add(rs2.getString(EXPERIMENT_ID_FIELD));
                }
            }
            List<Experiment> list = this.getExperiments(conn, projectKey, experimentIds, retrieveExtensions);
            return list;
        }
    }

    private String getRunIdsAsINString(List<String> runIds) {
        return StringUtils.join((Collection)runIds.stream().map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.toList()), (String)",");
    }

    private String getExperimentIdsAsINString(List<String> experimentIds) {
        return StringUtils.join((Collection)experimentIds.stream().map(x$0 -> this.quoteString((String)x$0)).collect(Collectors.toList()), (String)",");
    }

    private List<Run> getRuns(DSSDBConnection conn, String projectKey, List<String> runIds, boolean retrieveExtensions) throws SQLException {
        if (CollectionUtils.isEmpty(runIds)) {
            return new ArrayList<Run>();
        }
        HashMap mapTags = new HashMap();
        HashMap mapMetrics = new HashMap();
        HashMap mapParams = new HashMap();
        HashMap<String, Run> mapRuns = new HashMap<String, Run>();
        for (List runIdsChunk : Lists.partition(runIds, (int)30000)) {
            String runId;
            String runIdsAsINString = this.getRunIdsAsINString(runIdsChunk);
            PreparedStatement psTags = this.getPreparedStatement(conn, this.getRunsTags.replace(":runsList:", runIdsAsINString));
            psTags.setString(1, projectKey);
            psTags.execute();
            try (ResultSet rsTags = psTags.getResultSet();){
                while (rsTags.next()) {
                    runId = rsTags.getString(TAG_RUN_ID_FIELD);
                    String tagKey = rsTags.getString(TAG_KEY_FIELD);
                    String tagValue = rsTags.getString(TAG_VALUE_FIELD);
                    if (!mapTags.containsKey(runId)) {
                        mapTags.put(runId, new ArrayList());
                    }
                    ((List)mapTags.get(runId)).add(new RunTag(tagKey, tagValue));
                }
            }
            PreparedStatement psMetrics = this.getPreparedStatement(conn, this.getRunsMetrics.replace(":runsList:", runIdsAsINString));
            psMetrics.setString(1, projectKey);
            psMetrics.execute();
            try (ResultSet rsMetrics = psMetrics.getResultSet();){
                while (rsMetrics.next()) {
                    runId = rsMetrics.getString(METRIC_RUN_ID_FIELD);
                    String metricKey = rsMetrics.getString(METRIC_KEY_FIELD);
                    double metricValue = rsMetrics.getDouble(METRIC_VALUE_FIELD);
                    long metricTS = rsMetrics.getLong(METRIC_TIMESTAMP_FIELD);
                    long metricStep = rsMetrics.getLong(METRIC_STEP_FIELD);
                    if (!mapMetrics.containsKey(runId)) {
                        mapMetrics.put(runId, new ArrayList());
                    }
                    ((List)mapMetrics.get(runId)).add(new RunMetric(metricKey, metricValue, metricStep, metricTS));
                }
            }
            PreparedStatement psParams = this.getPreparedStatement(conn, this.getRunsParams.replace(":runsList:", runIdsAsINString));
            psParams.setString(1, projectKey);
            psParams.execute();
            try (ResultSet rsParams = psParams.getResultSet();){
                while (rsParams.next()) {
                    runId = rsParams.getString(PARAMETER_RUN_ID_FIELD);
                    String parameterKey = rsParams.getString(PARAMETER_KEY_FIELD);
                    String parameterValue = rsParams.getString(PARAMETER_VALUE_FIELD);
                    if (!mapParams.containsKey(runId)) {
                        mapParams.put(runId, new ArrayList());
                    }
                    ((List)mapParams.get(runId)).add(new RunParam(parameterKey, parameterValue));
                }
            }
            PreparedStatement psRuns = this.getPreparedStatement(conn, this.getRuns.replace(":runsList:", runIdsAsINString));
            psRuns.setString(1, projectKey);
            psRuns.execute();
            ResultSet rs2 = psRuns.getResultSet();
            try {
                while (rs2.next()) {
                    runId = rs2.getString(RUN_ID_FIELD);
                    Run run = new Run();
                    run.info.runId = runId;
                    run.info.experimentId = rs2.getString(RUN_EXPERIMENT_ID_FIELD);
                    run.info.runUuid = rs2.getString(RUN_UUID_FIELD);
                    run.info.startTime = rs2.getLong(RUN_START_TIME_FIELD);
                    run.info.endTime = rs2.getLong(RUN_END_TIME_FIELD);
                    run.info.status = RunStatus.valueOf(rs2.getString(RUN_STATUS_FIELD));
                    run.info.artifactUri = rs2.getString(RUN_ARTIFACT_URI_FIELD);
                    run.info.userId = rs2.getString(RUN_USER_ID_FIELD);
                    run.info.lifecycleStage = rs2.getString(RUN_LIFECYCLE_STAGE_FIELD);
                    ArrayList<RunTag> tagsList = (ArrayList<RunTag>)mapTags.get(runId);
                    if (null == tagsList) {
                        tagsList = new ArrayList<RunTag>();
                    }
                    if (retrieveExtensions) {
                        tagsList.add(new RunTag("dku-ext.experimentName", rs2.getString(EXPERIMENT_NAME_FIELD)));
                    }
                    run.data.runTags = tagsList;
                    run.info.runName = (String)this.getTagValue(run.data.runTags, "mlflow.runName");
                    if (mapMetrics.containsKey(runId)) {
                        run.data.metrics = (List)mapMetrics.get(runId);
                    }
                    if (mapParams.containsKey(runId)) {
                        run.data.runParams = (List)mapParams.get(runId);
                    }
                    mapRuns.put(runId, run);
                }
            }
            finally {
                if (rs2 == null) continue;
                rs2.close();
            }
        }
        return runIds.stream().map(mapRuns::get).collect(Collectors.toList());
    }

    private List<Experiment> getExperiments(DSSDBConnection conn, String projectKey, List<String> experimentIds, boolean retrieveExtensions) throws SQLException {
        if (CollectionUtils.isEmpty(experimentIds)) {
            return new ArrayList<Experiment>();
        }
        HashMap mapTags = new HashMap();
        HashMap<String, Experiment> mapExperiments = new HashMap<String, Experiment>();
        for (List experimentIdsChunk : Lists.partition(experimentIds, (int)30000)) {
            String experimentId;
            String experimentIdsAsINString = this.getExperimentIdsAsINString(experimentIdsChunk);
            PreparedStatement psTags = this.getPreparedStatement(conn, this.getExperimentsTags.replace(":experimentsList:", experimentIdsAsINString));
            psTags.setString(1, projectKey);
            psTags.execute();
            try (ResultSet rsTags = psTags.getResultSet();){
                while (rsTags.next()) {
                    experimentId = rsTags.getString(TAG_EXPERIMENT_ID_FIELD);
                    String tagKey = rsTags.getString(TAG_KEY_FIELD);
                    String tagValue = rsTags.getString(TAG_VALUE_FIELD);
                    if (!mapTags.containsKey(experimentId)) {
                        mapTags.put(experimentId, new ArrayList());
                    }
                    ((List)mapTags.get(experimentId)).add(new ExperimentTag(tagKey, tagValue));
                }
            }
            PreparedStatement psExperiments = this.getPreparedStatement(conn, this.getExperiments.replace(":experimentsList:", experimentIdsAsINString));
            psExperiments.setString(1, projectKey);
            psExperiments.execute();
            ResultSet rs2 = psExperiments.getResultSet();
            try {
                while (rs2.next()) {
                    experimentId = rs2.getString(EXPERIMENT_ID_FIELD);
                    Experiment experiment = new Experiment();
                    experiment.id = experimentId;
                    experiment.name = rs2.getString(EXPERIMENT_NAME_FIELD);
                    experiment.artifactLocation = rs2.getString(EXPERIMENT_ARTIFACT_LOCATION_FIELD);
                    experiment.lastUpdateTime = rs2.getLong(EXPERIMENT_LAST_UPDATE_FIELD);
                    experiment.creationTime = rs2.getLong(EXPERIMENT_CREATION_FIELD);
                    experiment.lifecycleStage = rs2.getString(EXPERIMENT_LIFE_CYCLE_STAGE_FIELD);
                    ArrayList<ExperimentTag> tagsList = (ArrayList<ExperimentTag>)mapTags.get(experimentId);
                    if (null == tagsList) {
                        tagsList = new ArrayList<ExperimentTag>();
                    }
                    if (retrieveExtensions) {
                        tagsList.add(new ExperimentTag("dku-ext.experimentName", rs2.getString(EXPERIMENT_NAME_FIELD)));
                    }
                    experiment.tags = tagsList;
                    mapExperiments.put(experimentId, experiment);
                }
            }
            finally {
                if (rs2 == null) continue;
                rs2.close();
            }
        }
        return experimentIds.stream().map(mapExperiments::get).collect(Collectors.toList());
    }

    public void insertParameter(String projectKey, String runUUID, String runId, String key, String value) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            this.insertParameter(conn, projectKey, runId, runUUID, key, value);
            conn.commit();
        }
    }

    private void insertParameter(DSSDBConnection conn, String projectKey, String runId, String runUUID, String key, String value) throws SQLException {
        PreparedStatement psGet = this.getPreparedStatement(conn, this.getParam);
        psGet.setString(1, projectKey);
        psGet.setString(2, runId);
        psGet.setString(3, key);
        psGet.execute();
        try (ResultSet rs2 = psGet.getResultSet();){
            if (rs2.next()) {
                throw new InvalidParameterException("Changing param values is not allowed. Param with key='" + key + " was already logged with value='" + rs2.getString(PARAMETER_VALUE_FIELD) + "' for run ID='" + runId + "'. Attempted logging new value '" + value + "'.");
            }
            PreparedStatement psInsert = this.getPreparedStatement(conn, this.insertParam);
            psInsert.setString(1, projectKey);
            psInsert.setString(2, runUUID);
            psInsert.setString(3, runId);
            psInsert.setString(4, key);
            psInsert.setString(5, value);
            psInsert.execute();
        }
    }

    public void insertUpdateMetric(String projectKey, String runUUID, String runId, String key, Double value, long timestamp, long step) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            this.insertUpdateMetric(conn, projectKey, runUUID, runId, key, value, timestamp, step);
            conn.commit();
        }
    }

    private void insertUpdateMetric(DSSDBConnection conn, String projectKey, String runUUID, String runId, String key, Double value, long timestamp, long step) throws SQLException {
        PreparedStatement psGet = this.getPreparedStatement(conn, this.getMetric);
        psGet.setString(1, projectKey);
        psGet.setString(2, runId);
        psGet.setString(3, key);
        psGet.setLong(4, step);
        psGet.setLong(5, timestamp);
        psGet.execute();
        try (ResultSet rs2 = psGet.getResultSet();){
            if (rs2.next()) {
                PreparedStatement psUpdate = this.getPreparedStatement(conn, this.updateMetric);
                psUpdate.setDouble(1, value);
                psUpdate.setString(2, projectKey);
                psUpdate.setString(3, runId);
                psUpdate.setString(4, key);
                psUpdate.setLong(5, step);
                psUpdate.setLong(6, timestamp);
                psUpdate.execute();
            } else {
                PreparedStatement psInsert = this.getPreparedStatement(conn, this.insertMetric);
                psInsert.setString(1, projectKey);
                psInsert.setString(2, runUUID);
                psInsert.setString(3, runId);
                psInsert.setString(4, key);
                psInsert.setDouble(5, value);
                psInsert.setLong(6, timestamp);
                psInsert.setLong(7, step);
                psInsert.execute();
            }
        }
    }

    private void insertUpdateRunTag(DSSDBConnection conn, String projectKey, String runUUID, String runId, String key, String value) throws SQLException {
        PreparedStatement psGet = this.getPreparedStatement(conn, this.getRunTag);
        psGet.setString(1, projectKey);
        psGet.setString(2, runId);
        psGet.setString(3, key);
        psGet.execute();
        try (ResultSet rs2 = psGet.getResultSet();){
            if (rs2.next()) {
                PreparedStatement psUpdate = this.getPreparedStatement(conn, this.updateRunTag);
                psUpdate.setString(1, value);
                psUpdate.setString(2, projectKey);
                psUpdate.setString(3, runId);
                psUpdate.setString(4, key);
                psUpdate.execute();
            } else {
                PreparedStatement psInsert = this.getPreparedStatement(conn, this.insertRunTag);
                psInsert.setString(1, projectKey);
                psInsert.setString(2, runUUID);
                psInsert.setString(3, runId);
                psInsert.setString(4, key);
                psInsert.setString(5, value);
                psInsert.execute();
            }
        }
    }

    void insertUpdateExperimentTag(DSSDBConnection conn, String projectKey, String experimentId, String key, String value) throws SQLException {
        PreparedStatement psGet = this.getPreparedStatement(conn, this.getExperimentTag);
        psGet.setString(1, projectKey);
        psGet.setString(2, experimentId);
        psGet.setString(3, key);
        psGet.execute();
        try (ResultSet rs2 = psGet.getResultSet();){
            if (rs2.next()) {
                PreparedStatement psUpdate = this.getPreparedStatement(conn, this.updateExperimentTag);
                psUpdate.setString(1, value);
                psUpdate.setString(2, projectKey);
                psUpdate.setString(3, experimentId);
                psUpdate.setString(4, key);
                psUpdate.execute();
            } else {
                PreparedStatement psInsert = this.getPreparedStatement(conn, this.insertExperimentTag);
                psInsert.setString(1, projectKey);
                psInsert.setString(2, experimentId);
                psInsert.setString(3, key);
                psInsert.setString(4, value);
                psInsert.execute();
            }
        }
    }

    public void logBatch(String projectKey, String runId, List<RunMetric> metrics, List<RunParam> params, List<RunTag> tags) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        for (RunMetric metric : metrics) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)metric.key), (Object)"Metric key can not be empty");
        }
        for (RunParam param : params) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)param.key), (Object)"Param key can not be empty");
        }
        for (RunTag tag : tags) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)tag.key), (Object)"Tag key can not be empty");
        }
        try (DSSDBConnection conn = this.acquireConnection();){
            for (RunParam runParam : params) {
                this.insertParameter(conn, projectKey, runId, runId, runParam.key, runParam.value);
            }
            for (RunMetric runMetric : metrics) {
                this.insertUpdateMetric(conn, projectKey, runId, runId, runMetric.key, runMetric.value, runMetric.timestamp, runMetric.step);
            }
            for (RunTag runTag : tags) {
                this.insertUpdateRunTag(conn, projectKey, runId, runId, runTag.key, runTag.value);
            }
            conn.commit();
        }
    }

    public List<Run> searchRuns_NT(String projectKey, List<String> experimentIds, ViewType runViewType, String filter, long maxResults, List<String> orderBy) throws SQLException {
        logger.debug((Object)("Searching runs in project " + projectKey + " with filter " + filter + " and order by " + String.valueOf(orderBy)));
        MLflowSearchRunsTranslator mlfee = new MLflowSearchRunsTranslator(this, projectKey, experimentIds, filter, orderBy, maxResults, runViewType);
        String query = mlfee.translate();
        logger.debug((Object)("Generated SQL search query: " + query));
        try (DSSDBConnection conn = this.acquireConnection();){
            List<Run> list;
            block13: {
                PreparedStatement ps2 = this.getPreparedStatement(conn, query);
                ps2.execute();
                ArrayList<String> runIds = new ArrayList<String>();
                ResultSet rs2 = ps2.getResultSet();
                try {
                    while (rs2.next()) {
                        runIds.add(rs2.getString(RUN_ID_FIELD));
                    }
                    list = this.getRuns(conn, projectKey, runIds, true);
                    if (rs2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs2.close();
            }
            return list;
        }
    }

    public List<Experiment> searchExperiments_NT(String projectKey, ViewType runViewType, String filter, long maxResults, List<String> orderBy) throws SQLException {
        logger.debug((Object)("Searching experiments in project " + projectKey + " with filter " + filter + " and order by " + String.valueOf(orderBy)));
        MLflowSearchExperimentsTranslator mlfee = new MLflowSearchExperimentsTranslator(this, projectKey, filter, orderBy, maxResults, runViewType);
        String query = mlfee.translate();
        logger.debug((Object)("Generated SQL search query: " + query));
        try (DSSDBConnection conn = this.acquireConnection();){
            List<Experiment> list;
            block13: {
                PreparedStatement ps2 = this.getPreparedStatement(conn, query);
                ps2.execute();
                ArrayList<String> experimentIds = new ArrayList<String>();
                ResultSet rs2 = ps2.getResultSet();
                try {
                    while (rs2.next()) {
                        experimentIds.add(rs2.getString(EXPERIMENT_ID_FIELD));
                    }
                    list = this.getExperiments(conn, projectKey, experimentIds, true);
                    if (rs2 == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs2.close();
            }
            return list;
        }
    }

    public void logModel(String projectKey, String runUUId, String runId, String artifactPath) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project can not be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)runId), (Object)"runId can not be empty");
        try (DSSDBConnection conn = this.acquireConnection();){
            try {
                int i = 0;
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.getModel);
                ps2.setString(++i, projectKey);
                ps2.setString(++i, runId);
                ps2.setString(++i, artifactPath);
                ps2.execute();
                try (ResultSet rs2 = ps2.getResultSet();){
                    if (!rs2.next()) {
                        throw new NotFoundException("Model not found");
                    }
                }
            }
            catch (NotFoundException e) {
                int i = 0;
                PreparedStatement ps3 = this.getPreparedStatement(conn, this.insertModel);
                ps3.setString(++i, projectKey);
                ps3.setString(++i, runUUId);
                ps3.setString(++i, runId);
                ps3.setString(++i, artifactPath);
                ps3.execute();
                conn.commit();
            }
        }
    }

    public List<Model> listRunModels(String projectKey, String runId) throws SQLException {
        ArrayList<Model> ret = new ArrayList<Model>();
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.listRunModels);
            ps2.setString(1, projectKey);
            ps2.setString(2, runId);
            ps2.execute();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    ret.add(new Model(rs2.getString(MODEL_ARTIFACT_PATH_FIELD), runId));
                }
            }
        }
        return ret;
    }

    public HashMap<String, List<Model>> listRunsModels(String projectKey, List<Run> mlflowRuns) throws SQLException {
        HashMap<String, List<Model>> ret = new HashMap<String, List<Model>>();
        List runIds = mlflowRuns.stream().map(run -> run.info.runId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(runIds)) {
            return new HashMap<String, List<Model>>();
        }
        for (List runIdsChunk : Lists.partition(runIds, (int)30000)) {
            DSSDBConnection conn = this.acquireConnection();
            try {
                PreparedStatement ps2 = this.getPreparedStatement(conn, this.listRunsModels.replace(":runsList:", this.getRunIdsAsINString(runIdsChunk)));
                ps2.setString(1, projectKey);
                ps2.execute();
                ResultSet rs2 = ps2.getResultSet();
                try {
                    while (rs2.next()) {
                        String runId = rs2.getString(MODEL_RUN_ID_FIELD);
                        ret.computeIfAbsent(runId, k -> new ArrayList()).add(new Model(rs2.getString(MODEL_ARTIFACT_PATH_FIELD), runId));
                    }
                }
                finally {
                    if (rs2 == null) continue;
                    rs2.close();
                }
            }
            finally {
                if (conn == null) continue;
                conn.close();
            }
        }
        return ret;
    }

    public List<Model> getProjectModels(String projectKey) throws SQLException {
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2 = this.getPreparedStatement(conn, this.getProjectModels);
            ps2.setString(1, projectKey);
            ps2.execute();
            ArrayList<Model> models = new ArrayList<Model>();
            try (ResultSet rs2 = ps2.getResultSet();){
                while (rs2.next()) {
                    Model model = new Model(rs2.getString(MODEL_ARTIFACT_PATH_FIELD), rs2.getString(MODEL_RUN_ID_FIELD));
                    model.runUUID = rs2.getString(MODEL_RUN_UUID_FIELD);
                    models.add(model);
                }
            }
            ArrayList<Model> arrayList = models;
            return arrayList;
        }
    }

    public void cleanProject(String projectKey) throws SQLException {
        logger.debug((Object)("Clean MLflow DB for project " + projectKey));
        try (DSSDBConnection conn = this.acquireConnection();){
            for (String curStatement : new String[]{this.deleteTagsForProject, this.deleteMetricsForProject, this.deleteParamsForProject, this.deleteModelsForProject, this.deleteRunsForProject, this.deleteExperimentsForProject}) {
                PreparedStatement ps2 = this.getPreparedStatement(conn, curStatement);
                ps2.setString(1, projectKey);
                ps2.execute();
            }
            conn.commit();
        }
    }

    public ExperimentTrackingGarbageCollectionReport garbageCollectDB(String projectKey) throws SQLException {
        ExperimentTrackingGarbageCollectionReport report = new ExperimentTrackingGarbageCollectionReport();
        try (DSSDBConnection conn = this.acquireConnection();){
            this.executeUpdateProjectStatement(conn, projectKey, this.updateRunSetStatusDeletedForDeletedExperiments);
            this.executeUpdateProjectStatement(conn, projectKey, this.deleteDeletedRunsMetrics);
            this.executeUpdateProjectStatement(conn, projectKey, this.deleteDeletedRunsParams);
            this.executeUpdateProjectStatement(conn, projectKey, this.deleteDeletedRunsTags);
            this.executeUpdateProjectStatement(conn, projectKey, this.deleteDeletedModels);
            report.numberOfDeletedRuns = this.executeUpdateProjectStatement(conn, projectKey, this.deleteDeletedRuns);
            report.numberOfDeletedExperiments = this.executeUpdateProjectStatement(conn, projectKey, this.deleteDeletedExperiments);
            conn.commit();
        }
        return report;
    }

    private int executeUpdateProjectStatement(DSSDBConnection conn, String projectKey, String statement) throws SQLException {
        PreparedStatement ps2 = this.getPreparedStatement(conn, statement);
        ps2.setString(1, projectKey);
        return ps2.executeUpdate();
    }

    public ExperimentTrackingExportData getExportData(String projectKey) throws SQLException {
        logger.debug((Object)"Preparing export of experiment data from DB...");
        ExperimentTrackingExportData exportData = new ExperimentTrackingExportData();
        logger.debug((Object)"Getting experiments...");
        exportData.experiments = this.getProjectExperiments(projectKey, false);
        logger.debug((Object)"Getting runs...");
        exportData.runs = this.getProjectRuns(projectKey, false);
        logger.debug((Object)"Getting models...");
        exportData.models = this.getProjectModels(projectKey);
        return exportData;
    }

    public void insertExportData(String projectKey, ExperimentTrackingExportData data) throws SQLException {
        logger.debugV("Importing experiment data in DB for project %s...", new Object[]{projectKey});
        this.cleanProject(projectKey);
        try (DSSDBConnection conn = this.acquireConnection();){
            PreparedStatement ps2;
            int i;
            logger.debug((Object)"Importing experiments...");
            int curExperiment = 0;
            for (Experiment e : data.experiments) {
                i = 0;
                PreparedStatement ps22 = this.getPreparedStatement(conn, this.insertExperiment);
                ps22.setString(++i, projectKey);
                ps22.setString(++i, e.id);
                ps22.setString(++i, e.name);
                ps22.setString(++i, e.artifactLocation);
                ps22.setString(++i, e.lifecycleStage);
                if (CollectionUtils.isNotEmpty(e.tags)) {
                    for (ExperimentTag experimentTag : e.tags) {
                        this.insertUpdateExperimentTag(conn, projectKey, e.id, experimentTag.key, experimentTag.value);
                    }
                }
                ps22.setLong(++i, e.lastUpdateTime);
                ps22.setLong(++i, e.creationTime);
                ps22.execute();
                if (0 != ++curExperiment % 100) continue;
                logger.debug((Object)(curExperiment + "..."));
            }
            logger.debug((Object)"Importing runs...");
            int curRun = 0;
            for (Run r : data.runs) {
                PreparedStatement psInsert;
                i = 0;
                ps2 = this.getPreparedStatement(conn, this.insertRun);
                ps2.setString(++i, projectKey);
                ps2.setString(++i, r.info.experimentId);
                ps2.setString(++i, r.info.runUuid);
                ps2.setString(++i, r.info.runId);
                ps2.setLong(++i, r.info.startTime);
                ps2.setLong(++i, r.info.endTime);
                ps2.setString(++i, r.info.status.toString());
                ps2.setString(++i, r.info.userId);
                ps2.setString(++i, r.info.artifactUri);
                ps2.setString(++i, r.info.lifecycleStage);
                ps2.execute();
                for (RunTag runTag : r.data.runTags) {
                    int j = 0;
                    psInsert = this.getPreparedStatement(conn, this.insertRunTag);
                    psInsert.setString(++j, projectKey);
                    psInsert.setString(++j, r.info.runUuid);
                    psInsert.setString(++j, r.info.runId);
                    psInsert.setString(++j, runTag.key);
                    psInsert.setString(++j, runTag.value);
                    psInsert.execute();
                }
                for (RunParam runParam : r.data.runParams) {
                    int k = 0;
                    psInsert = this.getPreparedStatement(conn, this.insertParam);
                    psInsert.setString(++k, projectKey);
                    psInsert.setString(++k, r.info.runUuid);
                    psInsert.setString(++k, r.info.runId);
                    psInsert.setString(++k, runParam.key);
                    psInsert.setString(++k, runParam.value);
                    psInsert.execute();
                }
                for (RunMetric runMetric : r.data.metrics) {
                    int l = 0;
                    psInsert = this.getPreparedStatement(conn, this.insertMetric);
                    psInsert.setString(++l, projectKey);
                    psInsert.setString(++l, r.info.runUuid);
                    psInsert.setString(++l, r.info.runId);
                    psInsert.setString(++l, runMetric.key);
                    psInsert.setDouble(++l, runMetric.value);
                    psInsert.setLong(++l, runMetric.timestamp);
                    psInsert.setLong(++l, runMetric.step);
                    psInsert.execute();
                }
                if (0 != ++curRun % 100) continue;
                logger.debug((Object)(curRun + "..."));
            }
            int curModel = 0;
            logger.debug((Object)"Importing models...");
            for (Model m : data.models) {
                i = 0;
                ps2 = this.getPreparedStatement(conn, this.insertModel);
                ps2.setString(++i, projectKey);
                ps2.setString(++i, m.runUUID);
                ps2.setString(++i, m.runId);
                ps2.setString(++i, m.artifactPath);
                ps2.execute();
                if (0 != ++curModel % 100) continue;
                logger.debug((Object)(curModel + "..."));
            }
            conn.commit();
            logger.debugV("Finished importing experiment data in DB for project %s!", new Object[]{projectKey});
        }
    }
}

