/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUnzipDir {
    private static final int BUFFER_SIZE = 8192;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.zipunzipdir");

    public static void zipDirectory(File dir, File zipFile) throws IOException {
        try (ZipBuilder zipBuilder = ZipUnzipDir.zipBuilder(new FileOutputStream(zipFile));){
            zipBuilder.addDirectory("", dir, true, null, null, new DefaultFileInputStreamProvider());
        }
    }

    public static void zipDirectoryWithPrefix(File dir, File zipFile, String prefix) throws IOException {
        try (ZipBuilder zipBuilder = ZipUnzipDir.zipBuilder(new FileOutputStream(zipFile));){
            zipBuilder.addDirectory(prefix, dir, true, null, null, new DefaultFileInputStreamProvider());
        }
    }

    public static void zipDirectory(File dir, File zipFile, boolean recursive, Predicate<String> filter) throws IOException {
        ZipUnzipDir.zipDirectory("", dir, zipFile, recursive, filter);
    }

    public static void zipDirectory(String basePath, File dir, File zipFile, boolean recursive, Predicate<String> filter) throws IOException {
        try (ZipBuilder zipBuilder = ZipUnzipDir.zipBuilder(new FileOutputStream(zipFile));){
            zipBuilder.addDirectory(basePath, dir, recursive, filter, null, new DefaultFileInputStreamProvider());
        }
    }

    public static void zipDirectoryToStream(File dir, OutputStream outStream) throws IOException {
        ZipUnzipDir.zipDirectoryToStream(dir, outStream, "", null);
    }

    public static void zipDirectoryToStream(File dir, OutputStream outStream, String basePath, Pattern exclude) throws IOException {
        ZipUnzipDir.zipDirectoryToStream(dir, outStream, basePath, exclude, new DefaultFileInputStreamProvider());
    }

    public static void zipDirectoryToStream(File dir, OutputStream outStream, String basePath, Predicate<String> filter, Pattern exclude, FileInputStreamProvider fisp) throws IOException {
        try (ZipBuilder zipBuilder = ZipUnzipDir.zipBuilder(outStream);){
            zipBuilder.addDirectory(basePath, dir, true, filter, exclude, fisp);
        }
    }

    public static void zipDirectoryToStream(File dir, OutputStream outStream, String basePath, Pattern exclude, FileInputStreamProvider fisp) throws IOException {
        ZipUnzipDir.zipDirectoryToStream(dir, outStream, basePath, null, exclude, fisp);
    }

    public static void zipDirectoriesToStream(Map<String, File> directories, OutputStream outStream, Pattern exclude) throws IOException {
        ZipUnzipDir.zipDirectoriesToStream(directories, outStream, exclude, new DefaultFileInputStreamProvider());
    }

    public static void zipDirectoriesToStream(Map<String, File> directories, OutputStream outStream, Predicate<String> filter, Pattern exclude, FileInputStreamProvider fisp) throws IOException {
        try (ZipBuilder zipBuilder = ZipUnzipDir.zipBuilder(outStream);){
            zipBuilder.addDirectories(directories, true, filter, exclude, fisp);
        }
    }

    public static void zipDirectoriesToStream(Map<String, File> directories, OutputStream outStream, Pattern exclude, FileInputStreamProvider fisp) throws IOException {
        ZipUnzipDir.zipDirectoriesToStream(directories, outStream, null, exclude, fisp);
    }

    public static ZipBuilder zipBuilder(OutputStream outputStream) {
        return new ZipBuilder(outputStream);
    }

    public static ZipBuilderWithBasePath zipBuilder(OutputStream outputStream, Path basePath) {
        return new ZipBuilderWithBasePath(outputStream, basePath);
    }

    private static void zipSubDirectory(String basePath, File dir, ZipOutputStream zout, boolean recursive, Predicate<String> filter, Pattern exclude, FileInputStreamProvider fisp) throws IOException {
        byte[] buffer = new byte[8192];
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                String path;
                if (exclude != null && exclude.matcher(file.getName()).matches()) continue;
                BasicFileAttributes fileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (fileAttributes.isDirectory()) {
                    if (!recursive) continue;
                    path = basePath + file.getName() + "/";
                    if (filter != null && !filter.apply((Object)path)) continue;
                    zout.putNextEntry(new ZipEntry(path));
                    ZipUnzipDir.zipSubDirectory(path, file, zout, recursive, filter, exclude, fisp);
                    zout.closeEntry();
                    continue;
                }
                if (!fileAttributes.isRegularFile()) continue;
                path = basePath + file.getName();
                if (filter != null && !filter.apply((Object)path)) continue;
                ZipUnzipDir.zipFile(path, fisp.getInputStream(file), zout, buffer);
            }
        }
    }

    private static void zipFile(String zipPath, InputStream inputStream, ZipOutputStream zout, byte[] buffer) throws IOException {
        try (InputStream fin = inputStream;){
            int length;
            zout.putNextEntry(new ZipEntry(zipPath));
            while ((length = fin.read(buffer)) > 0) {
                zout.write(buffer, 0, length);
            }
            zout.closeEntry();
        }
    }

    private static void zipFile(String zipPath, InputStream inputStream, ZipOutputStream zout) throws IOException {
        byte[] buffer = new byte[8192];
        ZipUnzipDir.zipFile(zipPath, inputStream, zout, buffer);
    }

    public static void extractFolder(File zipFile, File destinationDirectory) throws IOException {
        ZipUnzipDir.extractFolder(zipFile, destinationDirectory, true);
    }

    public static void extractFolder(File zipFile, File destinationDirectory, boolean unZipContent) throws IOException {
        Preconditions.checkNotNull((Object)destinationDirectory, (Object)"destinationDirectory cannot be null");
        try (ZipFile zip = new ZipFile(zipFile);){
            destinationDirectory.mkdir();
            Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
            while (zipFileEntries.hasMoreElements()) {
                File destFile;
                ZipEntry entry;
                block18: {
                    entry = zipFileEntries.nextElement();
                    destFile = DKUFileUtils.getWithin((File)destinationDirectory, (String[])new String[]{entry.getName()});
                    destFile.getParentFile().mkdirs();
                    if (!entry.isDirectory()) {
                        try (BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));){
                            byte[] data = new byte[8192];
                            try (BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(destFile), 8192);){
                                int currentByte;
                                while ((currentByte = is.read(data, 0, 8192)) != -1) {
                                    dest.write(data, 0, currentByte);
                                }
                                dest.flush();
                                break block18;
                            }
                        }
                    }
                    DKUFileUtils.mkdirs((File)destFile);
                }
                if (!entry.getName().endsWith(".zip") || !unZipContent) continue;
                File destinationFolder = DKUFileUtils.getWithin((File)destFile.getParentFile(), (String[])new String[]{com.google.common.io.Files.getNameWithoutExtension((String)destFile.getName())});
                ZipUnzipDir.extractFolder(destFile, destinationFolder);
            }
        }
    }

    public static void zipDirectoryIfLargerThanSize(File directory, long minSizeForCompressionKB) throws IOException {
        long size = FileUtils.sizeOfDirectory((File)directory);
        String directoryName = directory.getName();
        logger.debug((Object)(directoryName + " folder size is " + size / 1024L + " kb"));
        if (size > minSizeForCompressionKB * 1024L) {
            logger.debugV("Zipping it (minimum size for compression %d kb)", new Object[]{minSizeForCompressionKB});
            ZipUnzipDir.zipDirectoryWithPrefix(directory, new File(directory.getParentFile(), directoryName + ".zip"), directoryName + "/");
            DKUFileUtils.deleteDirectory((File)directory);
        }
    }

    private ZipUnzipDir() {
    }

    public static class ZipBuilder
    implements AutoCloseable {
        private final ZipOutputStream zout;

        public ZipBuilder(OutputStream outputStream) {
            this.zout = new ZipOutputStream(outputStream);
        }

        public void addDirectory(String zipBasePath, File dir, boolean recursive, Predicate<String> filter, Pattern exclude, FileInputStreamProvider fisp) throws IOException {
            ZipUnzipDir.zipSubDirectory(zipBasePath, dir, this.zout, recursive, filter, exclude, fisp);
        }

        public void addDirectoryIfExists(String zipBasePath, File dir, boolean recursive) throws IOException {
            if (dir.exists()) {
                ZipUnzipDir.zipSubDirectory(zipBasePath, dir, this.zout, recursive, null, null, new DefaultFileInputStreamProvider());
            }
        }

        public void addDirectories(Map<String, File> directoriesByZipBasePath, boolean recursive, Predicate<String> filter, Pattern exclude, FileInputStreamProvider fisp) throws IOException {
            for (Map.Entry<String, File> directory : directoriesByZipBasePath.entrySet()) {
                ZipUnzipDir.zipSubDirectory(directory.getKey(), directory.getValue(), this.zout, recursive, filter, exclude, fisp);
            }
        }

        public void addFile(String zipFilePath, InputStream inputStream) throws IOException {
            ZipUnzipDir.zipFile(zipFilePath, inputStream, this.zout);
        }

        public void addFile(String zipFilePath, File file) throws IOException {
            this.addFile(zipFilePath, new FileInputStream(file));
        }

        public void addFileIfExists(String zipFilePath, File file) throws IOException {
            if (file.exists()) {
                this.addFile(zipFilePath, file);
            }
        }

        @Override
        public void close() throws IOException {
            this.zout.close();
        }
    }

    public static class DefaultFileInputStreamProvider
    implements FileInputStreamProvider {
        @Override
        public InputStream getInputStream(File file) throws IOException {
            return new FileInputStream(file);
        }
    }

    public static interface FileInputStreamProvider {
        public InputStream getInputStream(File var1) throws IOException;
    }

    public static class ZipBuilderWithBasePath
    extends ZipBuilder {
        private final Path basePath;

        public ZipBuilderWithBasePath(OutputStream outputStream, Path basePath) {
            super(outputStream);
            this.basePath = basePath;
        }

        private String toRelativeInnerPath(File file) throws IllegalArgumentException, IOException {
            Path filePath = file.toPath();
            if (!DKUFileUtils.isWithin((File)this.basePath.toFile(), (File)filePath.toFile())) {
                throw new IllegalArgumentException("Path ('" + String.valueOf(filePath) + "') not contained within provided base path ('" + String.valueOf(this.basePath) + "')");
            }
            Object relativePath = this.basePath.relativize(filePath).toString();
            if (!File.separator.equals("/")) {
                relativePath = ((String)relativePath).replace(File.separator, "/");
            }
            if (file.isDirectory()) {
                relativePath = (String)relativePath + "/";
            }
            return relativePath;
        }

        public void addFileFromBasePath(File file) throws IOException, IllegalArgumentException {
            super.addFile(this.toRelativeInnerPath(file), file);
        }

        public void addFilesFromBasePath(Set<File> files) throws IOException, IllegalArgumentException {
            for (File file : files) {
                this.addFileFromBasePath(file);
            }
        }

        public void addDirectoryFromBasePath(File dir, boolean recursive, Predicate<String> filter, Pattern exclude, FileInputStreamProvider fisp) throws IOException, IllegalArgumentException {
            super.addDirectory(this.toRelativeInnerPath(dir), dir, recursive, filter, exclude, fisp);
        }

        public void addDirectoriesFromBasePath(Set<File> directories, boolean recursive, Predicate<String> filter, Pattern exclude, FileInputStreamProvider fisp) throws IOException, IllegalArgumentException {
            for (File directory : directories) {
                this.addDirectoryFromBasePath(directory, recursive, filter, exclude, fisp);
            }
        }
    }
}

