/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel.xssfb;

import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.BuiltinFormats;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBParseException;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBParser;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBRecordType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.binary.XSSFBUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class XSSFBStylesTable
extends XSSFBParser {
    private final SortedMap<Short, String> numberFormats = new TreeMap<Short, String>();
    private final List<Short> styleIds = new ArrayList<Short>();
    private boolean inCellXFS;
    private boolean inFmts;

    public XSSFBStylesTable(InputStream is) throws IOException {
        super(is);
        this.parse();
    }

    public String getNumberFormatString(int idx) {
        short numberFormatIdx = this.getNumberFormatIndex(idx);
        return this.numberFormats.containsKey(numberFormatIdx) ? (String)this.numberFormats.get(numberFormatIdx) : BuiltinFormats.getBuiltinFormat((int)numberFormatIdx);
    }

    public short getNumberFormatIndex(int idx) {
        return this.styleIds.get(idx);
    }

    public void handleRecord(int recordType, byte[] data) throws XSSFBParseException {
        XSSFBRecordType type = XSSFBRecordType.lookup((int)recordType);
        switch (type) {
            case BrtBeginCellXFs: {
                this.inCellXFS = true;
                break;
            }
            case BrtEndCellXFs: {
                this.inCellXFS = false;
                break;
            }
            case BrtXf: {
                if (!this.inCellXFS) break;
                this.handleBrtXFInCellXF(data);
                break;
            }
            case BrtBeginFmts: {
                this.inFmts = true;
                break;
            }
            case BrtEndFmts: {
                this.inFmts = false;
                break;
            }
            case BrtFmt: {
                if (!this.inFmts) break;
                this.handleFormat(data);
            }
        }
    }

    private void handleFormat(byte[] data) {
        int ifmt = data[0] & 0xFF;
        StringBuilder sb = new StringBuilder();
        XSSFBUtils.readXLWideString((byte[])data, (int)2, (StringBuilder)sb);
        String fmt = sb.toString();
        this.numberFormats.put((short)ifmt, fmt);
    }

    private void handleBrtXFInCellXF(byte[] data) {
        int ifmtOffset = 2;
        int ifmt = data[ifmtOffset] & 0xFF;
        this.styleIds.add((short)ifmt);
    }
}

