/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.LLMModelEvaluation;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DSSFuturePayloadUtils {
    private static Logger logger = Logger.getLogger((String)"dku.futures");

    public static FuturePayload.FuturePayloadTarget forDataset(Dataset dataset) {
        return new FuturePayload.FuturePayloadTarget(dataset.getProjectKey(), dataset.getName(), dataset.getName(), dataset.getType(), ITaggingService.TaggableType.DATASET.name());
    }

    public static FuturePayload.FuturePayloadTarget forStreamingEndpoint(StreamingEndpoint streamingEndpoint) {
        return new FuturePayload.FuturePayloadTarget(streamingEndpoint.getProjectKey(), streamingEndpoint.getId(), streamingEndpoint.getId(), streamingEndpoint.getType(), ITaggingService.TaggableType.STREAMING_ENDPOINT.name());
    }

    public static FuturePayload.FuturePayloadTarget forTaggableObject(TaggableObjectsService.TaggableObject o) {
        return new FuturePayload.FuturePayloadTarget(o.getProjectKey(), o.getId(), o.getDisplayName(), o.getSubtype(), o.getTaggableType().name());
    }

    public static FuturePayload.FuturePayloadTarget forFMI(FullModelId fmi) {
        String name = null;
        try {
            name = fmi.getHeadMLTask().name;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get model name", (Throwable)e);
        }
        if (fmi.type == FullModelId.Type.ANALYSIS) {
            return new FuturePayload.FuturePayloadTarget(fmi.getTaskLoc().analysisProjectKey, fmi.getTaskLoc().analysisId, name, null, ITaggingService.TaggableType.ANALYSIS.name());
        }
        return new FuturePayload.FuturePayloadTarget(fmi.getProjectKey(), fmi.getSavedModelID(), name, null, ITaggingService.TaggableType.SAVED_MODEL.name());
    }

    public static FuturePayload.FuturePayloadTarget forFME(FullModelEvaluationId fme) {
        String name = null;
        try {
            name = fme.getModelEvaluation().userMeta.name;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get model evaluation name", (Throwable)e);
        }
        return new FuturePayload.FuturePayloadTarget(fme.getProjectKey(), fme.toString(), name, null, ITaggingService.TaggableType.MODEL_EVALUATION_STORE.name());
    }

    public static FuturePayload.FuturePayloadTarget forFMEs(List<FullModelEvaluationId> fmeIds) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            for (FullModelEvaluationId fmeId : fmeIds) {
                LLMModelEvaluation llmEval = fmeId.getLLMModelEvaluation();
                names.add(llmEval.userMeta.name);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get model evaluation name", (Throwable)e);
        }
        return new FuturePayload.FuturePayloadTarget(null, null, String.join((CharSequence)"-", names), ITaggingService.TaggableType.MODEL_EVALUATION_STORE.name());
    }

    public static FuturePayload.FuturePayloadTarget forMLTaskModel(MLTaskLoc loc, String modelType, String displayName) {
        return new FuturePayload.FuturePayloadTarget(loc.analysisProjectKey, loc.analysisId, displayName, modelType, ITaggingService.TaggableType.ANALYSIS.name());
    }
}

