/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.futures.FutureKernelHandle;
import com.dataiku.dip.futures.IFutureKernelsManager;
import com.dataiku.dip.kernels.DSSKernelManagerBase;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.CachesPreloadingService;
import com.dataiku.dip.utils.DKULogger;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FutureKernelsManager
extends DSSKernelManagerBase<FutureKernelHandle>
implements IFutureKernelsManager {
    @Autowired
    private CachesPreloadingService cachesPreloadingService;
    @Autowired
    private APITicketService apiTicketService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.futures.manager");

    public FutureKernelsManager() {
        super(logger, "dku.futures.kernels", MainLoggingConfigurator.ProcessType.FEK.name(), new DSSKernelManagerBase.KernelManagerConfig(){

            public int getTargetMinFreeKernels() {
                return ApplicationConfigurator.getParams().getIntParam("dku.futures.pool.targetMinFreeKernels", Integer.valueOf(1));
            }

            public int getMaxFreeKernels() {
                return ApplicationConfigurator.getParams().getIntParam("dku.futures.pool.maxFreeKernels", Integer.valueOf(4));
            }

            public int getPoolCheckInterval() {
                return ApplicationConfigurator.getParams().getIntParam("dku.futures.pool.check.ms", Integer.valueOf(30000));
            }

            public int getPoolStartWait() {
                return ApplicationConfigurator.getParams().getIntParam("dku.futures.pool.check.initial.ms", Integer.valueOf(30000));
            }

            public boolean canReuseKernels() {
                return true;
            }
        });
    }

    @PostConstruct
    public void onStart() {
        logger.info((Object)"Init futures kernels service");
        new DSSKernelManagerBase.PoolMaintainerThread((DSSKernelManagerBase)this).start();
        new DSSKernelManagerBase.PoolReturnerThread((DSSKernelManagerBase)this).start();
        logger.debug((Object)"Done init futures kernels service");
        super.onStart();
    }

    protected FutureKernelHandle createKernelHandle(String id) {
        return new FutureKernelHandle(id, this.apiTicketService);
    }

    @Override
    public boolean isUsable() {
        return true;
    }

    @Override
    public FutureKernelHandle acquireKernel(AuthCtx authCtx, String jobId) throws Exception {
        return (FutureKernelHandle)super.acquireKernel(jobId, authCtx, null);
    }

    public void onRegister(String kernelId, int port) {
        FutureKernelHandle kernelHandle = (FutureKernelHandle)this.getStarting(kernelId);
        if (kernelHandle == null) {
            throw new IllegalArgumentException("Registration from unknown kernel: " + kernelId);
        }
        kernelHandle.onRegister(port);
    }
}

