/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.AWSGlueHiveMetastoreSynchronizer;
import com.dataiku.dip.hive.DSSCatalogHiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveServer2HiveMetastoreSynchronizer;
import com.dataiku.dip.security.AuthCtx;
import java.io.IOException;
import java.net.URISyntaxException;

public class HiveMetastoreSynchronizerFactory {
    public static HiveMetastoreSynchronizer getSynchronizer(AuthCtx authCtx) throws IOException, DKUSecurityException, URISyntaxException, CodedException {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        switch (gs.metastoreCatalogsSettings.synchronizeTo.flavor) {
            case HIVESERVER2: {
                return new HiveServer2HiveMetastoreSynchronizer(authCtx);
            }
            case DSS_INTERNAL: {
                return new DSSCatalogHiveMetastoreSynchronizer(authCtx);
            }
            case AWS_GLUE: {
                return new AWSGlueHiveMetastoreSynchronizer(authCtx);
            }
        }
        throw new Error("unreachable");
    }
}

