/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.input.formats.ArchiveCapableFormatExtractor;
import com.dataiku.dip.input.formats.JSONFormatConfig;
import com.dataiku.dip.output.JSONOutputFormatter;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JSONFormatExtractor
extends ArchiveCapableFormatExtractor {
    public static final JSONFormatMeta META = new JSONFormatMeta();
    private JSONFormatConfig config;
    private static Logger logger = Logger.getLogger((String)"dku.format.json");

    public JSONFormatExtractor(JSONFormatConfig config) {
        this.config = config;
    }

    private boolean overflowsArray(List<StackElt> elts) {
        for (StackElt se : elts) {
            if (!se.isArray || (long)se.arrayIndex < this.config.nestedArraysMaxElements) continue;
            return true;
        }
        return false;
    }

    private static String buildPath(List<StackElt> elts) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (StackElt se : elts) {
            if (se.name != null) {
                if (i++ > 0) {
                    sb.append(".");
                }
                sb.append(se.name);
                continue;
            }
            if (!se.isArray) continue;
            if (i++ > 0) {
                sb.append(".");
            }
            sb.append(se.arrayIndex);
        }
        return sb.toString();
    }

    private String stackPath(List<String> stack) {
        return StringUtils.join(stack, (String)".");
    }

    private boolean depthExceeded(List<StackElt> stack) {
        int realDepth = 0;
        for (StackElt se : stack) {
            if (se.isArray) continue;
            ++realDepth;
        }
        return this.config.maxExpansionDepth >= 0 && realDepth > this.config.maxExpansionDepth;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected boolean doExtractStream(InputStreamWithContextInfo isn, ProcessorOutput out, ColumnFactory cf, RowFactory rf, ArchiveCapableFormatExtractor.ArchiveCapableObserver observer) throws Exception {
        block60: {
            is = isn.getInputStream();
            factory = new JsonFactory();
            parser = factory.createJsonParser(is);
            nlines = 0;
            if (this.config.extractFromSingleElement && StringUtils.isBlank((String)this.config.rootPath)) {
                throw ErrorContext.iae((String)"Please select path to root element (in the form: key.subkey.subsubkey)");
            }
            rootPathToUse = this.config.rootPath;
            if (!this.config.extractFromSingleElement) break block60;
            rootPathToUse = "." + this.config.rootPath;
            eof = false;
            found = false;
            chunksStack = new ArrayList<String>();
            block11: while (true) {
                if ((tok = parser.nextToken()) == null) {
                    eof = true;
                    break;
                }
                if (tok == JsonToken.FIELD_NAME) continue;
                switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[tok.ordinal()]) {
                    case 1: 
                    case 2: {
                        chunksStack.add(parser.getCurrentName());
                        if (this.stackPath(chunksStack).equals(rootPathToUse)) {
                            found = true;
                            break block11;
                        }
                        ** GOTO lbl29
                    }
                    case 3: 
                    case 4: {
                        chunksStack.remove(chunksStack.size() - 1);
                    }
lbl29:
                    // 3 sources

                    default: {
                        continue block11;
                    }
                }
                break;
            }
            if (!found || eof) {
                return false;
            }
        }
        stack = new ArrayList<StackElt>();
        currentPreservedArray = null;
        currentPreservedObject = null;
        currentPreserveDepth = 0;
        currentRow = rf.row();
        isFirstToken = true;
        isJSONArrayFile = false;
        readRows = 0L;
        colIdx = 0;
        columns = new ArrayList<Column>();
        block12: while ((tok = parser.nextToken()) != null) {
            if (tok == JsonToken.FIELD_NAME) {
                isFirstToken = false;
                continue;
            }
            if (tok == JsonToken.START_ARRAY && isFirstToken) {
                isFirstToken = false;
                isJSONArrayFile = true;
                continue;
            }
            isFirstToken = false;
            curName = parser.getCurrentName();
            switch (1.$SwitchMap$com$fasterxml$jackson$core$JsonToken[tok.ordinal()]) {
                case 1: {
                    if (stack.size() > 0) {
                        stackTop = (StackElt)stack.get(stack.size() - 1);
                        if (stackTop.isArray) {
                            ++stackTop.arrayIndex;
                        }
                    }
                    stack.add(new StackElt(false, curName));
                    if (this.depthExceeded(stack) || this.config.nestedArraysHandling != NestedArraysHandling.FLATTEN) {
                        if (currentPreserveDepth == 0) {
                            currentPreservedArray = new PreservedArray();
                            currentPreservedArray.key = JSONFormatExtractor.buildPath(stack);
                            currentPreservedArray.startupStackSize = stack.size();
                        }
                        ++currentPreserveDepth;
                    } else if (currentPreserveDepth > 0) {
                        ++currentPreserveDepth;
                    }
                    stack.add(new StackElt(true, null));
                    ** GOTO lbl158
                }
                case 3: {
                    if (stack.size() < 2) {
                        if (!JSONFormatExtractor.$assertionsDisabled && rootPathToUse == null && !isJSONArrayFile) {
                            throw new AssertionError();
                        }
                        break block12;
                    }
                    stack.remove(stack.size() - 1);
                    if (currentPreserveDepth > 0 && --currentPreserveDepth == 0) {
                        if (!JSONFormatExtractor.$assertionsDisabled && currentPreservedArray == null) {
                            throw new AssertionError();
                        }
                        if (currentPreservedArray.overflowedElts) {
                            currentRow.put(cf.column(currentPreservedArray.key + "_TRUNCATED"), "Yes (too many elements)");
                        }
                        if (currentPreservedArray.overflowedSize) {
                            currentRow.put(cf.column(currentPreservedArray.key + "_TRUNCATED"), "Yes (too large)");
                        }
                        currentRow.put(cf.column(currentPreservedArray.key), currentPreservedArray.getRepr());
                        currentPreservedArray = null;
                    }
                    stack.remove(stack.size() - 1);
                    ** GOTO lbl158
                }
                case 2: {
                    if (stack.size() > 0) {
                        stackTop = (StackElt)stack.get(stack.size() - 1);
                        if (stackTop.isArray) {
                            ++stackTop.arrayIndex;
                        }
                    }
                    stack.add(new StackElt(false, curName));
                    if (this.depthExceeded(stack)) {
                        if (currentPreserveDepth == 0) {
                            currentPreservedObject = new PreservedObject();
                            currentPreservedObject.key = JSONFormatExtractor.buildPath(stack);
                            if (StringUtils.isBlank((String)currentPreservedObject.key)) {
                                currentPreservedObject.key = "object";
                            }
                            currentPreservedObject.startupStackSize = stack.size();
                        }
                        ++currentPreserveDepth;
                    } else if (currentPreserveDepth > 0) {
                        ++currentPreserveDepth;
                    }
                    ** GOTO lbl158
                }
                case 4: {
                    if (stack.size() == 0) {
                        if (!JSONFormatExtractor.$assertionsDisabled && rootPathToUse == null) {
                            throw new AssertionError();
                        }
                        break block12;
                    }
                    stack.remove(stack.size() - 1);
                    if (currentPreserveDepth > 0 && --currentPreserveDepth == 0) {
                        if (!JSONFormatExtractor.$assertionsDisabled && currentPreservedObject == null) {
                            throw new AssertionError();
                        }
                        currentRow.put(cf.column(currentPreservedObject.key), currentPreservedObject.getRepr());
                        currentPreservedObject = null;
                    }
                    ** GOTO lbl158
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    value = parser.getText();
                    v0 = isNullValue = tok == JsonToken.VALUE_NULL;
                    if (stack.size() > 0) {
                        stackTop = (StackElt)stack.get(stack.size() - 1);
                        if (stackTop.isArray) {
                            ++stackTop.arrayIndex;
                        }
                    }
                    stack.add(new StackElt(false, curName));
                    if (currentPreserveDepth > 0) {
                        if (currentPreservedArray != null) {
                            if (!JSONFormatExtractor.$assertionsDisabled && currentPreservedObject != null) {
                                throw new AssertionError();
                            }
                            currentPreservedArray.add(stack, isNullValue == false ? value : null);
                        } else {
                            if (!JSONFormatExtractor.$assertionsDisabled && currentPreservedObject == null) {
                                throw new AssertionError();
                            }
                            if (!JSONFormatExtractor.$assertionsDisabled && currentPreservedArray != null) {
                                throw new AssertionError();
                            }
                            currentPreservedObject.add(stack, isNullValue == false ? value : null);
                        }
                    } else if (!this.overflowsArray(stack)) {
                        if (this.config.headerRow) {
                            if (readRows == 0L) {
                                columns.add(cf.column(value));
                            } else {
                                currentRow.put((Column)columns.get(colIdx++), isNullValue == false ? value : "");
                            }
                        } else {
                            path = JSONFormatExtractor.buildPath(stack);
                            currentRow.put(cf.column(path), isNullValue == false ? value : "");
                        }
                    }
                    stack.remove(stack.size() - 1);
                }
lbl158:
                // 7 sources

                default: {
                    if (stack.size() != 0) continue block12;
                    if (!this.config.headerRow || ++readRows > 1L) {
                        if (!observer.checkLimit(nlines)) {
                            return false;
                        }
                        if (isn != null) {
                            isn.fillRowContext(currentRow.getRowContext());
                            currentRow.getRowContext().sourceRecord = nlines + 1;
                        }
                        out.emitRow(currentRow);
                        if (++nlines % 500 == 0) {
                            observer.onInterval(nlines);
                        }
                    }
                    colIdx = 0;
                    currentRow = rf.row();
                    continue block12;
                }
            }
        }
        observer.onEnd(nlines);
        return true;
    }

    static class StackElt {
        boolean isArray;
        int arrayIndex = -1;
        String name;

        StackElt(boolean isArray, String name) {
            this.isArray = isArray;
            this.name = name;
        }
    }

    public static enum NestedArraysHandling {
        SKIP,
        PRESERVE,
        FLATTEN;

    }

    class PreservedArray
    extends PreservedThing {
        List<Object> root = new ArrayList<Object>();
        boolean overflowedElts;
        boolean overflowedSize;
        long totalSize;

        PreservedArray() {
        }

        public String getRepr() {
            if (JSONFormatExtractor.this.config.nestedArraysHandling == NestedArraysHandling.SKIP) {
                return "Nested array skipped";
            }
            return JSON.json(this.root);
        }

        public void add(List<StackElt> elts, String value) {
            if (JSONFormatExtractor.this.config.nestedArraysHandling == NestedArraysHandling.SKIP) {
                return;
            }
            if ((long)this.root.size() > JSONFormatExtractor.this.config.nestedArraysMaxElements) {
                this.overflowedElts = true;
                return;
            }
            if (this.totalSize >= JSONFormatExtractor.this.config.nestedArraysMaxContentSize) {
                this.overflowedSize = true;
                return;
            }
            this.totalSize += (long)(value == null ? 0 : value.length());
            Object cur = this.root;
            for (int offset = this.startupStackSize; offset < elts.size(); ++offset) {
                StackElt se = elts.get(offset);
                if (se.name != null) {
                    Map keys = (Map)cur;
                    this.addToObjectCur(keys, se, elts, offset, value);
                    cur = keys.get(se.name);
                    continue;
                }
                if (!se.isArray) continue;
                List<Object> list = cur;
                while (list.size() <= se.arrayIndex) {
                    if (list == this.root && (long)list.size() >= JSONFormatExtractor.this.config.nestedArraysMaxElements) {
                        this.overflowedElts = true;
                        return;
                    }
                    Object next = this.getNext(elts, offset);
                    if (next == null) {
                        list.add(value);
                        continue;
                    }
                    list.add(next);
                }
                cur = list.get(se.arrayIndex);
            }
        }
    }

    static class PreservedObject
    extends PreservedThing {
        Map<String, Object> root = new HashMap<String, Object>();

        PreservedObject() {
        }

        public void add(List<StackElt> elts, String value) {
            Object cur = this.root;
            for (int offset = this.startupStackSize; offset < elts.size(); ++offset) {
                StackElt se = elts.get(offset);
                if (se.name != null) {
                    Map<String, Object> keys = cur;
                    this.addToObjectCur(keys, se, elts, offset, value);
                    cur = keys.get(se.name);
                    continue;
                }
                if (!se.isArray) continue;
                List list = (List)cur;
                this.addToArrayCur(list, se, elts, offset, value);
                cur = list.get(se.arrayIndex);
            }
        }

        public String getRepr() {
            return JSON.json(this.root);
        }
    }

    public static class JSONFormatMeta
    extends FormatMeta<JSONFormatExtractor, JSONFormatConfig> {
        @Override
        public String getType() {
            return "json";
        }

        @Override
        public Class<? extends FormatParams> paramsClass() {
            return JSONFormatConfig.class;
        }

        @Override
        public JSONFormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new JSONFormatExtractor((JSONFormatConfig)params);
        }

        @Override
        public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
            return new JSONOutputFormatter((JSONFormatConfig)params);
        }

        @Override
        public String getLabel() {
            return "JSON";
        }

        @Override
        public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
            return SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS;
        }

        @Override
        public ParamDesc[] getParams() {
            return new ParamDesc[]{ParamDesc.booleanP("extractFromSingleElement", "Extract from a root element"), ParamDesc.string("rootPath", "Root Element path").withMandatory(false).withCanBeEmpty(true), ParamDesc.intP("maxExpansionDepth", "Max expansion depth", "-1 = unlimited", -1), ParamDesc.advancedSelect("nestedArraysHandling", "Handling of nested arrays", "How should nested (ie, not top-level) arrays in the JSON be handled ?", new String[]{"SKIP", "PRESERVE", "FLATTEN"}, new String[]{"Completely remove", "Preserve as a single column (subject to size limits)", "Flatten as multiple columns (recursively)"}), ParamDesc.intP("nestedArraysMaxElements", "Max elements for nested arrays"), ParamDesc.intP("nestedArraysMaxContentSize", "Max content size for preserved nested arrays", "This is an approximate limit on the size in chars of preserved nested arrays"), FormatFactory.getStandardCompressionMethods()};
        }
    }

    static class PreservedThing {
        String key;
        int startupStackSize;

        PreservedThing() {
        }

        protected Object getNext(List<StackElt> elts, int offset) {
            while (offset < elts.size() - 1) {
                if (elts.get((int)(offset + 1)).name != null) {
                    return new HashMap();
                }
                if (elts.get((int)(offset + 1)).isArray) {
                    return new ArrayList();
                }
                ++offset;
            }
            return null;
        }

        protected void addToObjectCur(Map<String, Object> keys, StackElt se, List<StackElt> elts, int offset, String value) {
            if (!keys.containsKey(se.name)) {
                Object next = this.getNext(elts, offset);
                if (next == null) {
                    keys.put(se.name, value);
                } else {
                    keys.put(se.name, next);
                }
            }
        }

        protected void addToArrayCur(List<Object> list, StackElt se, List<StackElt> elts, int offset, String value) {
            while (list.size() <= se.arrayIndex) {
                Object next = this.getNext(elts, offset);
                if (next == null) {
                    list.add(value);
                    continue;
                }
                list.add(next);
            }
        }
    }
}

