/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.input.formats.parquet.HiveArrayConverter;
import com.dataiku.dip.input.formats.parquet.HiveDateConverter;
import com.dataiku.dip.input.formats.parquet.HiveDateOnlyConverter;
import com.dataiku.dip.input.formats.parquet.MapConverter;
import com.dataiku.dip.input.formats.parquet.ObjectConverter;
import com.dataiku.dip.input.formats.parquet.ParentValueContainer;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetSchemaConverter;
import com.dataiku.dip.input.formats.parquet.PigArrayConverter;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

class ConverterFactory {
    private Set<ParquetFormatConfig.Flavor> hiveLikeFlavors = Sets.newHashSet((Object[])new ParquetFormatConfig.Flavor[]{ParquetFormatConfig.Flavor.HIVE, ParquetFormatConfig.Flavor.SPARK});
    private final ParquetFormatConfig.Flavor flavor;
    private final boolean representsNullFields;

    public ConverterFactory(ParquetFormatConfig.Flavor flavor, boolean representsNullFields) {
        this.flavor = flavor;
        this.representsNullFields = representsNullFields;
    }

    public boolean getRepresentsNullFields() {
        return this.representsNullFields;
    }

    public Converter createConverter(org.apache.parquet.schema.Type parquetType, SchemaColumn sc, ParentValueContainer parent) {
        Type dssType;
        Type type = dssType = sc != null ? sc.getType() : null;
        if (parquetType.isPrimitive()) {
            return this.createPrimitiveConverter(parquetType, parent, dssType);
        }
        GroupType groupType = parquetType.asGroupType();
        if (groupType.getOriginalType() == OriginalType.LIST) {
            if (this.hiveLikeFlavors.contains((Object)this.flavor)) {
                return new HiveArrayConverter(this, (org.apache.parquet.schema.Type)groupType, sc != null ? sc.arrayContent : null, parent);
            }
            return new PigArrayConverter(this, (org.apache.parquet.schema.Type)groupType, sc != null ? sc.arrayContent : null, parent);
        }
        if (groupType.getOriginalType() == OriginalType.MAP) {
            return new MapConverter(this, (org.apache.parquet.schema.Type)groupType, sc != null ? sc.mapKeys : null, sc != null ? sc.mapValues : null, parent);
        }
        return new ObjectConverter(this, groupType, sc != null ? sc.objectFields : null, parent);
    }

    private PrimitiveConverter createPrimitiveConverter(org.apache.parquet.schema.Type parquetType, final ParentValueContainer parent, Type dssType) {
        PrimitiveType pt = parquetType.asPrimitiveType();
        PrimitiveType.PrimitiveTypeName ptn = pt.getPrimitiveTypeName();
        String originalTypeStr = pt.getOriginalType() != null ? pt.getOriginalType().toString() : "";
        switch (ptn) {
            case BINARY: {
                return this.createPrimitiveBinaryConverter(parent, pt);
            }
            case BOOLEAN: {
                return new PrimitiveConverter(){

                    public final void addBoolean(boolean value) {
                        parent.addBoolean(value);
                    }
                };
            }
            case DOUBLE: {
                return new PrimitiveConverter(){

                    public final void addDouble(double value) {
                        parent.addDouble(value);
                    }
                };
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (pt.getOriginalType() == OriginalType.DECIMAL && pt.getDecimalMetadata() != null) {
                    final int scale = pt.getDecimalMetadata().getScale();
                    return new PrimitiveConverter(){

                        public final void addBinary(Binary value) {
                            BigDecimal bd = new BigDecimal(new BigInteger(value.getBytes()), scale);
                            parent.addDouble(bd.doubleValue());
                        }
                    };
                }
                return new PrimitiveConverter(){

                    public void addBinary(Binary value) {
                        String b64 = BaseEncoding.base64().encode(value.getBytes());
                        parent.addString(b64);
                    }
                };
            }
            case FLOAT: {
                return new PrimitiveConverter(){

                    public final void addFloat(float value) {
                        parent.addFloat(value);
                    }
                };
            }
            case INT32: {
                return ConverterFactory.createPrimitiveInt32Converter(parent, dssType, pt);
            }
            case INT64: {
                return ConverterFactory.createPrimitiveInt64Converter(parent, dssType, pt, originalTypeStr);
            }
            case INT96: {
                return new HiveDateConverter(parent, true, false);
            }
        }
        throw new NotImplementedException("DSS doesn't support Parquet/" + String.valueOf(ptn));
    }

    private static PrimitiveConverter createPrimitiveInt64Converter(final ParentValueContainer parent, Type dssType, PrimitiveType pt, String originalTypeStr) {
        if (pt.getOriginalType() == OriginalType.DECIMAL && pt.getDecimalMetadata() != null) {
            final int scale = pt.getDecimalMetadata().getScale();
            return new PrimitiveConverter(){

                public final void addLong(long value) {
                    BigDecimal bd = new BigDecimal(BigInteger.valueOf(value), scale);
                    parent.addDouble(bd.doubleValue());
                }
            };
        }
        if (ParquetSchemaConverter.TIMESTAMP_ORIGINAL_TYPES.contains(originalTypeStr) && (dssType == null || dssType == Type.DATE || dssType == Type.DATETIMENOTZ)) {
            boolean isMicros = originalTypeStr.equals("TIMESTAMP_MICROS");
            boolean toDSSDate = dssType == null || dssType == Type.DATE;
            return new HiveDateConverter(parent, toDSSDate, isMicros);
        }
        return new PrimitiveConverter(){

            public final void addLong(long value) {
                parent.addLong(value);
            }
        };
    }

    private static PrimitiveConverter createPrimitiveInt32Converter(final ParentValueContainer parent, Type dssType, PrimitiveType pt) {
        if (pt.getOriginalType() == OriginalType.DECIMAL && pt.getDecimalMetadata() != null) {
            final int scale = pt.getDecimalMetadata().getScale();
            return new PrimitiveConverter(){

                public final void addInt(int value) {
                    BigDecimal bd = new BigDecimal(BigInteger.valueOf(value), scale);
                    parent.addDouble(bd.doubleValue());
                }
            };
        }
        if (pt.getOriginalType() == OriginalType.DATE) {
            if (dssType == Type.DATE) {
                return new HiveDateConverter(parent, true, false);
            }
            if (dssType != null && dssType.isInteger()) {
                return new PrimitiveConverter(){

                    public final void addInt(int value) {
                        parent.addInteger(value);
                    }
                };
            }
            return new HiveDateOnlyConverter(parent);
        }
        return new PrimitiveConverter(){

            public final void addInt(int value) {
                parent.addInteger(value);
            }
        };
    }

    private PrimitiveConverter createPrimitiveBinaryConverter(final ParentValueContainer parent, PrimitiveType pt) {
        if (pt.getOriginalType() == OriginalType.DECIMAL && pt.getDecimalMetadata() != null) {
            final int scale = pt.getDecimalMetadata().getScale();
            return new PrimitiveConverter(){

                public final void addBinary(Binary value) {
                    BigDecimal bd = new BigDecimal(new BigInteger(value.getBytes()), scale);
                    parent.addDouble(bd.doubleValue());
                }
            };
        }
        if (this.hiveLikeFlavors.contains((Object)this.flavor) || pt.getOriginalType() == OriginalType.UTF8) {
            return new PrimitiveConverter(){

                public final void addBinary(Binary value) {
                    parent.addString(value.toStringUsingUTF8());
                }
            };
        }
        return new PrimitiveConverter(){

            public void addBinary(Binary value) {
                String b64 = BaseEncoding.base64().encode(value.getBytes());
                parent.addString(b64);
            }
        };
    }
}

